/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import java.util.ArrayList;
import java.util.List;

public class ToolbarTabDockStation
extends StackDockStation
implements OrientedDockStation {
    private List<OrientingDockStationListener> listeners = new ArrayList<OrientingDockStationListener>(5);
    private Orientation orientation = Orientation.VERTICAL;

    public ToolbarTabDockStation() {
        this.setSmallMinimumSize(false);
        this.setTitleIcon(null);
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation orientation) {
                if (orientation != null) {
                    ToolbarTabDockStation.this.setOrientation(orientation);
                }
            }
        };
    }

    @Override
    public String getFactoryID() {
        return "ToolbarTabDockStation";
    }

    @Override
    public Orientation getOrientationOf(Dockable dockable) {
        return this.orientation;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.listeners.add(orientingDockStationListener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener orientingDockStationListener) {
        this.listeners.remove(orientingDockStationListener);
    }

    @Override
    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            OrientingDockStationEvent orientingDockStationEvent = new OrientingDockStationEvent(this);
            for (OrientingDockStationListener orientingDockStationListener : this.listeners.toArray(new OrientingDockStationListener[this.listeners.size()])) {
                orientingDockStationListener.changed(orientingDockStationEvent);
            }
        }
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }
}

