/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;

public abstract class ListDockableStationPerspective
implements PerspectiveStation,
PerspectiveDockable {
    private PerspectiveStation parent;
    private PerspectivePlaceholderList<PerspectiveDockable> dockables = new PerspectivePlaceholderList();

    public ListDockableStationPerspective() {
    }

    public ListDockableStationPerspective(PerspectiveDockable[] perspectiveDockableArray) {
        for (PerspectiveDockable perspectiveDockable : perspectiveDockableArray) {
            DockUtilities.ensureTreeValidity(this, perspectiveDockable);
            perspectiveDockable.setParent(this);
            this.dockables.dockables().add(perspectiveDockable);
        }
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public PerspectiveDockable getDockable(int n) {
        return (PerspectiveDockable)this.dockables.dockables().get(n);
    }

    public int indexOf(PerspectiveDockable perspectiveDockable) {
        return this.dockables.dockables().indexOf(perspectiveDockable);
    }

    public void add(PerspectiveDockable perspectiveDockable) {
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        this.dockables.dockables().add(perspectiveDockable);
        perspectiveDockable.setParent(this);
    }

    public void add(int n, PerspectiveDockable perspectiveDockable) {
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        this.dockables.dockables().add(n, perspectiveDockable);
        perspectiveDockable.setParent(this);
    }

    public PerspectivePlaceholderList<PerspectiveDockable> getDockables() {
        return this.dockables;
    }

    protected void setDockables(PerspectivePlaceholderList<PerspectiveDockable> perspectivePlaceholderList) {
        this.dockables = perspectivePlaceholderList;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.dockables.dockables().indexOf(perspectiveDockable);
        Path path = null;
        path = perspectiveDockable2 != null ? perspectiveDockable2.getPlaceholder() : perspectiveDockable.getPlaceholder();
        return this.getDockableProperty(n, path, perspectiveDockable, perspectiveDockable2);
    }

    protected abstract DockableProperty getDockableProperty(int var1, Path var2, PerspectiveDockable var3, PerspectiveDockable var4);

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholderMap);
    }

    public PerspectiveDockable remove(int n) {
        PerspectiveDockable perspectiveDockable = this.getDockable(n);
        this.dockables.remove(n);
        perspectiveDockable.setParent(null);
        return perspectiveDockable;
    }

    @Override
    public boolean remove(PerspectiveDockable perspectiveDockable) {
        int n = this.indexOf(perspectiveDockable);
        if (n == -1) {
            return false;
        }
        this.dockables.remove(n);
        perspectiveDockable.setParent(null);
        return true;
    }

    @Override
    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.dockables.dockables().indexOf(perspectiveDockable);
        if (n < 0) {
            throw new IllegalArgumentException("oldDockable is not child of this station");
        }
        DockUtilities.ensureTreeValidity(this, perspectiveDockable2);
        this.dockables.remove(n);
        this.dockables.dockables().add(n, perspectiveDockable2);
        perspectiveDockable.setParent(null);
        perspectiveDockable2.setParent(this);
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public void setParent(PerspectiveStation perspectiveStation) {
        this.parent = perspectiveStation;
    }
}

