/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.DefaultToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarContainerDockStationFactory
implements DockFactory<ToolbarContainerDockStation, ToolbarContainerDockPerspective, ToolbarContainerDockStationLayout> {
    public static final String ID = "ToolbarContainerDockStationFactory";

    @Override
    public String getID() {
        return ID;
    }

    protected ToolbarContainerConverter createConverter() {
        return new DefaultToolbarContainerConverter();
    }

    @Override
    public ToolbarContainerDockStationLayout getLayout(ToolbarContainerDockStation toolbarContainerDockStation, Map<Dockable, Integer> map) {
        return new ToolbarContainerDockStationLayout(toolbarContainerDockStation.getPlaceholders(map));
    }

    @Override
    public ToolbarContainerDockStationLayout getPerspectiveLayout(ToolbarContainerDockPerspective toolbarContainerDockPerspective, Map<PerspectiveDockable, Integer> map) {
        PlaceholderMap placeholderMap = this.createConverter().getPlaceholders(toolbarContainerDockPerspective, map);
        return new ToolbarContainerDockStationLayout(placeholderMap);
    }

    @Override
    public void setLayout(ToolbarContainerDockStation toolbarContainerDockStation, ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        toolbarContainerDockStation.setPlaceholders(toolbarContainerDockStationLayout.getPlaceholders(), map);
    }

    @Override
    public void setLayout(ToolbarContainerDockStation toolbarContainerDockStation, ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, PlaceholderStrategy placeholderStrategy) {
    }

    @Override
    public void write(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        toolbarContainerDockStationLayout.getPlaceholders().write(dataOutputStream);
    }

    @Override
    public void write(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, XElement xElement) {
        toolbarContainerDockStationLayout.getPlaceholders().write(xElement.addElement("placeholders"));
    }

    @Override
    public ToolbarContainerDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        PlaceholderMap placeholderMap = new PlaceholderMap(dataInputStream, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        return new ToolbarContainerDockStationLayout(placeholderMap);
    }

    @Override
    public ToolbarContainerDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        XElement xElement2 = xElement.getElement("placeholders");
        PlaceholderMap placeholderMap = new PlaceholderMap(xElement2, placeholderStrategy);
        placeholderMap.setPlaceholderStrategy(null);
        return new ToolbarContainerDockStationLayout(placeholderMap);
    }

    @Override
    public void estimateLocations(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, final LocationEstimationMap locationEstimationMap) {
        PlaceholderMap placeholderMap = toolbarContainerDockStationLayout.getPlaceholders();
        if (!placeholderMap.getFormat().equals(new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown type: " + placeholderMap.getFormat());
        }
        PlaceholderMap placeholderMap2 = placeholderMap.getMap(placeholderMap.newKey("content", new Path[0]), "list");
        DockablePlaceholderList.simulatedRead(placeholderMap2, new PlaceholderListItemAdapter<Dockable, Dockable>(){

            @Override
            public Dockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                int n = convertedPlaceholderListItem.getInt("id");
                int n2 = convertedPlaceholderListItem.getInt("index");
                Path path = null;
                if (convertedPlaceholderListItem.contains("placeholder")) {
                    path = new Path(convertedPlaceholderListItem.getString("placeholder"));
                }
                locationEstimationMap.setLocation(n, new ToolbarContainerProperty(n2, path));
                int n3 = locationEstimationMap.getSubChildCount(n);
                for (int i = 0; i < n3; ++i) {
                    DockLayoutInfo dockLayoutInfo = locationEstimationMap.getSubChild(n, i);
                    dockLayoutInfo.setLocation(new ToolbarContainerProperty(n2, dockLayoutInfo.getPlaceholder()));
                }
                return null;
            }
        });
    }

    @Override
    public ToolbarContainerDockStation layout(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        ToolbarContainerDockStation toolbarContainerDockStation = this.createStation();
        this.setLayout(toolbarContainerDockStation, toolbarContainerDockStationLayout, map, placeholderStrategy);
        return toolbarContainerDockStation;
    }

    @Override
    public ToolbarContainerDockStation layout(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, PlaceholderStrategy placeholderStrategy) {
        ToolbarContainerDockStation toolbarContainerDockStation = this.createStation();
        this.setLayout(toolbarContainerDockStation, toolbarContainerDockStationLayout, placeholderStrategy);
        return toolbarContainerDockStation;
    }

    @Override
    public ToolbarContainerDockPerspective layoutPerspective(ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        return new ToolbarContainerDockPerspective(toolbarContainerDockStationLayout, map);
    }

    @Override
    public void layoutPerspective(ToolbarContainerDockPerspective toolbarContainerDockPerspective, ToolbarContainerDockStationLayout toolbarContainerDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        toolbarContainerDockPerspective.read(toolbarContainerDockStationLayout, map);
    }

    protected ToolbarContainerDockStation createStation() {
        return new ToolbarContainerDockStation(ToolbarContainerDockStation.DEFAULT_ORIENTATION);
    }
}

