#ifndef __OPENCL_VERSION__ //This should fail during an actual openCL compile, used only to trick Eclipse into syntax highlighting this file as "C" code.
#define __kernel
#define __global
#define kernel
#define global
#define constant
#define local
#define float2 float
#define float3 float
#define float4 float
#define uchar4 char
#endif

constant int searchHalfSize = 10;
constant int searchSize = 2*10+1;
constant int searchSurface = (2*10+1)*(2*10+1);

constant int dualNormalSearchHalfSize = 7;
constant int dualNormalSearchSize = 2*7+1;
constant int dualNormalSearchSurface = 225;

int2 getNbNeighborsAndOutliers_normals(global const uchar4 *normals, int gx, int gy, int W, int searchHalfSize, float4 normalInfo, float normalDotThreshold)
{
	int H = (int)(W/2);

	int ir, ic, iCol, iRow;
	float4 normalInfoNeighbor;
	
	int nbNormals = 0;
	int nbNormalOutliers = 0;
	for (ic=-searchHalfSize; ic<=searchHalfSize; ic++)
	{
		iCol = gx+ic;
		if (iCol<0) iCol+=W;
		if (iCol>=W) iCol-=W;
		for (ir=-searchHalfSize; ir<=searchHalfSize; ir++)
		{
			iRow = gy+ir;
			if ((iRow>=0)&&(iRow<H))
			{
				normalInfoNeighbor = getNormalInfo(normals, iCol, iRow, W, H);
				if (normalInfoNeighbor.w!=255)
				{
					nbNormals++;
					float fdot = fabs(dot(normalInfoNeighbor.xyz, normalInfo.xyz));
					if (fdot<normalDotThreshold)
						nbNormalOutliers++;
				}
			}
		}	
	}	
	
	return (int2)(nbNormals, nbNormalOutliers);
}
kernel void computeDualNormal(global const uchar4 *src, global const uchar4 *normals, global const int *flatFlags, __global uchar4 *results, int W, int scoreThreshold, float fillRatioThreshold)
{
	float theta_1pixel = (float)(2.f*M_PI_F/(float)W);
	float pixelDimension_1meter = 2.f*tan(0.5f*theta_1pixel);


	int gx = get_global_id(0);
	int gy = get_global_id(1);
	uchar4 argb = src[W*gy+gx];
	int isFlat = flatFlags[W*gy+gx];
	
	
	int H = (int)(W/2);
	
	
	float3 localCoords = getDepthBufferLocalCoordinates(argb, gx, gy, W, H);
	float x = localCoords.x;
	float y = localCoords.y;
	float z = localCoords.z;

	float4 normalInfo = getNormalInfo(normals, gx, gy, W, H);

	if ( (((x!=0.f)||(y!=0.f)||(z!=0.f))) && (normalInfo.w!=255) && (isFlat==0) )
	{
		float4 normalNeighborsGrid[225] = {0};
		int normalNeighborsGrid_flags[225] = {0};
		int normalNeighborsGrid_topologyIds[225] = {0};
		
		float4 normalInfoNeighbor;
	
		uchar4 argbNeigh;
		float3 neighbor;
		float3 neighborsGrid[225] = {0};
		int neighborsGrid_flags[225] = {0};
		int neighborsGrid_topologyIds[225] = {0};
		float3 pivot;

		int ic, ir;
		int iCol;
		int iRow;
		int coldum, rowdum;
		float dist;
	
		if (normalInfo.w!=255)
		{
			for (ic=-dualNormalSearchHalfSize; ic<=dualNormalSearchHalfSize; ic++)
			{
				iCol = gx+ic;
				if (iCol<0) iCol+=W;
				if (iCol>=W) iCol-=W;
				for (ir=-dualNormalSearchHalfSize; ir<=dualNormalSearchHalfSize; ir++)
				{
					iRow = gy+ir;
					if ((iRow>=0)&&(iRow<H))
					{
						normalInfoNeighbor = getNormalInfo(normals, iCol, iRow, W, H);
						if (normalInfoNeighbor.w!=255)
						{
							normalNeighborsGrid[(dualNormalSearchHalfSize+ir)*dualNormalSearchSize + dualNormalSearchHalfSize+ic] = normalInfoNeighbor;
						}
	
						argbNeigh = src[W*iRow+iCol];
						neighbor = getDepthBufferLocalCoordinates(argbNeigh, iCol, iRow, W, H);
						if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
						{
							neighborsGrid[(dualNormalSearchHalfSize+ir)*dualNormalSearchSize + dualNormalSearchHalfSize+ic] = neighbor;
						}
					}
				}
			}
		}
		
		neighborsGrid_flags[(dualNormalSearchHalfSize)*dualNormalSearchSize+dualNormalSearchHalfSize] = 1;
		int bFoundSpatialNeighbor;
		float pivotDistToCenter;
		for (iRow=0; iRow<dualNormalSearchSize; iRow++)
		{
			for (iCol=0; iCol<dualNormalSearchSize; iCol++)
			{
				pivot = neighborsGrid[iRow*dualNormalSearchSize+iCol];
				
				pivotDistToCenter = sqrt(pivot.x*pivot.x+pivot.y*pivot.y+pivot.z*pivot.z);

				bFoundSpatialNeighbor = 0;
				if ((pivot.x!=0.f)||(pivot.y!=0.f)||(pivot.z!=0.f))
				{
					for (ir=-1; ir<=1; ir++)
					{
						rowdum = iRow+ir;
						if ((rowdum>=0)&&(rowdum<dualNormalSearchSize))
						{
							for (ic=-1; ic<=1; ic++)
							{
								if ((ir!=0)||(ic!=0))
								{
									coldum = iCol+ic;
									if ((coldum>=0)&&(coldum<dualNormalSearchSize))
									{
										neighbor = neighborsGrid[rowdum*dualNormalSearchSize+coldum];
										if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
										{
											dist = sqrt((pivot.x-neighbor.x)*(pivot.x-neighbor.x)+(pivot.y-neighbor.y)*(pivot.y-neighbor.y)+(pivot.z-neighbor.z)*(pivot.z-neighbor.z));
											if (dist<2.f*pixelDimension_1meter*pivotDistToCenter)
											{
												neighborsGrid_flags[iRow*dualNormalSearchSize+iCol] = 1;
												bFoundSpatialNeighbor = 1;
												break;
											}
										}
									}
								}
							}
						}
						if (bFoundSpatialNeighbor==1)
						{
							break;
						}
					}
				}
			}
		}
		identifyDistinctForms(neighborsGrid_flags, neighborsGrid_topologyIds, dualNormalSearchSize, dualNormalSearchSize);
		int centricFormId = neighborsGrid_topologyIds[(dualNormalSearchHalfSize)*dualNormalSearchSize+dualNormalSearchHalfSize];
		

		float3 neighbors[225] = {0};
		float3 normalVirtualPoints[450] = {0};
		int nbNeighbors = 0;
		int nbVirtualPoints = 0;
		for (int i=0; i<dualNormalSearchSize*dualNormalSearchSize; i++)
		{
			if (neighborsGrid_topologyIds[i]==centricFormId)
			{
			 	neighbor = neighborsGrid[i];
			 	normalInfoNeighbor = normalNeighborsGrid[i];
			 	if ( ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f)) && (normalInfoNeighbor.w!=255) )
			 	{
			 		neighbors[nbNeighbors].xyz = neighbor.xyz;
			 		nbNeighbors++;
			 		normalVirtualPoints[nbVirtualPoints] = (float3)(normalInfoNeighbor.x, normalInfoNeighbor.y, normalInfoNeighbor.z);
			 		nbVirtualPoints++;
			 		normalVirtualPoints[nbVirtualPoints] = (float3)(-normalInfoNeighbor.x, -normalInfoNeighbor.y, -normalInfoNeighbor.z);
			 		nbVirtualPoints++;						
			 	}
			}
		}
		
		int nbNeighborsMin = (int)(fillRatioThreshold*dualNormalSearchSurface);
		
		if (nbNeighbors>nbNeighborsMin)
		{
			float4 dualNormal = getNormalBestFit(normalVirtualPoints, nbVirtualPoints);
			float scoreLog = round(log10(1.f/dualNormal.w));
			int scoreInt = min((int)scoreLog, 255);	
			if (scoreInt>=scoreThreshold)
			{
				float3 localDualN = dualNormal.xyz;
				if (dot(localDualN, localCoords)<0.f)
				{
					localDualN.x = -localDualN.x;
					localDualN.y = -localDualN.y;
					localDualN.z = -localDualN.z;
				}
				uchar8 dualNormalInfo = motorLocalNormalInfo2uchar(localDualN.x, localDualN.y, localDualN.z, dualNormal.w);
	  			results[W*gy+gx].x = dualNormalInfo.s0; 		//BLEU
	  			results[W*gy+gx].y = dualNormalInfo.s1; 		//VERT
	  			results[W*gy+gx].z = dualNormalInfo.s2; 		//ROUGE
	  			results[W*gy+gx].w = dualNormalInfo.s3; 		//ALPHA	
	  		
	  			results[W*(gy+H)+gx].x = dualNormalInfo.s4; 	//BLEU
	  			results[W*(gy+H)+gx].y = dualNormalInfo.s5; 	//VERT
	  			results[W*(gy+H)+gx].z = dualNormalInfo.s6; 	//ROUGE
	  			results[W*(gy+H)+gx].w = dualNormalInfo.s7; 	//ALPHA	
			}
		}
	}
}
kernel void identifyFlatAreas(global const uchar4 *src, global const uchar4 *normals, __global int *results, int W, int flatAreaSearchHalfSize, float normalDotThreshold, float ratioNbNormalOutliers)
{
	int gx = get_global_id(0);
	int gy = get_global_id(1);
	uchar4 argb = src[W*gy+gx];
	
	int H = (int)(W/2);

	float3 localCoords = getDepthBufferLocalCoordinates(argb, gx, gy, W, H);
	float x = localCoords.x;
	float y = localCoords.y;
	float z = localCoords.z;

	int ic, ir, iCol, iRow;
	float4 normalInfo = getNormalInfo(normals, gx, gy, W, H);

	if ( (((x!=0.f)||(y!=0.f)||(z!=0.f))) && (normalInfo.w!=255) )
	{
	
		int2 nbNeighborsAndOutliers = getNbNeighborsAndOutliers_normals(normals, gx, gy, W, flatAreaSearchHalfSize, normalInfo, normalDotThreshold);
		int nbNormals = nbNeighborsAndOutliers.x;
		int nbNormalOutliers = nbNeighborsAndOutliers.y;

		if (nbNormalOutliers<ratioNbNormalOutliers*nbNormals)
		{
			results[W*gy+gx] = 1;	
		}
	}
}
kernel void checkQualityDualNormal(global const uchar4 *dualNormals, __global uchar4 *dualNormalsOptimized, int W, int dualNormalQualityCheckHalfSize, float dualNormalDotThreshold, float ratioNbDualNormalOutliers)
{
	int gx = get_global_id(0);
	int gy = get_global_id(1);

	int H = (int)(W/2);

	float4 dualNormalInfo = getNormalInfo(dualNormals, gx, gy, W, H);

	int ir, ic, iCol, iRow;
		
	if ( (dualNormalInfo.w!=255) )
	{
		int2 nbNeighborsAndOutliers = getNbNeighborsAndOutliers_normals(dualNormals, gx, gy, W, dualNormalQualityCheckHalfSize, dualNormalInfo, dualNormalDotThreshold);
		int nbDualNormals = nbNeighborsAndOutliers.x;
		int nbDualNormalOutliers = nbNeighborsAndOutliers.y;
	
		if (nbDualNormalOutliers<ratioNbDualNormalOutliers*nbDualNormals)
		{
			dualNormalsOptimized[W*gy+gx].x = dualNormals[W*gy+gx].x; 		//BLEU
	  		dualNormalsOptimized[W*gy+gx].y = dualNormals[W*gy+gx].y; 		//VERT
	  		dualNormalsOptimized[W*gy+gx].z = dualNormals[W*gy+gx].z; 		//ROUGE
	  		dualNormalsOptimized[W*gy+gx].w = dualNormals[W*gy+gx].w; 		//ALPHA	
			dualNormalsOptimized[W*(gy+H)+gx].x = dualNormals[W*(gy+H)+gx].x; 		//BLEU
	  		dualNormalsOptimized[W*(gy+H)+gx].y = dualNormals[W*(gy+H)+gx].y; 		//VERT
	  		dualNormalsOptimized[W*(gy+H)+gx].z = dualNormals[W*(gy+H)+gx].z; 		//ROUGE
	  		dualNormalsOptimized[W*(gy+H)+gx].w = dualNormals[W*(gy+H)+gx].w; 		//ALPHA	
		}
		else
		{
			dualNormalsOptimized[W*gy+gx].x = 0; 		//BLEU
	  		dualNormalsOptimized[W*gy+gx].y = 0; 		//VERT
	  		dualNormalsOptimized[W*gy+gx].z = 0; 		//ROUGE
	  		dualNormalsOptimized[W*gy+gx].w = 0; 		//ALPHA	
			dualNormalsOptimized[W*(gy+H)+gx].x = 0; 		//BLEU
	  		dualNormalsOptimized[W*(gy+H)+gx].y = 0; 		//VERT
	  		dualNormalsOptimized[W*(gy+H)+gx].z = 0; 		//ROUGE
	  		dualNormalsOptimized[W*(gy+H)+gx].w = 0; 		//ALPHA	
		}
	}
}
kernel void computeNormalAdaptive(global const uchar4 *srcDepthBuffer, __global uchar4 *destNormalBuffer, int srcDepthBufferWidth, int destNormalBufferWidth)
{
	float theta_1pixel = (float)(2.f*M_PI_F/(float)srcDepthBufferWidth);
	float pixelDimension_1meter = 2.f*tan(0.5f*theta_1pixel);
	int srcDepthBufferHeight = srcDepthBufferWidth/2;
	int srcDepthBufferSize = srcDepthBufferWidth*srcDepthBufferHeight;
	int destNormalBufferHeight = destNormalBufferWidth/2;
	int destNormalBufferSize = destNormalBufferWidth*destNormalBufferWidth;

	int gx = get_global_id(0);
	int gy = get_global_id(1);
	
	if ((gy*destNormalBufferWidth+gx>=destNormalBufferSize)||(gy>=destNormalBufferHeight))
	{
		return;
	}
	int2 ColRowInDestNormalBuffer = (int2)(gx, gy);
	int2 ColRowInSrcDepthBuffer = srcColRow2destColRow_Panoramic(ColRowInDestNormalBuffer.x, ColRowInDestNormalBuffer.y, 0, destNormalBufferWidth, 0, srcDepthBufferWidth);
	
	uchar4 depthInfo = (uchar)(0);
	float3 localCoords = (float3)(0);
	
	int iPivotColInSrcDepthBuffer = -1;
	int iPivotRowInSrcDepthBuffer = -1;


	int2 pivotSearchAmplitude = (int2)(2, 2);
	int bFoundPivot = 0;
	for (int kx=0; kx<pivotSearchAmplitude.x; kx++)
	{
		for (int ky=0; ky<pivotSearchAmplitude.y; ky++)
		{
			iPivotColInSrcDepthBuffer = ColRowInSrcDepthBuffer.x+kx;
			if (iPivotColInSrcDepthBuffer>=srcDepthBufferWidth) iPivotColInSrcDepthBuffer-=srcDepthBufferWidth;
			iPivotRowInSrcDepthBuffer = ColRowInSrcDepthBuffer.y+ky;
			if (iPivotRowInSrcDepthBuffer<srcDepthBufferHeight)
			{
				depthInfo = srcDepthBuffer[srcDepthBufferWidth*iPivotRowInSrcDepthBuffer+iPivotColInSrcDepthBuffer];
				localCoords = getDepthBufferLocalCoordinates(depthInfo, iPivotColInSrcDepthBuffer, iPivotRowInSrcDepthBuffer, srcDepthBufferWidth, srcDepthBufferHeight);
				if ((localCoords.x!=0.f)||(localCoords.y!=0.f)||(localCoords.z!=0.f))
				{
					bFoundPivot = 1;
					break;
				}
			}
		}
		if (bFoundPivot==1)
		{
			break;
		}
	}

	if (bFoundPivot==0)
	{
		return;
	}
	
	float3 relativeDirection = (float3)(localCoords);
	float norm = sqrt(relativeDirection.x*relativeDirection.x + relativeDirection.y*relativeDirection.y + relativeDirection.z*relativeDirection.z);
	if (norm==0.f)
	{
		return;
	}
	relativeDirection /= norm;
	
	float x = localCoords.x;
	float y = localCoords.y;
	float z = localCoords.z;
	int ic, ir;
	int iCol;
	int iRow;
	uchar4 depthInfoNeigh;
	float3 neighbor;
	
	float3 neighborsGrid[441] = {0};
	int neighborsGrid_flags[441] = {0};
	int neighborsGrid_topologyIds[441] = {0};
	/*
	neighborsGrid = {0};
	neighborsGrid_flags = {0};
	neighborsGrid_topologyIds = {0};
	*/
	float3 pivot;
	
	int coldum, rowdum;
	float dist;

	for (ic=-searchHalfSize; ic<=searchHalfSize; ic++)
	{
		iCol = iPivotColInSrcDepthBuffer+ic;
		if (iCol<0) iCol+=srcDepthBufferWidth;
		if (iCol>=srcDepthBufferWidth) iCol-=srcDepthBufferWidth;
		for (ir=-searchHalfSize; ir<=searchHalfSize; ir++)
		{
			iRow = iPivotRowInSrcDepthBuffer+ir;
			if ((iRow>=0)&&(iRow<srcDepthBufferHeight))
			{
				depthInfoNeigh = srcDepthBuffer[srcDepthBufferWidth*iRow+iCol];
				neighbor = getDepthBufferLocalCoordinates(depthInfoNeigh, iCol, iRow, srcDepthBufferWidth, srcDepthBufferHeight);
				if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
				{
					neighborsGrid[(searchHalfSize+ir)*searchSize + searchHalfSize+ic] = neighbor;
				}
			}
		}
	}
	
	neighborsGrid_flags[(searchHalfSize)*searchSize+searchHalfSize] = 1;
	int bFoundSpatialNeighbor;
	float pivotDistToCenter;
	
	for (iRow=0; iRow<searchSize; iRow++)
	{
		for (iCol=0; iCol<searchSize; iCol++)
		{
			pivot = neighborsGrid[iRow*searchSize+iCol];
			
			pivotDistToCenter = sqrt(pivot.x*pivot.x+pivot.y*pivot.y+pivot.z*pivot.z);

			bFoundSpatialNeighbor = 0;
			if ((pivot.x!=0.f)||(pivot.y!=0.f)||(pivot.z!=0.f))
			{
				for (ir=-1; ir<=1; ir++)
				{
					rowdum = iRow+ir;
					if ((rowdum>=0)&&(rowdum<searchSize))
					{
						for (ic=-1; ic<=1; ic++)
						{
							if ((ir!=0)||(ic!=0))
							{
								coldum = iCol+ic;
								if ((coldum>=0)&&(coldum<searchSize))
								{
									neighbor = neighborsGrid[rowdum*searchSize+coldum];
									if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
									{
										dist = sqrt((pivot.x-neighbor.x)*(pivot.x-neighbor.x)+(pivot.y-neighbor.y)*(pivot.y-neighbor.y)+(pivot.z-neighbor.z)*(pivot.z-neighbor.z));
										if (dist<2.f*pixelDimension_1meter*pivotDistToCenter)
										{
											neighborsGrid_flags[iRow*searchSize+iCol] = 1;
											bFoundSpatialNeighbor = 1;
											break;
										}
									}
								}
							}
						}
					}
					if (bFoundSpatialNeighbor==1)
					{
						break;
					}
				}
			}
		}
	}
	
	identifyDistinctForms(neighborsGrid_flags, neighborsGrid_topologyIds, searchSize, searchSize);
	int centricFormId = neighborsGrid_topologyIds[(searchHalfSize)*searchSize+searchHalfSize];
	
	int nbNeighborsMin = (int)(0.8f*searchSurface);
	
	float3 neighbors[441] = {0};
	/*
	neighbors = {0};
	*/
	int nbNeighbors = 0;
	for (int i=0; i<searchSize*searchSize; i++)
	{
		if (neighborsGrid_topologyIds[i]==centricFormId)
		{
		 	neighbor = neighborsGrid[i];
		 	if ((neighbor.x!=0.f)||(neighbor.y!=0.f)||(neighbor.z!=0.f))
		 	{
		 		neighbors[nbNeighbors].xyz = neighbor.xyz;
		 		nbNeighbors++;
		 	}
		}
	}

	if (nbNeighbors>nbNeighborsMin)
	{
		float4 bestNormal = getNormalBestFit(neighbors, nbNeighbors);
		float3 localN = bestNormal.xyz;
		
		if (dot(localN, relativeDirection)>0.f)
		{
			//localN *= -1;
			localN.x = -localN.x;
			localN.y = -localN.y;
			localN.z = -localN.z;
		}

		uchar8 normalInfo = motorLocalNormalInfo2uchar(localN.x, localN.y, localN.z, bestNormal.w);
	
  		destNormalBuffer[destNormalBufferWidth*gy+gx].x = normalInfo.s0; 		//BLEU
  		destNormalBuffer[destNormalBufferWidth*gy+gx].y = normalInfo.s1; 		//VERT
  		destNormalBuffer[destNormalBufferWidth*gy+gx].z = normalInfo.s2; 		//ROUGE
  		destNormalBuffer[destNormalBufferWidth*gy+gx].w = normalInfo.s3; 		//ALPHA	
  		
  		destNormalBuffer[destNormalBufferWidth*(gy+destNormalBufferHeight)+gx].x = normalInfo.s4; 	//BLEU
  		destNormalBuffer[destNormalBufferWidth*(gy+destNormalBufferHeight)+gx].y = normalInfo.s5; 	//VERT
  		destNormalBuffer[destNormalBufferWidth*(gy+destNormalBufferHeight)+gx].z = normalInfo.s6; 	//ROUGE
  		destNormalBuffer[destNormalBufferWidth*(gy+destNormalBufferHeight)+gx].w = normalInfo.s7; 	//ALPHA	
	}
}
kernel void calculeGradiantDistance(global uchar4 *depthBuffer, global int *gradiantBuffer, int depthW, int depthH, float maxAmplitudeDistanceAtOneMeter)
{
	int depthCol = get_global_id(0);
	int depthRow = get_global_id(1);
	if ((depthCol>=depthW)||(depthRow>=depthH))
	{
		return;
	}
	int depthIndex = depthRow*depthW+depthCol;

	uchar4 depthInfo = depthBuffer[depthIndex];
	float3 localCoords = getDepthBufferLocalCoordinates(depthInfo, depthCol, depthRow, depthW, depthH);
	if ((localCoords.x==0.f)&&(localCoords.y==0.f)&&(localCoords.z==0.f))
	{
		return;
	}
	float currentDistance = getDepthBufferLocalDistance(depthInfo);
	
	int offsetMax = 10;
	int bFoundPreviousCol = 0;
	int bDone = 0;
	int previousCol = depthCol-1;
	int offsetPreviousCol = 1;
	uchar4 depthInfoPreviousCol = (uchar4)(0);
	while (bDone==0)
	{
		if (previousCol<0) previousCol+=depthW;
		int depthIndexPreviousCol = depthRow*depthW + previousCol;
		depthInfoPreviousCol = depthBuffer[depthIndexPreviousCol];
		if ((depthInfoPreviousCol.x!=0.f)||(depthInfoPreviousCol.y!=0.f)||(depthInfoPreviousCol.z!=0.f))
		{
			bFoundPreviousCol = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousCol--;
			offsetPreviousCol++;
			if (offsetPreviousCol>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}
	float previousDistance;
	float gradiantDistance;
	float gradiantNorm = 0;
	if (bFoundPreviousCol)
	{
		previousDistance = getDepthBufferLocalDistance(depthInfoPreviousCol);
		gradiantDistance = (currentDistance-previousDistance)/offsetPreviousCol;
		gradiantNorm += gradiantDistance*gradiantDistance;
	}
	
	
	
	int bFoundPreviousRow = 0;
	bDone = 0;
	int previousRow = depthRow-1;
	int offsetPreviousRow = 1;
	uchar4 depthInfoPreviousRow = (uchar4)(0);
	while (bDone==0)
	{
		if (previousRow<0)
		{
			bDone = 1;
			break;
		}
		int depthIndexPreviousRow = previousRow*depthW + depthCol;
		depthInfoPreviousRow = depthBuffer[depthIndexPreviousRow];
		if ((depthInfoPreviousRow.x!=0.f)||(depthInfoPreviousRow.y!=0.f)||(depthInfoPreviousRow.z!=0.f))
		{
			bFoundPreviousRow = 1;
			bDone = 1;
			break;
		}
		else
		{
			previousRow--;
			offsetPreviousRow++;
			if (offsetPreviousRow>offsetMax)
			{
				bDone = 1;
				break;
			}
		}
	}	
	if (bFoundPreviousRow)
	{
		previousDistance = getDepthBufferLocalDistance(depthInfoPreviousRow);
		gradiantDistance = (currentDistance-previousDistance)/offsetPreviousRow;
		gradiantNorm += gradiantDistance*gradiantDistance;
	}
	
	gradiantNorm = sqrt(gradiantNorm);
	gradiantBuffer[depthIndex] = min(255, (int)(255.f*gradiantNorm/(maxAmplitudeDistanceAtOneMeter*currentDistance)));	
}
