/*
 * Decompiled with CFR 0.152.
 */
package com.cryptlex.lexfloatclient;

public class LexFloatClientException
extends Exception {
    int errorCode;
    public static final int LF_OK = 0;
    public static final int LF_FAIL = 1;
    public static final int LF_E_PRODUCT_ID = 40;
    public static final int LF_E_CALLBACK = 41;
    public static final int LF_E_HOST_URL = 42;
    public static final int LF_E_TIME = 43;
    public static final int LF_E_INET = 44;
    public static final int LF_E_NO_LICENSE = 45;
    public static final int LF_E_LICENSE_EXISTS = 46;
    public static final int LF_E_LICENSE_NOT_FOUND = 47;
    public static final int LF_E_LICENSE_EXPIRED_INET = 48;
    public static final int LF_E_LICENSE_LIMIT_REACHED = 49;
    public static final int LF_E_BUFFER_SIZE = 50;
    public static final int LF_E_METADATA_KEY_NOT_FOUND = 51;
    public static final int LF_E_METADATA_KEY_LENGTH = 52;
    public static final int LF_E_METADATA_VALUE_LENGTH = 53;
    public static final int LF_E_FLOATING_CLIENT_METADATA_LIMIT = 54;
    public static final int LF_E_METER_ATTRIBUTE_NOT_FOUND = 55;
    public static final int LF_E_METER_ATTRIBUTE_USES_LIMIT_REACHED = 56;
    public static final int LF_E_PRODUCT_VERSION_NOT_LINKED = 57;
    public static final int LF_E_FEATURE_FLAG_NOT_FOUND = 58;
    public static final int LF_E_IP = 60;
    public static final int LF_E_CLIENT = 70;
    public static final int LF_E_SERVER = 71;
    public static final int LF_E_SERVER_TIME_MODIFIED = 72;
    public static final int LF_E_SERVER_LICENSE_NOT_ACTIVATED = 73;
    public static final int LF_E_SERVER_LICENSE_EXPIRED = 74;
    public static final int LF_E_SERVER_LICENSE_SUSPENDED = 75;
    public static final int LF_E_SERVER_LICENSE_GRACE_PERIOD_OVER = 76;

    public LexFloatClientException(String message) {
        super(message);
    }

    public LexFloatClientException(int errorCode) {
        super(LexFloatClientException.getErrorMessage(errorCode));
        this.errorCode = errorCode;
    }

    public int getCode() {
        return this.errorCode;
    }

    public static String getErrorMessage(int errorCode) {
        String message;
        switch (errorCode) {
            case 40: {
                message = "The product id is incorrect.";
                break;
            }
            case 41: {
                message = "Invalid or missing callback function.";
                break;
            }
            case 42: {
                message = "Missing or invalid server url.";
                break;
            }
            case 43: {
                message = "Ensure system date and time settings are correct.";
                break;
            }
            case 44: {
                message = "Failed to connect to the server due to network error.";
                break;
            }
            case 45: {
                message = "License has not been leased yet.";
                break;
            }
            case 46: {
                message = "License has already been leased.";
                break;
            }
            case 47: {
                message = "License does not exist on server or has already expired.";
                break;
            }
            case 48: {
                message = "License lease has expired due to network error.";
                break;
            }
            case 49: {
                message = "The server has reached it's allowed limit of floating licenses.";
                break;
            }
            case 50: {
                message = "The buffer size was smaller than required.";
                break;
            }
            case 51: {
                message = "The metadata key does not exist.";
                break;
            }
            case 52: {
                message = "Metadata key length is more than 256 characters.";
                break;
            }
            case 53: {
                message = "Metadata value length is more than 256 characters.";
                break;
            }
            case 54: {
                message = "The floating client has reached it's metadata fields limit.";
                break;
            }
            case 55: {
                message = "The meter attribute does not exist.";
                break;
            }
            case 56: {
                message = "The meter attribute has reached it's usage limit.";
                break;
            }
            case 57: {
                message = "No product version is linked with the license.";
                break;
            }
            case 58: {
                message = "The product version feature flag does not exist.";
                break;
            }
            case 60: {
                message = "IP address is not allowed.";
                break;
            }
            case 70: {
                message = "Client error.";
                break;
            }
            case 71: {
                message = "Server error.";
                break;
            }
            case 72: {
                message = "System time on server has been tampered with.";
                break;
            }
            case 73: {
                message = "The server has not been activated using a license key.";
                break;
            }
            case 74: {
                message = "The server license has expired.";
                break;
            }
            case 75: {
                message = "The server license has been suspended.";
                break;
            }
            case 76: {
                message = "The grace period for server license is over.";
                break;
            }
            default: {
                message = "Unknown error!";
            }
        }
        return message;
    }
}

