/*
 * Decompiled with CFR 0.152.
 */
package com.cryptlex.lexactivator;

public class LexActivatorException
extends Exception {
    int errorCode;
    public static final int LA_E_FILE_PATH = 40;
    public static final int LA_E_PRODUCT_FILE = 41;
    public static final int LA_E_PRODUCT_DATA = 42;
    public static final int LA_E_PRODUCT_ID = 43;
    public static final int LA_E_SYSTEM_PERMISSION = 44;
    public static final int LA_E_FILE_PERMISSION = 45;
    public static final int LA_E_WMIC = 46;
    public static final int LA_E_TIME = 47;
    public static final int LA_E_INET = 48;
    public static final int LA_E_NET_PROXY = 49;
    public static final int LA_E_HOST_URL = 50;
    public static final int LA_E_BUFFER_SIZE = 51;
    public static final int LA_E_APP_VERSION_LENGTH = 52;
    public static final int LA_E_REVOKED = 53;
    public static final int LA_E_LICENSE_KEY = 54;
    public static final int LA_E_LICENSE_TYPE = 55;
    public static final int LA_E_OFFLINE_RESPONSE_FILE = 56;
    public static final int LA_E_OFFLINE_RESPONSE_FILE_EXPIRED = 57;
    public static final int LA_E_ACTIVATION_LIMIT = 58;
    public static final int LA_E_ACTIVATION_NOT_FOUND = 59;
    public static final int LA_E_DEACTIVATION_LIMIT = 60;
    public static final int LA_E_TRIAL_NOT_ALLOWED = 61;
    public static final int LA_E_TRIAL_ACTIVATION_LIMIT = 62;
    public static final int LA_E_MACHINE_FINGERPRINT = 63;
    public static final int LA_E_METADATA_KEY_LENGTH = 64;
    public static final int LA_E_METADATA_VALUE_LENGTH = 65;
    public static final int LA_E_ACTIVATION_METADATA_LIMIT = 66;
    public static final int LA_E_TRIAL_ACTIVATION_METADATA_LIMIT = 67;
    public static final int LA_E_METADATA_KEY_NOT_FOUND = 68;
    public static final int LA_E_TIME_MODIFIED = 69;
    public static final int LA_E_RELEASE_VERSION_FORMAT = 70;
    public static final int LA_E_AUTHENTICATION_FAILED = 71;
    public static final int LA_E_METER_ATTRIBUTE_NOT_FOUND = 72;
    public static final int LA_E_METER_ATTRIBUTE_USES_LIMIT_REACHED = 73;
    public static final int LA_E_CUSTOM_FINGERPRINT_LENGTH = 74;
    public static final int LA_E_PRODUCT_VERSION_NOT_LINKED = 75;
    public static final int LA_E_FEATURE_FLAG_NOT_FOUND = 76;
    public static final int LA_E_RELEASE_VERSION_NOT_ALLOWED = 77;
    public static final int LA_E_RELEASE_PLATFORM_LENGTH = 78;
    public static final int LA_E_RELEASE_CHANNEL_LENGTH = 79;
    public static final int LA_E_VM = 80;
    public static final int LA_E_COUNTRY = 81;
    public static final int LA_E_IP = 82;
    public static final int LA_E_CONTAINER = 83;
    public static final int LA_E_RELEASE_VERSION = 84;
    public static final int LA_E_RELEASE_PLATFORM = 85;
    public static final int LA_E_RELEASE_CHANNEL = 86;
    public static final int LA_E_USER_NOT_AUTHENTICATED = 87;
    public static final int LA_E_TWO_FACTOR_AUTHENTICATION_CODE_MISSING = 88;
    public static final int LA_E_TWO_FACTOR_AUTHENTICATION_CODE_INVALID = 89;
    public static final int LA_E_RATE_LIMIT = 90;
    public static final int LA_E_SERVER = 91;
    public static final int LA_E_CLIENT = 92;
    public static final int LA_E_LOGIN_TEMPORARILY_LOCKED = 100;
    public static final int LA_E_AUTHENTICATION_ID_TOKEN_INVALID = 101;
    public static final int LA_E_OIDC_SSO_NOT_ENABLED = 102;
    public static final int LA_E_USERS_LIMIT_REACHED = 103;
    public static final int LA_E_OS_USER = 104;

    public LexActivatorException(String message) {
        super(message);
    }

    public LexActivatorException(int errorCode) {
        super(LexActivatorException.getErrorMessage(errorCode));
        this.errorCode = errorCode;
    }

    public int getCode() {
        return this.errorCode;
    }

    public static String getErrorMessage(int errorCode) {
        String message;
        switch (errorCode) {
            case 40: {
                message = "Invalid file path.";
                break;
            }
            case 41: {
                message = "Invalid or corrupted product file.";
                break;
            }
            case 42: {
                message = "Invalid product data.";
                break;
            }
            case 43: {
                message = "The product id is incorrect.";
                break;
            }
            case 44: {
                message = "Insufficient system permissions.";
                break;
            }
            case 45: {
                message = "No permission to write to file.";
                break;
            }
            case 46: {
                message = "Fingerprint couldn't be generated because Windows Management Instrumentation (WMI) service has been disabled.";
                break;
            }
            case 47: {
                message = "The difference between the network time and the system time is more than allowed clock offset.";
                break;
            }
            case 48: {
                message = "Failed to connect to the server due to network error.";
                break;
            }
            case 49: {
                message = "Invalid network proxy.";
                break;
            }
            case 50: {
                message = "Invalid Cryptlex host url.";
                break;
            }
            case 51: {
                message = "The buffer size was smaller than required.";
                break;
            }
            case 52: {
                message = "App version length is more than 256 characters.";
                break;
            }
            case 53: {
                message = "The license has been revoked.";
                break;
            }
            case 54: {
                message = "Invalid license key.";
                break;
            }
            case 55: {
                message = "Invalid license type. Make sure floating license is not being used.";
                break;
            }
            case 56: {
                message = "Invalid offline activation response file.";
                break;
            }
            case 57: {
                message = "The offline activation response has expired.";
                break;
            }
            case 58: {
                message = "The license has reached it's allowed activations limit.";
                break;
            }
            case 59: {
                message = "The license activation was deleted on the server.";
                break;
            }
            case 60: {
                message = "The license has reached it's allowed deactivations limit.";
                break;
            }
            case 61: {
                message = "Trial not allowed for the product.";
                break;
            }
            case 62: {
                message = "Your account has reached it's trial activations limit.";
                break;
            }
            case 63: {
                message = "Machine fingerprint has changed since activation.";
                break;
            }
            case 64: {
                message = "Metadata key length is more than 256 characters.";
                break;
            }
            case 65: {
                message = "Metadata value length is more than 4096 characters.";
                break;
            }
            case 66: {
                message = "The license has reached it's metadata fields limit.";
                break;
            }
            case 67: {
                message = "The trial has reached it's metadata fields limit.";
                break;
            }
            case 68: {
                message = "The metadata key does not exist.";
                break;
            }
            case 69: {
                message = "The system time has been tampered (backdated).";
                break;
            }
            case 70: {
                message = "Invalid version format.";
                break;
            }
            case 71: {
                message = "Incorrect email or password.";
                break;
            }
            case 72: {
                message = "The meter attribute does not exist.";
                break;
            }
            case 73: {
                message = "The meter attribute has reached it's usage limit.";
                break;
            }
            case 74: {
                message = "Custom device fingerprint length is less than 64 characters or more than 256 characters.";
                break;
            }
            case 75: {
                return "No product version is linked with the license.";
            }
            case 76: {
                return "The product version feature flag does not exist.";
            }
            case 77: {
                message = "The release version is not allowed.";
                break;
            }
            case 78: {
                message = "Release platform length is more than 256 characters.";
                break;
            }
            case 79: {
                message = "Release channel length is more than 256 characters.";
                break;
            }
            case 80: {
                message = "Application is being run inside a virtual machine / hypervisor, and activation has been disallowed in the VM.";
                break;
            }
            case 81: {
                message = "Country is not allowed.";
                break;
            }
            case 82: {
                message = "IP address is not allowed.";
                break;
            }
            case 83: {
                message = "Application is being run inside a container and activation has been disallowed in the container.";
                break;
            }
            case 84: {
                message = "Invalid release version. Make sure the release version uses the following formats: x.x, x.x.x, x.x.x.x (where x is a number).";
                break;
            }
            case 85: {
                message = "Release platform not set.";
                break;
            }
            case 86: {
                message = "Release channel not set.";
                break;
            }
            case 87: {
                message = "The user is not authenticated.";
                break;
            }
            case 88: {
                message = "The two-factor authentication code for the user authentication is missing.";
                break;
            }
            case 89: {
                message = "The two-factor authentication code provided by the user is invalid.";
                break;
            }
            case 90: {
                message = "Rate limit for API has reached, try again later.";
                break;
            }
            case 91: {
                message = "Server error.";
                break;
            }
            case 92: {
                message = "Client error.";
                break;
            }
            case 100: {
                message = "The user account has been temporarily locked for 5 mins due to 5 failed attempts.";
                break;
            }
            case 101: {
                message = "Invalid authentication ID token.";
                break;
            }
            case 102: {
                message = "OIDC SSO is not enabled.";
                break;
            }
            case 103: {
                message = "The allowed users for this account has reached its limit.";
                break;
            }
            case 104: {
                message = "OS user has changed since activation and the license is user-locked.";
                break;
            }
            default: {
                message = "Unknown error!";
            }
        }
        return message;
    }
}

