/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.themes.basic.TabDisplayerCombinerTarget;

public class TabMerger
implements Merger {
    public boolean canMerge(StationDropOperation operation, DockStation parent, DockStation child) {
        if (operation == null) {
            return false;
        }
        DisplayerCombinerTarget target = operation.getDisplayerCombination();
        if (target instanceof TabDisplayerCombinerTarget) {
            TabDisplayerCombinerTarget tab = (TabDisplayerCombinerTarget)target;
            if (!tab.isValid()) {
                return false;
            }
            if (!(operation.getItem() instanceof StackDockStation)) {
                return false;
            }
            Dockable item = operation.getItem();
            if (!parent.accept(item) || !item.accept(parent)) {
                return false;
            }
            DockController controller = parent.getController();
            if (controller != null && !controller.getAcceptance().accept(parent, item)) {
                return false;
            }
            if (!parent.canReplace(tab.getTarget(), operation.getItem())) {
                return false;
            }
            return ((StackDockStation)item).acceptable(tab.getTarget());
        }
        return false;
    }

    public void merge(StationDropOperation operation, DockStation parent, DockStation child) {
        DisplayerCombinerTarget target = operation.getDisplayerCombination();
        if (target instanceof TabDisplayerCombinerTarget) {
            TabDisplayerCombinerTarget tab = (TabDisplayerCombinerTarget)target;
            StackDockStation station = (StackDockStation)operation.getItem();
            if (station.getDockParent() != null) {
                station.getDockParent().drag(station);
            }
            Dockable dockable = tab.getTarget();
            parent.replace(dockable, (Dockable)station);
            Dockable selected = station.getFrontDockable();
            if (tab.getIndex() == 0) {
                station.add(dockable, station.getDockableCount());
            } else {
                station.add(dockable, 0);
            }
            DockController controller = station.getController();
            if (controller != null) {
                controller.setFocusedDockable(selected, false);
            }
        }
    }
}

