/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.AbstractToolbarDockStation;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.component.DefaultDockStationComponentRootHandler;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideAnswer;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.security.SecureContainer;
import bibliothek.gui.dock.station.DisplayerCollection;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationFactory;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBar;
import bibliothek.gui.dock.station.toolbar.group.ColumnScrollBarFactory;
import bibliothek.gui.dock.station.toolbar.group.DefaultToolbarGroupDividierStrategy;
import bibliothek.gui.dock.station.toolbar.group.SlimScrollbar;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategyFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDropInfo;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupExpander;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeader;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeaderFactory;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupPlaceholderMapping;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupInnerLayer;
import bibliothek.gui.dock.station.toolbar.layer.ToolbarGroupOuterLayer;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import bibliothek.gui.dock.station.toolbar.title.ColumnDockActionSource;
import bibliothek.gui.dock.themes.DefaultDisplayerFactoryValue;
import bibliothek.gui.dock.themes.DefaultStationPaintValue;
import bibliothek.gui.dock.themes.basic.BasicDockTitleFactory;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ToolbarGroupDockStation
extends AbstractToolbarDockStation {
    public static final String TITLE_ID = "toolbar.group";
    public static final String DISPLAYER_ID = "toolbar.group";
    public static final PropertyKey<ColumnScrollBarFactory> SCROLLBAR_FACTORY = new PropertyKey<ColumnScrollBarFactory>("dock.scrollbarFactory", new ConstantPropertyFactory<ColumnScrollBarFactory>(SlimScrollbar.FACTORY), true);
    public static final PropertyKey<ToolbarGroupHeaderFactory> HEADER_FACTORY = new PropertyKey("dock.toolbarGroupHeaderFactory");
    public static final PropertyKey<ToolbarGroupDividerStrategyFactory> DIVIDER_STRATEGY_FACTORY = new PropertyKey<ToolbarGroupDividerStrategyFactory>("dock.toolbarGroupDividerStrategy", new ConstantPropertyFactory<ToolbarGroupDividerStrategyFactory>(DefaultToolbarGroupDividierStrategy.FACTORY), true);
    private final DockablePlaceholderToolbarGrid<StationChildHandle> dockables = new DockablePlaceholderToolbarGrid();
    private ToolbarGroupExpander expander;
    private final PropertyValue<PlaceholderStrategy> placeholderStrategy = new PropertyValue<PlaceholderStrategy>(PlaceholderStrategy.PLACEHOLDER_STRATEGY){

        @Override
        protected void valueChanged(PlaceholderStrategy placeholderStrategy, PlaceholderStrategy placeholderStrategy2) {
            ToolbarGroupDockStation.this.dockables.setStrategy(placeholderStrategy2);
        }
    };
    private PropertyValue<ToolbarGroupDividerStrategyFactory> dividerStrategyFactory = new PropertyValue<ToolbarGroupDividerStrategyFactory>(DIVIDER_STRATEGY_FACTORY){

        @Override
        protected void valueChanged(ToolbarGroupDividerStrategyFactory toolbarGroupDividerStrategyFactory, ToolbarGroupDividerStrategyFactory toolbarGroupDividerStrategyFactory2) {
            if (toolbarGroupDividerStrategyFactory2 == null) {
                ToolbarGroupDockStation.this.setDividerStrategy(null);
            } else {
                ToolbarGroupDockStation.this.setDividerStrategy(toolbarGroupDividerStrategyFactory2.create(ToolbarGroupDockStation.this));
            }
        }
    };
    private ToolbarGroupDividerStrategy dividerStrategy;
    private OverpaintablePanelBase mainPanel;
    private int borderSideSnapSize = 10;
    private boolean allowSideSnap = true;
    private ToolbarGridLayoutManager<StationChildHandle> layoutManager;
    private ToolbarGroupDropInfo dropInfo;
    private PropertyValue<ColumnScrollBarFactory> scrollbarFactory = new PropertyValue<ColumnScrollBarFactory>(SCROLLBAR_FACTORY){

        @Override
        protected void valueChanged(ColumnScrollBarFactory columnScrollBarFactory, ColumnScrollBarFactory columnScrollBarFactory2) {
            ToolbarGroupDockStation.this.resetScrollbars();
        }
    };
    private Map<Integer, ColumnScrollBar> scrollbars = new HashMap<Integer, ColumnScrollBar>();
    private AdjustmentListener adjustmentListener = new AdjustmentListener(){

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ToolbarGroupDockStation.this.mainPanel.dockablePane.revalidate();
        }
    };
    private PropertyValue<ToolbarGroupHeaderFactory> headerFactory = new PropertyValue<ToolbarGroupHeaderFactory>(HEADER_FACTORY){

        @Override
        protected void valueChanged(ToolbarGroupHeaderFactory toolbarGroupHeaderFactory, ToolbarGroupHeaderFactory toolbarGroupHeaderFactory2) {
            ToolbarGroupHeader toolbarGroupHeader = null;
            if (toolbarGroupHeaderFactory2 != null) {
                toolbarGroupHeader = toolbarGroupHeaderFactory2.create(ToolbarGroupDockStation.this);
            }
            if (ToolbarGroupDockStation.this.groupHeader != null) {
                ToolbarGroupDockStation.this.mainPanel.removeHeaderCopmonent(ToolbarGroupDockStation.this.groupHeader.getComponent());
                ToolbarGroupDockStation.this.groupHeader.destroy();
            }
            ToolbarGroupDockStation.this.groupHeader = toolbarGroupHeader;
            if (ToolbarGroupDockStation.this.groupHeader != null) {
                ToolbarGroupDockStation.this.groupHeader.setOrientation(ToolbarGroupDockStation.this.getOrientation());
                ToolbarGroupDockStation.this.mainPanel.addHeaderComponent(ToolbarGroupDockStation.this.groupHeader.getComponent());
            }
        }
    };
    private ToolbarGroupHeader groupHeader;

    public ToolbarGridLayoutManager<StationChildHandle> getLayoutManager() {
        return this.layoutManager;
    }

    public ToolbarGroupDockStation() {
        this.init();
    }

    protected void init() {
        this.init("dock.background.station.toolbar.group");
        this.mainPanel = new OverpaintablePanelBase();
        this.paint = new DefaultStationPaintValue("dock.paint.toolbar.group", this);
        this.setOrientation(this.getOrientation());
        this.displayerFactory = this.createDisplayerFactory();
        this.displayers = new DisplayerCollection((DockStation)this, this.displayerFactory, this.getDisplayerId());
        this.displayers.addDockableDisplayerListener(new DockableDisplayerListener(){

            @Override
            public void discard(DockableDisplayer dockableDisplayer) {
                ToolbarGroupDockStation.this.discard(dockableDisplayer);
            }

            @Override
            public void moveableElementChanged(DockableDisplayer dockableDisplayer) {
            }
        });
        this.setTitleIcon(null);
        this.expander = new ToolbarGroupExpander(this);
        this.setDividerStrategy(this.dividerStrategyFactory.getValue().create(this));
    }

    @Override
    protected DockComponentRootHandler createRootHandler() {
        return new DefaultDockStationComponentRootHandler(this, this.displayers);
    }

    public ToolbarColumnModel<Dockable, StationChildHandle> getColumnModel() {
        return this.dockables.getModel();
    }

    public int column(Dockable dockable) {
        return this.dockables.getColumn(dockable);
    }

    public int line(Dockable dockable) {
        return this.dockables.getLine(dockable);
    }

    public int columnCount() {
        return this.dockables.getColumnCount();
    }

    public int lineCount(int n) {
        return this.dockables.getLineCount(n);
    }

    public Dockable getDockable(int n, int n2) {
        StationChildHandle stationChildHandle = this.getHandle(n, n2);
        if (stationChildHandle == null) {
            return null;
        }
        return stationChildHandle.asDockable();
    }

    public StationChildHandle getHandle(int n, int n2) {
        ToolbarColumnModel<Dockable, StationChildHandle> toolbarColumnModel = this.getColumnModel();
        if (n < 0 || n >= toolbarColumnModel.getColumnCount()) {
            return null;
        }
        ToolbarColumn<Dockable, StationChildHandle> toolbarColumn = toolbarColumnModel.getColumn((Dockable)n);
        if (n2 < 0 || n2 >= toolbarColumn.getDockableCount()) {
            return null;
        }
        return toolbarColumn.getItem(n2);
    }

    public StationChildHandle getHandle(Dockable dockable) {
        ToolbarColumn<Dockable, StationChildHandle> toolbarColumn = this.getColumnModel().getColumn(dockable);
        if (toolbarColumn == null) {
            return null;
        }
        int n = toolbarColumn.getDockableCount();
        for (int i = 0; i < n; ++i) {
            StationChildHandle stationChildHandle = toolbarColumn.getItem(i);
            if (stationChildHandle.getDockable() != dockable) continue;
            return stationChildHandle;
        }
        return null;
    }

    public boolean isLastOfColumn(Dockable dockable) {
        int n = this.indexOf(dockable);
        int n2 = this.column(dockable);
        if (n == this.getDockableCount() - 1) {
            return true;
        }
        return this.column(this.getDockable(n + 1)) != n2;
    }

    @Override
    public ToolbarStrategy getToolbarStrategy() {
        Object object;
        DockController dockController = this.getController();
        DockStation dockStation = this.getDockParent();
        while (dockController == null && dockStation != null) {
            dockController = dockStation.getController();
            object = dockStation.asDockable();
            if (object == null) {
                dockStation = null;
                continue;
            }
            dockStation = object.getDockParent();
        }
        object = new SilentPropertyValue<ToolbarStrategy>(ToolbarStrategy.STRATEGY, dockController);
        ToolbarStrategy toolbarStrategy = (ToolbarStrategy)((PropertyValue)object).getValue();
        ((PropertyValue)object).setProperties((DockController)null);
        return toolbarStrategy;
    }

    @Override
    public Component getComponent() {
        return this.mainPanel;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public Dockable getDockable(int n) {
        return ((StationChildHandle)this.dockables.get(n)).asDockable();
    }

    @Override
    public String getFactoryID() {
        return "ToolbarGroupDockStationFactory";
    }

    protected String getDisplayerId() {
        return "toolbar.group";
    }

    public void setAllowSideSnap(boolean bl) {
        this.allowSideSnap = bl;
    }

    public boolean isAllowSideSnap() {
        return this.allowSideSnap;
    }

    public void setBorderSideSnapSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("borderSideSnapeSize must not be less than 0");
        }
        this.borderSideSnapSize = n;
    }

    public int getBorderSideSnapSize() {
        return this.borderSideSnapSize;
    }

    @Override
    public void setController(DockController dockController) {
        if (this.getController() != dockController) {
            if (this.getController() != null) {
                this.dockables.unbind();
            }
            Iterator iterator = this.dockables.items();
            while (iterator.hasNext()) {
                ((StationChildHandle)iterator.next()).setTitleRequest(null);
            }
            super.setController(dockController);
            this.title = dockController == null ? null : this.registerTitle(dockController);
            this.paint.setController(dockController);
            this.expander.setController(dockController);
            this.placeholderStrategy.setProperties(dockController);
            this.displayerFactory.setController(dockController);
            this.displayers.setController(dockController);
            this.mainPanel.setController(dockController);
            this.layoutManager.setController(dockController);
            this.scrollbarFactory.setProperties(dockController);
            this.headerFactory.setProperties(dockController);
            this.dividerStrategyFactory.setProperties(dockController);
            if (this.getController() != null) {
                this.dockables.bind();
            }
            iterator = this.dockables.items();
            while (iterator.hasNext()) {
                ((StationChildHandle)iterator.next()).setTitleRequest(this.title, true);
            }
        }
    }

    @Override
    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
        this.fireOrientingEvent();
        for (ColumnScrollBar columnScrollBar : this.scrollbars.values()) {
            columnScrollBar.setOrientation(orientation);
        }
        if (this.groupHeader != null) {
            this.groupHeader.setOrientation(orientation);
            this.mainPanel.removeHeaderCopmonent(this.groupHeader.getComponent());
            this.mainPanel.addHeaderComponent(this.groupHeader.getComponent());
        }
        this.mainPanel.updateAlignment();
        this.mainPanel.revalidate();
    }

    @Override
    public DockStationDropLayer[] getLayers() {
        return new DockStationDropLayer[]{new ToolbarGroupInnerLayer(this, this.mainPanel.dockablePane), new ToolbarGroupOuterLayer(this, this.mainPanel.dockablePane)};
    }

    @Override
    public boolean accept(Dockable dockable) {
        return this.getToolbarStrategy().isToolbarGroupPart(dockable);
    }

    @Override
    public boolean accept(DockStation dockStation) {
        return this.getToolbarStrategy().isToolbarGroupPartParent(dockStation, this, false);
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        return false;
    }

    @Override
    public StationDropOperation prepareDrop(StationDropItem stationDropItem) {
        DockController dockController = this.getController();
        if (this.getExpandedState() == ExpandedState.EXPANDED) {
            return null;
        }
        Dockable dockable = stationDropItem.getDockable();
        if (this.accept(dockable) && dockable.accept(this)) {
            int n;
            int n2;
            if (dockController != null && !dockController.getAcceptance().accept(this, dockable)) {
                return null;
            }
            Point point = new Point(stationDropItem.getMouseX(), stationDropItem.getMouseY());
            SwingUtilities.convertPointFromScreen(point, this.mainPanel.dockablePane);
            int n3 = this.getColumnAt(point);
            int n4 = -1;
            if (n3 >= 0 && n3 < this.columnCount()) {
                Rectangle rectangle = this.layoutManager.getBounds(n3);
                if (this.getOrientation() == Orientation.VERTICAL) {
                    n2 = rectangle.x;
                    n = rectangle.width;
                    if (n2 + n / 5 <= point.x && point.x <= n2 + n * 4 / 5) {
                        n4 = this.layoutManager.getInsertionLineAt(n3, point.y);
                    } else if (point.x >= n2 + n * 4 / 5) {
                        ++n3;
                    }
                } else {
                    n2 = rectangle.y;
                    n = rectangle.height;
                    if (n2 + n / 5 <= point.y && point.y <= n2 + n * 4 / 5) {
                        n4 = this.layoutManager.getInsertionLineAt(n3, point.x);
                    } else if (point.y >= n2 + n * 4 / 5) {
                        ++n3;
                    }
                }
            }
            if (n3 == -1) {
                n3 = 0;
            }
            boolean bl = true;
            if (dockable.getDockParent() == this) {
                n2 = this.column(dockable);
                n = this.line(dockable);
                bl = n2 != n3 || n != n4 && n != n4 - 1;
                bl = bl && (n4 != -1 || this.lineCount(n2) != 1 || n2 != n3 && n2 != n3 - 1);
            }
            return new ToolbarGroupDropInfo(dockable, this, n3, n4, bl){

                @Override
                public void execute() {
                    ToolbarGroupDockStation.this.dropInfo = null;
                    ToolbarGroupDockStation.this.drop(this);
                }

                @Override
                public void destroy(StationDropOperation stationDropOperation) {
                    if (stationDropOperation == null || stationDropOperation.getTarget() != this.getTarget()) {
                        ToolbarGroupDockStation.this.layoutManager.mutate();
                    }
                    ToolbarGroupDockStation.this.dropInfo = null;
                    ToolbarGroupDockStation.this.mainPanel.repaint();
                }

                @Override
                public void draw() {
                    ToolbarGroupDockStation.this.dropInfo = this;
                    int n = this.getColumn();
                    int n2 = this.getLine();
                    if (this.hasEffect()) {
                        ToolbarGroupDockStation.this.layoutManager.mutate(n, n2);
                    } else {
                        ToolbarGroupDockStation.this.layoutManager.mutate();
                    }
                    ToolbarGroupDockStation.this.mainPanel.repaint();
                }
            };
        }
        return null;
    }

    public int getColumnAt(Point point) {
        int n;
        int n2;
        if (this.getOrientation() == Orientation.VERTICAL) {
            n2 = point.x;
            n = this.mainPanel.getWidth();
        } else {
            n2 = point.y;
            n = this.mainPanel.getHeight();
        }
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= n) {
            return this.columnCount();
        }
        return this.layoutManager.getColumnAt(n2);
    }

    protected void drop(ToolbarGroupDropInfo toolbarGroupDropInfo) {
        int n = toolbarGroupDropInfo.getLine();
        if (n == -1) {
            this.drop(toolbarGroupDropInfo.getItem(), toolbarGroupDropInfo.getColumn());
        } else {
            this.drop(toolbarGroupDropInfo.getItem(), toolbarGroupDropInfo.getColumn(), n);
        }
    }

    @Override
    public void drop(Dockable dockable) {
        this.drop(dockable, 0, 0);
    }

    public boolean drop(Dockable dockable, int n, int n2) {
        return this.drop(dockable, n, n2, false);
    }

    public boolean drop(Dockable dockable, int n, int n2, boolean bl) {
        if (bl || this.accept(dockable)) {
            if (!bl) {
                Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (dockable2 == null) {
                    return false;
                }
                if (dockable2 != dockable) {
                    dockable2.asDockStation().drop(dockable);
                    dockable = dockable2;
                }
            }
            this.add(dockable, n, n2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Dockable dockable, int n, int n2) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (dockable2 != dockable) {
            dockable2.asDockStation().drop(dockable);
            dockable = dockable2;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            dockable.setDockParent(this);
            StationChildHandle stationChildHandle = this.createHandle(dockable);
            int n3 = this.dockables.getColumnCount();
            this.dockables.insert(n, n2, stationChildHandle);
            this.addComponent(stationChildHandle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, n3 != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    private StationChildHandle createHandle(Dockable dockable) {
        StationChildHandle stationChildHandle = new StationChildHandle(this, this.displayers, dockable, this.title);
        stationChildHandle.updateDisplayer();
        return stationChildHandle;
    }

    private void addComponent(StationChildHandle stationChildHandle) {
        this.mainPanel.dockablePane.add(stationChildHandle.getDisplayer().getComponent());
        this.mainPanel.getContentPane().revalidate();
    }

    private void removeComponent(StationChildHandle stationChildHandle) {
        this.mainPanel.dockablePane.remove(stationChildHandle.getDisplayer().getComponent());
        this.mainPanel.getContentPane().revalidate();
    }

    public boolean drop(Dockable dockable, int n) {
        return this.drop(dockable, n, false);
    }

    public boolean drop(Dockable dockable, int n, boolean bl) {
        if (bl || this.accept(dockable)) {
            if (!bl) {
                Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                if (dockable2 == null) {
                    return false;
                }
                if (dockable2 != dockable) {
                    dockable2.asDockStation().drop(dockable);
                    dockable = dockable2;
                }
            }
            this.add(dockable, n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Dockable dockable, int n) {
        DockUtilities.ensureTreeValidity(this, dockable);
        DockUtilities.checkLayoutLocked();
        Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
        if (dockable2 != dockable) {
            dockable2.asDockStation().drop(dockable);
            dockable = dockable2;
        }
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            this.listeners.fireDockableAdding(dockable);
            dockable.setDockParent(this);
            StationChildHandle stationChildHandle = this.createHandle(dockable);
            int n2 = this.dockables.getColumnCount();
            this.dockables.insert(n, stationChildHandle, false);
            this.addComponent(stationChildHandle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, n2 != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    @Override
    public void drag(Dockable dockable) {
        if (dockable.getDockParent() != this) {
            throw new IllegalArgumentException("not a child of this station: " + dockable);
        }
        this.remove(dockable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void remove(Dockable dockable) {
        DockUtilities.checkLayoutLocked();
        int n = this.column(dockable);
        int n2 = this.dockables.getColumnCount();
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.get(dockable);
        DockHierarchyLock.Token token = DockHierarchyLock.acquireUnlinking(this, dockable);
        try {
            this.listeners.fireDockableRemoving(dockable);
            this.dockables.remove(stationChildHandle);
            this.removeComponent(stationChildHandle);
            stationChildHandle.destroy();
            dockable.setDockParent(null);
            this.listeners.fireDockableRemoved(dockable);
            this.fireColumnRepositioned(n, n2 != this.dockables.getColumnCount());
            this.mainPanel.repaint();
        }
        finally {
            token.release();
        }
    }

    @Override
    public void replace(Dockable dockable, Dockable dockable2) {
        DockUtilities.checkLayoutLocked();
        DockController dockController = this.getController();
        if (dockController != null) {
            dockController.freezeLayout();
        }
        int n = this.dockables.getColumn(dockable);
        int n2 = this.dockables.getLine(dockable);
        int n3 = this.dockables.getColumnCount();
        this.remove(dockable);
        if (n3 != this.dockables.getColumnCount()) {
            this.add(dockable2, n);
        } else {
            this.add(dockable2, n, n2);
        }
        dockController.meltLayout();
    }

    @Override
    public boolean canReplace(Dockable dockable, Dockable dockable2) {
        return this.acceptable(dockable2) && this.getToolbarStrategy().isToolbarGroupPartParent(this, dockable2, true);
    }

    protected void fireDockablesRepositioned(Dockable dockable) {
        this.fireDockablesRepositioned(dockable, false);
    }

    protected void fireDockablesRepositioned(Dockable dockable, boolean bl) {
        this.fireColumnRepositioned(this.column(dockable), bl);
    }

    protected void fireColumnRepositioned(int n, boolean bl) {
        ArrayList<Dockable> arrayList = new ArrayList<Dockable>();
        int n2 = bl ? this.dockables.getColumnCount() : n + 1;
        for (int i = n; i < n2; ++i) {
            Iterator iterator = this.dockables.getColumnContent(i);
            while (iterator.hasNext()) {
                arrayList.add(((StationChildHandle)iterator.next()).getDockable());
            }
        }
        if (arrayList.size() > 0) {
            this.listeners.fireDockablesRepositioned(arrayList.toArray(new Dockable[arrayList.size()]));
        }
    }

    public ColumnDockActionSource getExpandActionSource() {
        return this.expander.getActions();
    }

    public ToolbarGroupHeaderFactory getHeaderComponentFactory() {
        return this.headerFactory.getValue();
    }

    public void setHeaderComponentFactory(ToolbarGroupHeaderFactory toolbarGroupHeaderFactory) {
        this.headerFactory.setValue(toolbarGroupHeaderFactory);
    }

    public ToolbarGroupHeader getHeaderComponent() {
        return this.groupHeader;
    }

    @Override
    protected void callDockUiUpdateTheme() throws IOException {
        DockUI.updateTheme(this, new ToolbarGroupDockStationFactory());
    }

    @Override
    protected DefaultDisplayerFactoryValue createDisplayerFactory() {
        return new DefaultDisplayerFactoryValue("dock.displayer.toolbar.group", this);
    }

    @Override
    protected DockTitleVersion registerTitle(DockController dockController) {
        return dockController.getDockTitleManager().getVersion("toolbar.group", BasicDockTitleFactory.FACTORY);
    }

    @Override
    protected void discard(DockableDisplayer dockableDisplayer) {
        Dockable dockable = dockableDisplayer.getDockable();
        StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.get(dockable);
        if (stationChildHandle == null) {
            throw new IllegalArgumentException("displayer is not child of this station: " + dockableDisplayer);
        }
        this.removeComponent(stationChildHandle);
        stationChildHandle.updateDisplayer();
        this.addComponent(stationChildHandle);
    }

    private void resetScrollbars() {
        for (Map.Entry<Integer, ColumnScrollBar> entry : this.scrollbars.entrySet()) {
            ColumnScrollBar columnScrollBar = this.scrollbarFactory.getValue().create(this);
            this.mainPanel.dockablePane.remove(entry.getValue().getComponent());
            entry.setValue(columnScrollBar);
            this.mainPanel.dockablePane.add(entry.getValue().getComponent());
        }
    }

    private void setDividerStrategy(ToolbarGroupDividerStrategy toolbarGroupDividerStrategy) {
        this.dividerStrategy = toolbarGroupDividerStrategy;
        this.layoutManager.setDividerStrategy(toolbarGroupDividerStrategy);
        this.mainPanel.revalidate();
    }

    public Rectangle getDropGapBoundaries() {
        if (this.dropInfo == null) {
            return null;
        }
        JPanel jPanel = this.mainPanel.dockablePane;
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(jPanel, point, this.mainPanel);
        Rectangle rectangle = this.dropInfo.getLine() == -1 ? this.layoutManager.getGapBounds(this.dropInfo.getColumn(), false) : this.layoutManager.getGapBounds(this.dropInfo.getColumn(), this.dropInfo.getLine());
        rectangle.x += point.x;
        rectangle.y += point.y;
        return rectangle;
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        PlaceholderMap placeholderMap = this.dockables.toMap();
        this.writeLayoutArguments(placeholderMap);
        return placeholderMap;
    }

    public PlaceholderMap getPlaceholders(Map<Dockable, Integer> map) {
        PlaceholderMap placeholderMap = this.dockables.toMap(map);
        this.writeLayoutArguments(placeholderMap);
        return placeholderMap;
    }

    @Override
    public PlaceholderMapping getPlaceholderMapping() {
        return new ToolbarGroupPlaceholderMapping(this, this.dockables);
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        this.dockables.fromMap(placeholderMap);
        this.readLayoutArguments(placeholderMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaceholders(PlaceholderMap placeholderMap, Map<Integer, Dockable> map) {
        DockUtilities.checkLayoutLocked();
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("this station still has children");
        }
        DockController dockController = this.getController();
        this.readLayoutArguments(placeholderMap);
        try {
            if (dockController != null) {
                dockController.freezeLayout();
            }
            this.dockables.setStrategy(null);
            this.dockables.unbind();
            this.dockables.fromMap(placeholderMap, map, new PlaceholderToolbarGridConverter<Dockable, StationChildHandle>(){

                @Override
                public StationChildHandle convert(Dockable dockable, ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    ToolbarGroupDockStation.this.listeners.fireDockableAdding(dockable);
                    dockable.setDockParent(ToolbarGroupDockStation.this);
                    StationChildHandle stationChildHandle = ToolbarGroupDockStation.this.createHandle(dockable);
                    ToolbarGroupDockStation.this.addComponent(stationChildHandle);
                    return stationChildHandle;
                }

                @Override
                public void added(StationChildHandle stationChildHandle) {
                    ToolbarGroupDockStation.this.listeners.fireDockableAdded(stationChildHandle.getDockable());
                }
            });
            if (dockController != null) {
                this.dockables.bind();
            }
            this.dockables.setStrategy(this.placeholderStrategy.getValue());
        }
        finally {
            if (dockController != null) {
                dockController.meltLayout();
            }
        }
    }

    private void writeLayoutArguments(PlaceholderMap placeholderMap) {
        ToolbarGroupDockStationLayout.writeOrientation(placeholderMap, this.getOrientation());
    }

    private void readLayoutArguments(PlaceholderMap placeholderMap) {
        Orientation orientation = ToolbarGroupDockStationLayout.readOrientation(placeholderMap);
        if (orientation != null) {
            this.setOrientation(orientation);
        }
    }

    @Override
    public DockableProperty getDockableProperty(Dockable dockable, Dockable dockable2) {
        int n = this.column(dockable);
        int n2 = this.line(dockable);
        if (dockable2 == null) {
            dockable2 = dockable;
        }
        PlaceholderStrategy placeholderStrategy = this.placeholderStrategy.getValue();
        Path path = null;
        if (placeholderStrategy != null && (path = placeholderStrategy.getPlaceholderFor(dockable2)) != null && n >= 0 && n2 >= 0) {
            this.dockables.addPlaceholder(n, n2, path);
        }
        return new ToolbarGroupProperty(n, n2, path);
    }

    @Override
    public void aside(AsideRequest asideRequest) {
        DockableProperty dockableProperty = asideRequest.getLocation();
        int n = -1;
        int n2 = -1;
        Path path = asideRequest.getPlaceholder();
        if (dockableProperty instanceof ToolbarGroupProperty) {
            ToolbarGroupProperty toolbarGroupProperty = (ToolbarGroupProperty)dockableProperty;
            Path path2 = toolbarGroupProperty.getPlaceholder();
            if (path2 != null) {
                n = this.dockables.getColumn(path2);
            }
            if (n == -1) {
                path2 = null;
                n = toolbarGroupProperty.getColumn();
            }
            int n3 = this.dockables.getTotalColumnCount();
            n = Math.max(0, Math.min(n, n3));
            if (path2 != null && n < n3) {
                n2 = this.dockables.getLine(n, path2);
            } else if (n == n3) {
                n2 = 0;
            }
            if (n2 == -1) {
                n2 = toolbarGroupProperty.getLine();
                n2 = Math.max(0, Math.min(n2, this.dockables.getLineCount(n)));
            }
            if (toolbarGroupProperty.getSuccessor() == null) {
                if (path != null) {
                    this.dockables.insertPlaceholder(n, n2, path);
                }
            } else if (path != null) {
                AsideAnswer asideAnswer;
                this.dockables.addPlaceholder(n, n2, path);
                Dockable dockable = (Dockable)this.dockables.getModel().getColumn(n).getDockable(n2);
                if (dockable.asDockStation() != null && (asideAnswer = asideRequest.forward(dockable.asDockStation())).isCanceled()) {
                    return;
                }
            }
        } else {
            n = 0;
            n2 = this.dockables.getColumnCount() > 0 ? this.dockables.getLineCount(n) : 0;
        }
        asideRequest.answer(new ToolbarGroupProperty(n, n2, path));
    }

    @Override
    public boolean drop(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ToolbarGroupProperty) {
            return this.drop(dockable, (ToolbarGroupProperty)dockableProperty);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drop(Dockable dockable, ToolbarGroupProperty toolbarGroupProperty) {
        DockStation dockStation;
        Path path = toolbarGroupProperty.getPlaceholder();
        int n = toolbarGroupProperty.getColumn();
        int n2 = toolbarGroupProperty.getLine();
        if (path != null) {
            if (this.dockables.hasPlaceholder(path)) {
                StationChildHandle stationChildHandle = (StationChildHandle)this.dockables.get(path);
                if (stationChildHandle == null) {
                    if (this.acceptable(dockable)) {
                        Dockable dockable2 = this.getToolbarStrategy().ensureToolbarLayer(this, dockable);
                        if (dockable2 == null) {
                            return false;
                        }
                        DockController dockController = this.getController();
                        if (dockController != null) {
                            dockController.freezeLayout();
                        }
                        try {
                            this.dropAt(dockable2, path);
                            if (dockable2 != dockable) {
                                if (toolbarGroupProperty.getSuccessor() != null) {
                                    if (!dockable2.asDockStation().drop(dockable, toolbarGroupProperty.getSuccessor())) {
                                        dockable2.asDockStation().drop(dockable);
                                    }
                                } else {
                                    dockable2.asDockStation().drop(dockable);
                                }
                            }
                        }
                        finally {
                            if (dockController != null) {
                                dockController.meltLayout();
                            }
                        }
                        return true;
                    }
                } else {
                    if (this.drop(stationChildHandle, dockable, toolbarGroupProperty)) {
                        return true;
                    }
                    n = this.dockables.getColumn(stationChildHandle.getDockable());
                    n2 = this.dockables.getLine(n, stationChildHandle.getDockable()) + 1;
                }
            }
        } else if (n >= 0 && n < this.columnCount() && n2 >= 0 && n2 < this.lineCount(n) && (dockStation = this.getDockable(n, n2).asDockStation()) != null && dockStation.drop(dockable, toolbarGroupProperty.getSuccessor())) {
            return true;
        }
        if (!this.acceptable(dockable)) {
            return false;
        }
        n2 = Math.max(0, n2);
        return this.drop(dockable, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropAt(Dockable dockable, Path path) {
        DockUtilities.checkLayoutLocked();
        DockHierarchyLock.Token token = DockHierarchyLock.acquireLinking(this, dockable);
        try {
            DockUtilities.ensureTreeValidity(this, dockable);
            this.listeners.fireDockableAdding(dockable);
            int n = this.dockables.getColumnCount();
            dockable.setDockParent(this);
            StationChildHandle stationChildHandle = this.createHandle(dockable);
            this.dockables.put(path, stationChildHandle);
            this.addComponent(stationChildHandle);
            this.listeners.fireDockableAdded(dockable);
            this.fireDockablesRepositioned(dockable, n != this.dockables.getColumnCount());
        }
        finally {
            token.release();
        }
    }

    private boolean drop(StationChildHandle stationChildHandle, Dockable dockable, ToolbarGroupProperty toolbarGroupProperty) {
        if (toolbarGroupProperty.getSuccessor() == null) {
            return false;
        }
        DockStation dockStation = stationChildHandle.getDockable().asDockStation();
        if (dockStation == null) {
            return false;
        }
        return dockStation.drop(dockable, toolbarGroupProperty.getSuccessor());
    }

    @Override
    public void move(Dockable dockable, DockableProperty dockableProperty) {
        if (dockableProperty instanceof ToolbarGroupProperty) {
            this.move(dockable, (ToolbarGroupProperty)dockableProperty);
        }
    }

    private void move(Dockable dockable, ToolbarGroupProperty toolbarGroupProperty) {
        int n;
        int n2;
        int n3 = this.column(dockable);
        int n4 = this.line(dockable);
        boolean bl = false;
        int n5 = toolbarGroupProperty.getColumn();
        int n6 = toolbarGroupProperty.getLine();
        Path path = toolbarGroupProperty.getPlaceholder();
        if (path != null && (n2 = this.dockables.getColumn(path)) != -1 && (n = this.dockables.getLine(n2, path)) != -1) {
            bl = true;
            n5 = n2;
            n6 = n;
        }
        if (!bl) {
            n6 = (n5 = Math.min(n5, this.dockables.getColumnCount())) == this.dockables.getColumnCount() || n5 == -1 ? 0 : Math.min(n6, this.dockables.getLineCount(n5));
        }
        PlaceholderList.Level level = bl ? PlaceholderList.Level.BASE : PlaceholderList.Level.DOCKABLE;
        this.dockables.move(n3, n4, n5, n6, level);
        this.mainPanel.getContentPane().revalidate();
    }

    protected class OverpaintablePanelBase
    extends SecureContainer {
        private static final long serialVersionUID = -4399008463139189130L;
        private final JPanel dockablePane = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (ToolbarGroupDockStation.this.dividerStrategy != null) {
                    ToolbarGroupDockStation.this.dividerStrategy.paint(this, graphics, ToolbarGroupDockStation.this.layoutManager);
                }
            }
        };
        private JPanel decorationPane = ToolbarGroupDockStation.this.createBackgroundPanel();

        public OverpaintablePanelBase() {
            this.setBasePane(this.decorationPane);
            this.setSolid(false);
            this.decorationPane.setOpaque(false);
            this.dockablePane.setOpaque(false);
            this.decorationPane.setLayout(new BorderLayout());
            this.decorationPane.add((Component)this.dockablePane, "Center");
        }

        public void addHeaderComponent(Component component) {
            if (ToolbarGroupDockStation.this.getOrientation() == Orientation.HORIZONTAL) {
                this.decorationPane.add(component, "West");
            } else {
                this.decorationPane.add(component, "North");
            }
        }

        public void removeHeaderCopmonent(Component component) {
            this.decorationPane.remove(component);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.dockablePane != null && !this.dockablePane.isValid()) {
                this.dockablePane.doLayout();
            }
            return this.getBasePane().getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getBasePane().getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getBasePane().getPreferredSize();
        }

        public void updateAlignment() {
            Orientation orientation = ToolbarGroupDockStation.this.getOrientation();
            if (orientation != null) {
                if (ToolbarGroupDockStation.this.layoutManager != null) {
                    ToolbarGroupDockStation.this.layoutManager.setController(null);
                }
                ToolbarGroupDockStation.this.layoutManager = new ToolbarGridLayoutManager<StationChildHandle>((Container)this.dockablePane, orientation, ToolbarGroupDockStation.this.dockables, ToolbarGroupDockStation.this){

                    @Override
                    protected Component toComponent(StationChildHandle stationChildHandle) {
                        return stationChildHandle.getDisplayer().getComponent();
                    }

                    @Override
                    protected void setShowScrollbar(int n, boolean bl) {
                        boolean bl2 = false;
                        if (bl) {
                            if (!ToolbarGroupDockStation.this.scrollbars.containsKey(n)) {
                                ColumnScrollBar columnScrollBar = ((ColumnScrollBarFactory)ToolbarGroupDockStation.this.scrollbarFactory.getValue()).create(ToolbarGroupDockStation.this);
                                columnScrollBar.setOrientation(ToolbarGroupDockStation.this.getOrientation());
                                ToolbarGroupDockStation.this.scrollbars.put(n, columnScrollBar);
                                OverpaintablePanelBase.this.dockablePane.add(columnScrollBar.getComponent());
                                columnScrollBar.addAdjustmentListener(ToolbarGroupDockStation.this.adjustmentListener);
                                bl2 = true;
                            }
                        } else {
                            ColumnScrollBar columnScrollBar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.remove(n);
                            if (columnScrollBar != null) {
                                OverpaintablePanelBase.this.dockablePane.remove(columnScrollBar.getComponent());
                                columnScrollBar.removeAdjustmentListener(ToolbarGroupDockStation.this.adjustmentListener);
                                bl2 = true;
                            }
                        }
                        if (bl2) {
                            OverpaintablePanelBase.this.revalidateLater();
                        }
                    }

                    @Override
                    protected int getScrollbarValue(int n, int n2, int n3) {
                        ColumnScrollBar columnScrollBar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.get(n);
                        if (columnScrollBar == null) {
                            return 0;
                        }
                        columnScrollBar.setValues(n2, n3);
                        return columnScrollBar.getValue();
                    }

                    @Override
                    protected Component getScrollbar(int n) {
                        ColumnScrollBar columnScrollBar = (ColumnScrollBar)ToolbarGroupDockStation.this.scrollbars.get(n);
                        if (columnScrollBar == null) {
                            return null;
                        }
                        return columnScrollBar.getComponent();
                    }
                };
                this.dockablePane.setLayout(ToolbarGroupDockStation.this.layoutManager);
                ToolbarGroupDockStation.this.layoutManager.setDividerStrategy(ToolbarGroupDockStation.this.dividerStrategy);
                ToolbarGroupDockStation.this.layoutManager.setController(this.getController());
            }
            ToolbarGroupDockStation.this.mainPanel.revalidate();
        }

        private void revalidateLater() {
            if (ToolbarGroupDockStation.this.orientation == Orientation.VERTICAL) {
                final int n = this.decorationPane.getHeight();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n == OverpaintablePanelBase.this.decorationPane.getHeight()) {
                            OverpaintablePanelBase.this.decorationPane.revalidate();
                        }
                    }
                });
            } else {
                final int n = this.decorationPane.getWidth();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (n == OverpaintablePanelBase.this.decorationPane.getWidth()) {
                            OverpaintablePanelBase.this.decorationPane.revalidate();
                        }
                    }
                });
            }
        }

        @Override
        protected void paintOverlay(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintDrag(graphics);
            if (ToolbarGroupDockStation.this.dropInfo != null && ToolbarGroupDockStation.this.dropInfo.hasEffect()) {
                Point point = new Point(0, 0);
                point = SwingUtilities.convertPoint(this.dockablePane, point, this);
                Rectangle rectangle = ToolbarGroupDockStation.this.getDropGapBoundaries();
                ToolbarGroupDockStation.this.paint.drawInsertion(graphics2D, new Rectangle(point.x, point.y, this.dockablePane.getWidth(), this.dockablePane.getHeight()), rectangle);
            }
        }

        private void paintDrag(Graphics graphics) {
            StationChildHandle stationChildHandle;
            Dockable dockable = ToolbarGroupDockStation.this.getRemoval();
            if (dockable != null && (stationChildHandle = ToolbarGroupDockStation.this.getHandle(dockable)) != null) {
                Rectangle rectangle = stationChildHandle.getDisplayer().getComponent().getBounds();
                JPanel jPanel = ((ToolbarGroupDockStation)ToolbarGroupDockStation.this).mainPanel.dockablePane;
                Point point = new Point(0, 0);
                point = SwingUtilities.convertPoint(jPanel, point, this);
                rectangle.x += point.x;
                rectangle.y += point.y;
                ToolbarGroupDockStation.this.getPaint().drawRemoval(graphics, rectangle, rectangle);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
        }
    }
}

