#version 130
// simple fragment shader
uniform sampler2D panoTex;
uniform sampler2D depthTex;

//uniform float zRatio; //1 is z-only, 0, color only
//uniform float zMult; //so that we see the zs better
//uniform int zType;//0 is depthbuffer, 1 is linear depth and 2 is calculated z
//uniform int redRangeMin;
//uniform int redRangeMax;
//uniform float panoRadius;

uniform float depthMultiplier = 1.0;

uniform float doDepth;

uniform ivec2 frameSize;
uniform float fov;

uniform float nearClip;
uniform float farClip;

uniform float intensityMin;
uniform float intensityMax;

uniform float brightness;// - 1.2 <> + 1.2
uniform float contrast;// 0.0 : none, 25.0 : burned
uniform float saturation;//0.0 : b&w, 25: heatmap.

uniform int isHigh;

out vec4 FragColor;
//returns linear values of depth between 0 and 1
float linearDepthFromDistanceMilli(float value, float max){
  return value / max;
}
//returns linear values of depth between 0 and 1
float linearDepthFromZSample(float value){
    float depthSample = 2.0 * value - 1.0;
    float zLinear = 2.0 * nearClip * farClip / (farClip + nearClip - depthSample * (farClip - nearClip));
    return 0.5 + .5 * zLinear;
}
//returns log values of depth between 0 and 1
float zDepthFromDistanceMilli(float value, float near, float far){

  float nearInv = 1 / near;
  float farInv = 1 / far;

  return ( (1 / value) - nearInv ) / (farInv - nearInv);
}

float getTheta(vec2 pixelPosition){
  vec2  fromCenter = vec2(pixelPosition.x - frameSize.x / 2, pixelPosition.y - frameSize.y / 2);
  float   e = length(fromCenter);

  return atan( ( e * 2 * tan(fov / 2) ) / frameSize.x );
}

//gives d* from d via an arctangent calculation
float transformDepth(float d, vec2 pixelPosition){
  float   THETA = getTheta(pixelPosition);

  return d * cos (THETA); 
}

//gives d* from d via an arctangent calculation
float transformDistanceBoris(float d, vec2 pixelPosition){
  float   THETA = getTheta(pixelPosition);

  return d * cos (THETA); 
}
mat4 brightnessMatrix( float brightness )
{
    return mat4( 1, 0, 0, 0,
                 0, 1, 0, 0,
                 0, 0, 1, 0,
                 brightness, brightness, brightness, 1 );
}

mat4 contrastMatrix( float contrast )
{
  float t = ( 1.0 - contrast ) / 2.0;
    
    return mat4( contrast, 0, 0, 0,
                 0, contrast, 0, 0,
                 0, 0, contrast, 0,
                 t, t, t, 1 );

}

mat4 saturationMatrix( float saturation )
{
    vec3 luminance = vec3( 0.3086, 0.6094, 0.0820 );
    
    float oneMinusSat = 1.0 - saturation;
    
    vec3 red = vec3( luminance.r * oneMinusSat );
    red+= vec3( saturation, 0, 0 );
    
    vec3 green = vec3( luminance.g * oneMinusSat );
    green += vec3( 0, saturation, 0 );
    
    vec3 blue = vec3( luminance.b * oneMinusSat );
    blue += vec3( 0, 0, saturation );
    
    return mat4( red,     0,
                 green,   0,
                 blue,    0,
                 0, 0, 0, 1 );
}

void main()
{
    vec2  tc0 = gl_TexCoord[0].xy;
    vec4 colorPick = texture2D(panoTex, tc0).rgba; // pick color
    ivec2 size = textureSize(depthTex, 0);
    vec2  tc1 = gl_TexCoord[1].xy;

    vec2 depthCoord = tc1 * vec2(size);
    ivec2 idepthCoord = ivec2( floor(depthCoord) );
    depthCoord -= idepthCoord;
    ivec4 dcsquare = ivec4(idepthCoord.xy, mod((idepthCoord.x +1), size.x), 0);
    dcsquare.w = idepthCoord.y + int(step(float(size.y), idepthCoord.y +1.0));//()

    //dcsquare = ivec4(idepthCoord.xy, idepthCoord.x -1.0, idepthCoord.y -1.0)

  vec4 depthPick[4] = vec4[](
    texelFetch(depthTex, dcsquare.xy, 0).rgba, // 
    texelFetch(depthTex, dcsquare.zy, 0).rgba, // 0 1
    texelFetch(depthTex, dcsquare.xw, 0).rgba, // 2 3
    texelFetch(depthTex, dcsquare.zw, 0).rgba
  ); //
  float depths[4];
  float depthMilli;
  for(int i = 0; i < 4; ++i){
    int red   = int(255*depthPick[i].r);
    int green = int(255*depthPick[i].g);
    int blue  = int(255*depthPick[i].b);

    int d = int(red/100)*256*256 + green*256 + blue;
//    if(d>0)
//      depths[i] = transformDepth(d, gl_FragCoord.xy); // distance oeil point transformée
//    else
//      depths[i] = 1000.0 * farClip; // distance oeil point transformée
  //optimized version of the same :
    depths[i] = mix( 0.0, transformDepth(d, gl_FragCoord.xy), (d>0) );
  }

  //TODO:optim
  float d1;
  if(depths[0] == 0.0)
    d1 = depths[1];
  else if(depths[1] == 0.0)
    d1 = depths[0];
  else
    d1 = mix(depths[0], depths[1], depthCoord.x);
  float d2;
  if(depths[2] == 0.0)
    d2 = depths[3];
  else if(depths[3] == 0.0)
    d2 = depths[2];
  else
    d2 = mix(depths[2], depths[3], depthCoord.x);
  if(d2 == 0.0)
    depthMilli = d1;
  else if(d1 == 0.0)
    depthMilli = d2;
  else
    depthMilli = mix(d1, d2, depthCoord.y);

  float depthMeters = depthMilli / 1000;

  if(isHigh == 0)
    depthMilli += 2 * (depthMeters * depthMeters);
  depthMilli += 9;
  depthMilli *= 1.005;
  
  float depth = zDepthFromDistanceMilli(float(depthMilli/1000), 1.0 * nearClip, 1.0 * farClip);
  //float depth = zDepthFromDistanceMilli(float(depths[0]/1000), 1.0 * nearClip, 1.0 * farClip);
  //FragColor = vec4(colorPick.rgb - 0.5, 1.0) * 3;
  FragColor = brightnessMatrix(brightness)
          * contrastMatrix(contrast)
          * saturationMatrix(saturation)
          * smoothstep(intensityMin, intensityMax, vec4(colorPick.rgb, 1.0));


  //FragColor = vec4(mix(colorPick.rgb, depthPick[0].rgb, 0.5), 1.0);// vec4(finalColor.rgb, 1.0);
  //FragColor = vec4(1.0, 0.0, 0.0, 1.0);
  
//  if(depthMilli >= 10.0 && doDepth > 0.5)
//    gl_FragDepth = depth;//
//  else
//    gl_FragDepth = 1.0;
//optimized no branching
  float maxDepth = gl_FragCoord.z;
  if(doDepth < 0.5)
    gl_FragDepth = gl_FragCoord.z;
  else
    gl_FragDepth = mix(maxDepth, depth, (depthMilli >= 10.0));// && doDepth > 0.5));
    
  return;
}