kernel void test_sumMeanSquares(global const float *radiusBuffer, global float4 *clResultBuffer, const int numTasks)
{
	const int iWorker = get_global_id(0); //The worker ID
	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iWorker >= numTasks)  
		return;
		
	clResultBuffer[iWorker].x = -1;
	clResultBuffer[iWorker].y = -1;
	clResultBuffer[iWorker].z = -1;
	clResultBuffer[iWorker].w = -1;
	
	const float r = radiusBuffer[iWorker];
	if (r<=0 || r>CIRCLE_DETECTION_GRID_SIZE/2)
		return;

	int nbCellsFilled = 0;
	const uchar cx = (CIRCLE_DETECTION_GRID_SIZE-1)/2 + 1;
	const uchar cy = cx;
	
	const float parametres[3] = { cx, cy, r };

	uchar topologyGrid[CIRCLE_DETECTION_GRID_SIZE*CIRCLE_DETECTION_GRID_SIZE] = {0};
	for (int x=0; x<CIRCLE_DETECTION_GRID_SIZE; x++)
	{
		for (int y=0; y<CIRCLE_DETECTION_GRID_SIZE; y++)
		{
			float d = sqrt((float)((x-cx) * (x-cx) + (y-cy) * (y-cy)));
			if (fabs(d-r) < 1)
			{
				topologyGrid[y*CIRCLE_DETECTION_GRID_SIZE+x] = 1;
				nbCellsFilled ++;
			}
		}
	}
	if (nbCellsFilled == 0)
		return;
		
	float sumMeanSquares = calculateSumMeanSquaresCircle(topologyGrid, 1, CIRCLE_DETECTION_GRID_SIZE, CIRCLE_DETECTION_GRID_SIZE, parametres);
	float score = sumMeanSquares / nbCellsFilled;
	
	clResultBuffer[iWorker].x = sumMeanSquares;
	clResultBuffer[iWorker].y = score;
	clResultBuffer[iWorker].z = sqrt(score);
	clResultBuffer[iWorker].w = nbCellsFilled;
}

kernel void test_methodeLevenbergMarquardtCircle(global const float *radiusBuffer, global float4 *clResultBuffer, const int numTasks)
{
	const int iWorker = get_global_id(0); //The worker ID
	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iWorker >= numTasks)  
		return;
		
	clResultBuffer[iWorker].x = -1;
	clResultBuffer[iWorker].y = -1;
	clResultBuffer[iWorker].z = -1;
	clResultBuffer[iWorker].w = -1;
	
	const float r = radiusBuffer[iWorker];
	if (r<=0 || r>CIRCLE_DETECTION_GRID_SIZE/2)
		return;

	int nbCellsFilled = 0;
	const uchar cx = (CIRCLE_DETECTION_GRID_SIZE-1)/2 + 1;
	const uchar cy = cx;
	
	const float parametres[3] = { cx, cy, r };

	uchar topologyGrid[CIRCLE_DETECTION_GRID_SIZE*CIRCLE_DETECTION_GRID_SIZE] = {0};
	for (int x=0; x<CIRCLE_DETECTION_GRID_SIZE; x++)
	{
		for (int y=0; y<CIRCLE_DETECTION_GRID_SIZE; y++)
		{
			float d = sqrt((float)((x-cx) * (x-cx) + (y-cy) * (y-cy)));
			if (fabs(d-r) < 1)
			{
				topologyGrid[y*CIRCLE_DETECTION_GRID_SIZE+x] = 1;
				nbCellsFilled ++;
			}
		}
	}
	if (nbCellsFilled == 0)
		return;

	float radiusMaxAllowed = infinity;
	float parametresOptimises[3] = { 0 };
	float score = doCircleLevenbergMarquardt(topologyGrid, 1, CIRCLE_DETECTION_GRID_SIZE, CIRCLE_DETECTION_GRID_SIZE, radiusMaxAllowed, parametresOptimises, 5, -1);		


	clResultBuffer[iWorker].x = parametresOptimises[circleParamIndexX];
	clResultBuffer[iWorker].y = parametresOptimises[circleParamIndexY];
	clResultBuffer[iWorker].z = parametresOptimises[circleParamIndexR];
	clResultBuffer[iWorker].w = score;
}