/*
 * Decompiled with CFR 0.152.
 */
package cadex;

import cadex.CadExCoreJNI;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.CRC32;

public class LicenseManager {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected LicenseManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(LicenseManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExCoreJNI.delete_LicenseManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static boolean CADExLicense_ActivateRuntimeKeyFromAbsolutePath(String theKey) {
        try {
            StackTraceElement[] aStack = Thread.currentThread().getStackTrace();
            HashSet<Long> aChecksumSet = new HashSet<Long>();
            for (StackTraceElement aFrame : aStack) {
                String aSchema;
                Class<?> aClass = Class.forName(aFrame.getClassName());
                String aRawName = aFrame.getClassName();
                int idx = aRawName.lastIndexOf(46);
                String aClassFileName = (idx == -1 ? aRawName : aRawName.substring(idx + 1)) + ".class";
                String aUri = aClass.getResource(aClassFileName).toString();
                int idx2 = aUri.indexOf("!");
                if (aUri.startsWith("jar:file:")) {
                    aSchema = "jar:file:";
                } else {
                    if (!aUri.startsWith("file:")) continue;
                    aSchema = "file:";
                }
                String anEncodedArtifactFileName = idx2 == -1 ? aUri.substring(aSchema.length()) : aUri.substring(aSchema.length(), idx2);
                String anArtifactFileName = URLDecoder.decode(anEncodedArtifactFileName, Charset.defaultCharset().name());
                File anArtifactFile = new File(anArtifactFileName);
                byte[] anArtifactContents = new byte[(int)anArtifactFile.length()];
                new FileInputStream(anArtifactFile).read(anArtifactContents);
                CRC32 aChecksummer = new CRC32();
                aChecksummer.update(anArtifactContents);
                aChecksumSet.add(aChecksummer.getValue());
            }
            StringBuilder aHashStringBuilder = new StringBuilder();
            Iterator iterator = aChecksumSet.iterator();
            while (iterator.hasNext()) {
                long aHash = (Long)iterator.next();
                aHashStringBuilder.append(aHash);
                aHashStringBuilder.append(';');
            }
            if (aHashStringBuilder.length() > 0) {
                aHashStringBuilder.deleteCharAt(aHashStringBuilder.length() - 1);
            }
            int aLangJava = 2;
            return LicenseManager.CADExLicense_ActivateRuntimeKeyInternal(theKey, aHashStringBuilder.toString(), 2);
        }
        catch (Exception anE) {
            return false;
        }
    }

    private static boolean CADExLicense_ActivateRuntimeKeyInternal(String theKey, String theLocations, int theLanguage) {
        return CadExCoreJNI.LicenseManager_CADExLicense_ActivateRuntimeKeyInternal(theKey, theLocations, theLanguage);
    }

    public static void Acquire(String theModule) {
        CadExCoreJNI.LicenseManager_Acquire(theModule);
    }

    public static boolean Activate(String theKey) {
        return CadExCoreJNI.LicenseManager_Activate(theKey);
    }

    public LicenseManager() {
        this(CadExCoreJNI.new_LicenseManager(), true);
    }
}

