/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Orientation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ToolbarGroupDockStationLayout;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layout.PerspectivePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.PlaceholderToolbarGridConverter;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarGroupDockPerspective
implements PerspectiveStation,
PerspectiveDockable {
    private PerspectivePlaceholderToolbarGrid dockables;
    private PerspectiveStation parent;
    private ExpandedState state = ExpandedState.SHRUNK;
    private Orientation orientation = Orientation.HORIZONTAL;

    public ToolbarGroupDockPerspective() {
        this.dockables = new PerspectivePlaceholderToolbarGrid();
    }

    public ToolbarGroupDockPerspective(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        this.dockables = new PerspectivePlaceholderToolbarGrid();
        this.read(toolbarGroupDockStationLayout, map);
    }

    public void read(ToolbarGroupDockStationLayout toolbarGroupDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        this.state = toolbarGroupDockStationLayout.getState();
        this.dockables.fromMap(toolbarGroupDockStationLayout.getPlaceholders(), map, new PlaceholderToolbarGridConverter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(PerspectiveDockable perspectiveDockable, ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                return perspectiveDockable;
            }

            @Override
            public void added(PerspectiveDockable perspectiveDockable) {
                perspectiveDockable.setParent(ToolbarGroupDockPerspective.this);
            }
        });
        this.orientation = ToolbarGroupDockStationLayout.readOrientation(toolbarGroupDockStationLayout.getPlaceholders());
    }

    public PerspectivePlaceholderToolbarGrid getDockables() {
        return this.dockables;
    }

    public PlaceholderMap toMap(Map<PerspectiveDockable, Integer> map) {
        PlaceholderMap placeholderMap = this.dockables.toMap(map);
        ToolbarGroupDockStationLayout.writeOrientation(placeholderMap, this.orientation);
        return placeholderMap;
    }

    public void setExpandedtState(ExpandedState expandedState) {
        if (expandedState == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        this.state = expandedState;
    }

    public ExpandedState getExpandedState() {
        return this.state;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        this.orientation = orientation;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public ToolbarColumnModel<PerspectiveDockable, PerspectiveDockable> getModel() {
        return this.dockables.getModel();
    }

    public PerspectiveDockable getDockable(int n, int n2) {
        return this.getModel().getColumn((PerspectiveDockable)n).getDockable(n2);
    }

    public int getColumnCount() {
        return this.dockables.getColumnCount();
    }

    public int getLineCount(int n) {
        return this.dockables.getLineCount(n);
    }

    public void add(int n, PerspectiveDockable perspectiveDockable) {
        int n2 = 0;
        if (n >= 0 && n < this.getColumnCount()) {
            n2 = this.getLineCount(n);
        }
        this.insert(n, n2, perspectiveDockable);
    }

    public void insert(int n, int n2, PerspectiveDockable perspectiveDockable) {
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        this.dockables.insert(n, n2, perspectiveDockable);
        perspectiveDockable.setParent(this);
    }

    public void insert(int n, PerspectiveDockable perspectiveDockable) {
        DockUtilities.ensureTreeValidity(this, perspectiveDockable);
        this.dockables.insert(n, perspectiveDockable);
        perspectiveDockable.setParent(this);
    }

    public void remove(int n, int n2) {
        this.remove(this.getDockable(n, n2));
    }

    @Override
    public String getFactoryID() {
        return "ToolbarGroupDockStationFactory";
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public PerspectiveDockable asDockable() {
        return this;
    }

    @Override
    public Path getPlaceholder() {
        return null;
    }

    @Override
    public PerspectiveStation getParent() {
        return this.parent;
    }

    @Override
    public void setParent(PerspectiveStation perspectiveStation) {
        this.parent = perspectiveStation;
    }

    @Override
    public int getDockableCount() {
        return this.dockables.size();
    }

    @Override
    public PerspectiveDockable getDockable(int n) {
        return (PerspectiveDockable)this.dockables.get(n);
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        int n = this.dockables.getColumn(perspectiveDockable);
        int n2 = this.dockables.getLine(n, perspectiveDockable);
        Path path = perspectiveDockable2 == null ? perspectiveDockable.getPlaceholder() : perspectiveDockable2.getPlaceholder();
        return new ToolbarGroupProperty(n, n2, path);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        PlaceholderMap placeholderMap = this.dockables.toMap();
        ToolbarGroupDockStationLayout.writeOrientation(placeholderMap, this.orientation);
        return placeholderMap;
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholderMap) {
        this.dockables.fromMap(placeholderMap);
    }

    @Override
    public boolean remove(PerspectiveDockable perspectiveDockable) {
        return this.dockables.remove(perspectiveDockable);
    }

    @Override
    public void replace(PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        this.dockables.replace(perspectiveDockable, perspectiveDockable2);
    }
}

