/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.layout.grid.Column;
import bibliothek.gui.dock.station.toolbar.layout.grid.ColumnItem;
import bibliothek.util.Path;

public abstract class GridPlaceholderList<D, S, P extends PlaceholderListItem<D>>
extends PlaceholderList<ColumnItem<D, S, P>, ColumnItem<D, S, P>, Column<D, S, P>> {
    private PlaceholderListItemConverter<D, P> converter;

    public GridPlaceholderList() {
        this.setConverter(null);
    }

    public Column<D, S, P> createColumn(PlaceholderList<D, S, P> placeholderList) {
        if (placeholderList == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        return new ColumnList(placeholderList);
    }

    public void setConverter(PlaceholderListItemConverter<D, P> placeholderListItemConverter) {
        if (placeholderListItemConverter == null) {
            placeholderListItemConverter = new PlaceholderListItemConverter<D, P>(){

                @Override
                public ConvertedPlaceholderListItem convert(int n, P p) {
                    return null;
                }

                @Override
                public P convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                    return null;
                }

                @Override
                public void added(P p) {
                }
            };
        }
        this.converter = placeholderListItemConverter;
    }

    public PlaceholderListItemConverter<D, P> getConverter() {
        return this.converter;
    }

    @Override
    protected Path getPlaceholder(ColumnItem<D, S, P> columnItem) {
        return columnItem.getPlaceholder();
    }

    @Override
    protected String toString(ColumnItem<D, S, P> columnItem) {
        return columnItem.toString();
    }

    @Override
    protected ColumnItem<D, S, P> toStation(ColumnItem<D, S, P> columnItem) {
        return columnItem.asStation();
    }

    @Override
    protected PlaceholderMap getPlaceholders(ColumnItem<D, S, P> columnItem) {
        return columnItem.getPlaceholders();
    }

    @Override
    protected void setPlaceholders(ColumnItem<D, S, P> columnItem, PlaceholderMap placeholderMap) {
        columnItem.setPlaceholders(placeholderMap);
    }

    protected ColumnItem<D, S, P>[] getChildren(ColumnItem<D, S, P> columnItem) {
        return columnItem.getChildren();
    }

    protected abstract S itemToStation(D var1);

    protected abstract D[] getItemChildren(S var1);

    protected abstract Path getItemPlaceholder(D var1);

    protected abstract PlaceholderMap getItemPlaceholders(S var1);

    protected abstract void setItemPlaceholders(S var1, PlaceholderMap var2);

    private class ColumnList
    implements Column<D, S, P> {
        private final PlaceholderList<D, S, P> list;

        public ColumnList(PlaceholderList<D, S, P> placeholderList) {
            this.list = placeholderList;
        }

        @Override
        public ColumnItem<D, S, P> asDockable() {
            return this;
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            return this;
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            ColumnItem[] columnItemArray = new ColumnItem[this.list.dockables().size()];
            int n = 0;
            for (PlaceholderListItem placeholderListItem : this.list.dockables()) {
                columnItemArray[n++] = new DockableItem(placeholderListItem.asDockable());
            }
            return columnItemArray;
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return this.list.toMap(GridPlaceholderList.this.converter);
        }

        @Override
        public void setPlaceholders(PlaceholderMap placeholderMap) {
            this.list.clear();
            this.list.read(placeholderMap, GridPlaceholderList.this.converter);
        }

        @Override
        public PlaceholderList<D, S, P> getList() {
            return this.list;
        }

        @Override
        public Path getPlaceholder() {
            return null;
        }
    }

    private class StationItem
    implements ColumnItem<D, S, P> {
        private final S item;

        public StationItem(S s) {
            this.item = s;
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            return this;
        }

        @Override
        public Path getPlaceholder() {
            throw new IllegalStateException("a " + this.getClass().getSimpleName() + " must not be asked for its placeholder");
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            D[] DArray = GridPlaceholderList.this.getItemChildren(this.item);
            ColumnItem[] columnItemArray = new ColumnItem[DArray.length];
            for (int i = 0; i < columnItemArray.length; ++i) {
                columnItemArray[i] = new DockableItem(DArray[i]);
            }
            return columnItemArray;
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return GridPlaceholderList.this.getItemPlaceholders(this.item);
        }

        @Override
        public void setPlaceholders(PlaceholderMap placeholderMap) {
            GridPlaceholderList.this.setItemPlaceholders(this.item, placeholderMap);
        }
    }

    private class DockableItem
    implements ColumnItem<D, S, P> {
        private final D item;

        public DockableItem(D d) {
            this.item = d;
        }

        public String toString() {
            return this.item.toString();
        }

        @Override
        public ColumnItem<D, S, P> asStation() {
            Object s = GridPlaceholderList.this.itemToStation(this.item);
            if (s == null) {
                return null;
            }
            return new StationItem(s);
        }

        @Override
        public Path getPlaceholder() {
            return GridPlaceholderList.this.getItemPlaceholder(this.item);
        }

        @Override
        public ColumnItem<D, S, P>[] getChildren() {
            throw new IllegalStateException("a " + this.getClass().getSimpleName() + " must not be asked for its children");
        }

        @Override
        public PlaceholderMap getPlaceholders() {
            return null;
        }

        @Override
        public void setPlaceholders(PlaceholderMap placeholderMap) {
        }
    }
}

