kernel void fillBlankPixelsFromNeighbors(global const uchar4 *srcBuffer, global const int *srcFlag, __global uchar4 *destBuffer,
											int W, int H, int blankPixelsSearchHalfRange, float ratioNoInfoNeighborsMaxAllowed)
{
   int col = get_global_id(0);
   int row = get_global_id(1);
   if ((col>=W)||(row>=H))
   {
      return;
   }
   int index = row*W+col;
   if ((row<blankPixelsSearchHalfRange)||(row>=H-blankPixelsSearchHalfRange))
   {
      destBuffer[index] = srcBuffer[index];
      return;
   }
   if (srcFlag[index]==1)
   {
      destBuffer[index] = srcBuffer[index];
      return;
   }
   int nbNoInfoInNeighborhood = 0;
   int vignetSize = (2*blankPixelsSearchHalfRange+1)*(2*blankPixelsSearchHalfRange+1);
   for (int ck=-blankPixelsSearchHalfRange; ck<=blankPixelsSearchHalfRange; ck++)
   {
      int ic = col+ck;
      if (ic<0) ic+=W;
      if (ic>=W) ic-=W;
      for (int rk=-blankPixelsSearchHalfRange; rk<=blankPixelsSearchHalfRange; rk++)
      {
         int ind2 = (row+rk)*W+ic;
         if (srcFlag[ind2]==0) nbNoInfoInNeighborhood++;
      }
   }
   if ((float)nbNoInfoInNeighborhood/(float)vignetSize > ratioNoInfoNeighborsMaxAllowed)
   {
      destBuffer[index] = srcBuffer[index];	
      return;
   }
   int4 localSums = (int4)(0);
   int localPtCtr = 0;
   for (int ck=-blankPixelsSearchHalfRange; ck<=blankPixelsSearchHalfRange; ck++)
   {
      int ic = col+ck;
      if (ic<0) ic+=W;
      if (ic>=W) ic-=W;
      for (int rk=-blankPixelsSearchHalfRange; rk<=blankPixelsSearchHalfRange; rk++)
      {
         int ir = row+rk;
         int ind2 = ir*W + ic;
         if (srcFlag[ind2]==1)
         {
            uchar4 neighbor = srcBuffer[ind2];
            localSums.x+=neighbor.x;
            localSums.y+=neighbor.y;
            localSums.z+=neighbor.z;
            localSums.w+=neighbor.w;
            localPtCtr++;
         }
      }
   }
   if (localPtCtr!=0)
   {
      localSums/=localPtCtr;
      uchar4 interpolatedValue = (uchar)(0);
      interpolatedValue.x = (uchar)localSums.x;
      interpolatedValue.y = (uchar)localSums.y;
      interpolatedValue.z = (uchar)localSums.z;
      interpolatedValue.w = (uchar)localSums.w;
      destBuffer[index] = interpolatedValue;
   }
   else
   {
      destBuffer[index] = srcBuffer[index];	
   }
}