	typedef struct {
		char4 x;
		char4 y;
		char4 z;
		char4 color;
		char4 id;
		
	} point;

    // OpenCL Kernel Function for element by element vector addition
    kernel void IsInSphereOpti(global const point* listPoints, global int* arePointsInside, int pivotRealWorldX, int pivotRealWorldY, int pivotRealWorldZ, float centerX, float centerY, float centerZ, float r, int numPoints) {

        // get index into global data array
        int iGID = get_global_id(0);        

        // bound check (equivalent to the limit on a 'for' loop for standard/serial C code
        if (iGID >= numPoints)  {
            return;
        }
        point pt = listPoints[iGID];
        
        int x = (pt.x[0] & 0xFF) << 24 | (pt.x[1] & 0xFF) << 16 | (pt.x[2] & 0xFF) << 8 | (pt.x[3] & 0xFF) << 0;
        int y = (pt.y[0] & 0xFF) << 24 | (pt.y[1] & 0xFF) << 16 | (pt.y[2] & 0xFF) << 8 | (pt.y[3] & 0xFF) << 0;
        int z = (pt.z[0] & 0xFF) << 24 | (pt.z[1] & 0xFF) << 16 | (pt.z[2] & 0xFF) << 8 | (pt.z[3] & 0xFF) << 0;
        
        float xf = ((float) -x)  /1000.0;
        float yf =  ((float) z)  /1000.0;
        float zf =  ((float) y)  /1000.0;

        //TODO : pass pivot as const, convert data from mm local to m global

		float3 center = (float3) (centerX, centerY, centerZ);

		float3 distanceVector = (float3)(xf - center.x, yf - center.y, zf - center.z);

		float length = sqrt(dot(distanceVector, distanceVector));
		
		
		arePointsInside[iGID] = (int) (length <= r);
}


