/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import java.util.AbstractList;
import java.util.RandomAccess;

public class IntList
extends AbstractList<Integer>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public IntList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(IntList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(IntList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_IntList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IntList(int[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (int element : initialElements) {
            this.add(element);
        }
    }

    public IntList(Iterable<Integer> initialElements) {
        this();
        for (int element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Integer get(int index) {
        return this.doGet(index);
    }

    @Override
    public Integer set(int index, Integer e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Integer e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Integer e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Integer remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public IntList() {
        this(CadExMTKJNI.new_std_IntList__SWIG_0(), true);
    }

    public IntList(IntList other) {
        this(CadExMTKJNI.new_std_IntList__SWIG_1(IntList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_IntList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_IntList_clear(this.swigCPtr, this);
    }

    public IntList(int count, int value) {
        this(CadExMTKJNI.new_std_IntList__SWIG_2(count, value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_IntList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_IntList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_IntList_doSize(this.swigCPtr, this);
    }

    private void doAdd(int x) {
        CadExMTKJNI.std_IntList_doAdd__SWIG_0(this.swigCPtr, this, x);
    }

    private void doAdd(int index, int x) {
        CadExMTKJNI.std_IntList_doAdd__SWIG_1(this.swigCPtr, this, index, x);
    }

    private int doRemove(int index) {
        return CadExMTKJNI.std_IntList_doRemove(this.swigCPtr, this, index);
    }

    private int doGet(int index) {
        return CadExMTKJNI.std_IntList_doGet(this.swigCPtr, this, index);
    }

    private int doSet(int index, int val) {
        return CadExMTKJNI.std_IntList_doSet(this.swigCPtr, this, index, val);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_IntList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

