/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanMode;
import bibliothek.gui.dock.station.span.SpanUsage;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.themes.StationSpanFactoryValue;
import bibliothek.gui.dock.wizard.WizardNodeMap;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import java.awt.Dimension;

public class WizardSpanStrategy {
    private WizardSplitDockStation station;
    private Span[][] cellSpans = new Span[0][0];
    private Span[] columnSpans = new Span[0];
    private StationSpanFactoryValue factory;
    private int selectedColumn = -1;
    private int selectedCell = -1;

    public WizardSpanStrategy(WizardSplitDockStation wizardSplitDockStation) {
        this.station = wizardSplitDockStation;
        this.factory = new StationSpanFactoryValue("dock.spanFactory.wizard", wizardSplitDockStation){

            @Override
            protected void changed() {
                WizardSpanStrategy.this.reset();
            }
        };
        wizardSplitDockStation.addDockStationListener(new DockStationAdapter(){

            @Override
            public void dockableAdded(DockStation dockStation, Dockable dockable) {
                WizardSpanStrategy.this.checkReset();
            }

            @Override
            public void dockableRemoved(DockStation dockStation, Dockable dockable) {
                WizardSpanStrategy.this.checkReset();
            }

            @Override
            public void dockablesRepositioned(DockStation dockStation, Dockable[] dockableArray) {
                WizardSpanStrategy.this.checkReset();
            }
        });
    }

    public void setController(DockController dockController) {
        this.factory.setController(dockController);
    }

    private void checkReset() {
        WizardNodeMap wizardNodeMap = this.station.getWizardSplitLayoutManager().getMap();
        WizardNodeMap.Column[] columnArray = wizardNodeMap.getSortedColumns();
        if (columnArray.length != this.columnSpans.length - 1) {
            this.reset();
        } else {
            for (int i = 0; i < columnArray.length; ++i) {
                if (this.cellSpans[i].length - 1 == columnArray[i].getCellCount()) continue;
                this.reset();
                return;
            }
        }
    }

    public void reset() {
        int n;
        this.selectedColumn = -1;
        this.selectedCell = -1;
        WizardNodeMap wizardNodeMap = this.station.getWizardSplitLayoutManager().getMap();
        WizardNodeMap.Column[] columnArray = wizardNodeMap.getSortedColumns();
        this.columnSpans = new Span[columnArray.length + 1];
        this.cellSpans = new Span[columnArray.length][];
        Callback callback = new Callback(true);
        Callback callback2 = new Callback(false);
        int n2 = this.station.getDividerSize();
        for (n = 0; n < this.columnSpans.length; ++n) {
            this.columnSpans[n] = this.factory.create(callback);
        }
        for (n = 1; n < columnArray.length; ++n) {
            this.columnSpans[n].configureSize(SpanMode.OFF, n2);
        }
        for (n = 0; n < columnArray.length; ++n) {
            int n3;
            int n4 = columnArray[n].getCellCount();
            this.cellSpans[n] = new Span[n4 + 1];
            for (n3 = 0; n3 < this.cellSpans[n].length; ++n3) {
                this.cellSpans[n][n3] = this.factory.create(callback2);
            }
            for (n3 = 1; n3 < n4; ++n3) {
                this.cellSpans[n][n3].configureSize(SpanMode.OFF, n2);
            }
        }
    }

    public void setPut(PutInfo putInfo) {
        if (putInfo == null || putInfo.getCombinerTarget() != null) {
            this.setPut(-1, -1);
        } else if (putInfo.getNode() == null) {
            this.setPut(0, -1);
        } else {
            WizardNodeMap wizardNodeMap = this.station.getWizardSplitLayoutManager().getMap();
            SplitNode splitNode = putInfo.getNode();
            splitNode = this.traverseDown(splitNode);
            WizardNodeMap.Column column = wizardNodeMap.getColumn(splitNode);
            Dimension dimension = putInfo.getDockable().getComponent().getPreferredSize();
            int n = dimension.width;
            int n2 = dimension.height;
            if (this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                for (Span span : this.columnSpans) {
                    span.configureSize(SpanMode.OPEN, n);
                }
                Object object = this.cellSpans;
                int n3 = ((Span[])object).length;
                for (int i = 0; i < n3; ++i) {
                    Span span;
                    for (Span span2 : span = object[i]) {
                        span2.configureSize(SpanMode.OPEN, n2);
                    }
                }
                if (putInfo.getPut() == PutInfo.Put.LEFT) {
                    this.setPut(column.getIndex(), -1);
                } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
                    this.setPut(column.getIndex() + 1, -1);
                } else if (putInfo.getPut() == PutInfo.Put.TOP) {
                    object = column.getLeftmostCell(splitNode);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)object).getIndex());
                } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
                    object = column.getRightmostCell(splitNode);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)object).getIndex() + 1);
                }
            } else {
                for (Span span : this.columnSpans) {
                    span.configureSize(SpanMode.OPEN, n2);
                }
                Object object = this.cellSpans;
                int n4 = ((Span[])object).length;
                for (int i = 0; i < n4; ++i) {
                    Span span;
                    for (Span span3 : span = object[i]) {
                        span3.configureSize(SpanMode.OPEN, n);
                    }
                }
                if (putInfo.getPut() == PutInfo.Put.LEFT) {
                    object = column.getLeftmostCell(splitNode);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)object).getIndex());
                } else if (putInfo.getPut() == PutInfo.Put.RIGHT) {
                    object = column.getRightmostCell(splitNode);
                    this.setPut(column.getIndex(), ((WizardNodeMap.Cell)object).getIndex() + 1);
                } else if (putInfo.getPut() == PutInfo.Put.TOP) {
                    this.setPut(column.getIndex(), -1);
                } else if (putInfo.getPut() == PutInfo.Put.BOTTOM) {
                    this.setPut(column.getIndex() + 1, -1);
                }
            }
        }
    }

    private SplitNode traverseDown(SplitNode splitNode) {
        while (splitNode instanceof Node) {
            Node node = (Node)splitNode;
            boolean bl = node.getLeft().isVisible();
            boolean bl2 = node.getRight().isVisible();
            if (!bl && bl2) {
                splitNode = node.getRight();
                continue;
            }
            if (!bl || bl2) break;
            splitNode = node.getLeft();
        }
        return splitNode;
    }

    private void setPut(int n, int n2) {
        int n3;
        this.selectedColumn = n;
        this.selectedCell = n2;
        for (n3 = 0; n3 < this.columnSpans.length; ++n3) {
            if (n3 == n && n2 == -1) {
                this.columnSpans[n3].mutate(SpanMode.OPEN);
                continue;
            }
            this.columnSpans[n3].mutate(SpanMode.OFF);
        }
        for (n3 = 0; n3 < this.cellSpans.length; ++n3) {
            for (int i = 0; i < this.cellSpans[n3].length; ++i) {
                if (n3 == n && i == n2) {
                    this.cellSpans[n3][i].mutate(SpanMode.OPEN);
                    continue;
                }
                this.cellSpans[n3][i].mutate(SpanMode.OFF);
            }
        }
    }

    public void unsetPut() {
        this.selectedColumn = -1;
        this.selectedCell = -1;
        for (Span span : this.columnSpans) {
            span.set(SpanMode.OFF);
        }
        Span[] spanArray = this.cellSpans;
        int n = spanArray.length;
        for (int i = 0; i < n; ++i) {
            Span span;
            for (Span span2 : span = spanArray[i]) {
                span2.set(SpanMode.OFF);
            }
        }
    }

    public int getGap() {
        if (this.selectedColumn == -1) {
            return this.station.getDividerSize();
        }
        if (this.selectedCell == -1) {
            if (this.selectedColumn >= this.columnSpans.length) {
                return this.station.getDividerSize();
            }
            return this.getSize(this.columnSpans[this.selectedColumn]);
        }
        if (this.selectedColumn >= this.cellSpans.length) {
            return this.station.getDividerSize();
        }
        Span[] spanArray = this.cellSpans[this.selectedColumn];
        if (this.selectedCell >= spanArray.length) {
            return this.station.getDividerSize();
        }
        return this.getSize(spanArray[this.selectedCell]);
    }

    public int getGap(int n) {
        if (n >= this.columnSpans.length) {
            return 0;
        }
        return this.getSize(this.columnSpans[n]);
    }

    public int getGap(int n, int n2) {
        if (n >= this.cellSpans.length) {
            return 0;
        }
        if (n2 >= this.cellSpans[n].length) {
            return 0;
        }
        return this.getSize(this.cellSpans[n][n2]);
    }

    protected int getSize(Span span) {
        return span.getSize();
    }

    public int getGap(Node node, WizardNodeMap wizardNodeMap) {
        WizardNodeMap.Column column = wizardNodeMap.getColumn(node);
        if (column == null) {
            return 0;
        }
        for (SplitNode splitNode = column.getRoot().getParent(); splitNode != null; splitNode = splitNode.getParent()) {
            if (splitNode != node) continue;
            return this.getGap(column.getIndex());
        }
        WizardNodeMap.Cell cell = column.getLeftmostCell(node.getRight());
        if (cell == null) {
            return this.getGap(column.getIndex());
        }
        return this.getGap(column.getIndex(), cell.getIndex());
    }

    private class Callback
    implements SpanCallback {
        private boolean column;

        public Callback(boolean bl) {
            this.column = bl;
        }

        @Override
        public DockStation getStation() {
            return WizardSpanStrategy.this.station;
        }

        @Override
        public boolean isHorizontal() {
            if (this.column) {
                return WizardSpanStrategy.this.station.getSide().getHeaderOrientation() == SplitDockStation.Orientation.HORIZONTAL;
            }
            return WizardSpanStrategy.this.station.getSide().getColumnOrientation() == SplitDockStation.Orientation.HORIZONTAL;
        }

        @Override
        public boolean isVertical() {
            return !this.isHorizontal();
        }

        @Override
        public void resized() {
            WizardSpanStrategy.this.station.revalidateOutside();
        }

        @Override
        public SpanUsage getUsage() {
            return SpanUsage.INSERTING;
        }
    }
}

