/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.wizard;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.station.split.SplitDockStationFactory;
import bibliothek.gui.dock.station.split.SplitDockStationLayout;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.wizard.PersistentCell;
import bibliothek.gui.dock.wizard.PersistentColumn;
import bibliothek.gui.dock.wizard.WizardSplitDockStation;
import bibliothek.gui.dock.wizard.WizardSplitDockStationLayout;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class WizardSplitDockStationFactory
extends SplitDockStationFactory {
    public static final String ID = "WizardSplitDockStationFactory";

    @Override
    protected SplitDockStationLayout createLayout(SplitDockStationLayout.Entry entry, int n, boolean bl) {
        return new WizardSplitDockStationLayout(entry, n, bl);
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public void setLayout(SplitDockStation splitDockStation, SplitDockStationLayout splitDockStationLayout, Map<Integer, Dockable> map, PlaceholderStrategy placeholderStrategy) {
        super.setLayout(splitDockStation, splitDockStationLayout, map, placeholderStrategy);
        WizardSplitDockStation wizardSplitDockStation = (WizardSplitDockStation)splitDockStation;
        WizardSplitDockStationLayout wizardSplitDockStationLayout = (WizardSplitDockStationLayout)splitDockStationLayout;
        WizardSplitDockStationLayout.Column[] columnArray = wizardSplitDockStationLayout.getColumns();
        Dockable[][] dockableArray = new Dockable[columnArray.length][];
        int[][] nArrayArray = new int[dockableArray.length][];
        int[] nArray = new int[dockableArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            dockableArray[i] = new Dockable[columnArray[i].getCellKeys().length];
            nArrayArray[i] = new int[dockableArray[i].length];
            nArray[i] = columnArray[i].getSize();
            for (int j = 0; j < nArrayArray[i].length; ++j) {
                dockableArray[i][j] = map.get(columnArray[i].getCellKeys()[j]);
                nArrayArray[i][j] = columnArray[i].getCellSizes()[j];
            }
        }
        wizardSplitDockStation.setPersistentColumns(dockableArray, nArrayArray, nArray);
    }

    @Override
    public SplitDockStationLayout getLayout(SplitDockStation splitDockStation, Map<Dockable, Integer> map) {
        WizardSplitDockStation wizardSplitDockStation = (WizardSplitDockStation)splitDockStation;
        WizardSplitDockStationLayout wizardSplitDockStationLayout = (WizardSplitDockStationLayout)super.getLayout(splitDockStation, map);
        PersistentColumn[] persistentColumnArray = wizardSplitDockStation.getPersistentColumns();
        WizardSplitDockStationLayout.Column[] columnArray = new WizardSplitDockStationLayout.Column[persistentColumnArray.length];
        for (int i = 0; i < persistentColumnArray.length; ++i) {
            int n = persistentColumnArray[i].getSize();
            Map<Dockable, PersistentCell> map2 = persistentColumnArray[i].getCells();
            int[] nArray = new int[map2.size()];
            int[] nArray2 = new int[map2.size()];
            int n2 = 0;
            for (Map.Entry<Dockable, PersistentCell> entry : map2.entrySet()) {
                nArray[n2] = map.get(entry.getKey());
                nArray2[n2] = entry.getValue().getSize();
                ++n2;
            }
            columnArray[i] = new WizardSplitDockStationLayout.Column(n, nArray, nArray2);
        }
        wizardSplitDockStationLayout.setColumns(columnArray);
        return wizardSplitDockStationLayout;
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, DataOutputStream dataOutputStream) throws IOException {
        super.write(splitDockStationLayout, dataOutputStream);
        Version.write(dataOutputStream, Version.VERSION_1_1_1);
        WizardSplitDockStationLayout.Column[] columnArray = ((WizardSplitDockStationLayout)splitDockStationLayout).getColumns();
        dataOutputStream.writeInt(columnArray.length);
        for (WizardSplitDockStationLayout.Column column : columnArray) {
            dataOutputStream.writeInt(column.getSize());
            int[] nArray = column.getCellKeys();
            int[] nArray2 = column.getCellSizes();
            dataOutputStream.writeInt(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
                dataOutputStream.writeInt(nArray2[i]);
            }
        }
    }

    @Override
    public void write(SplitDockStationLayout splitDockStationLayout, XElement xElement) {
        WizardSplitDockStationLayout.Column[] columnArray;
        super.write(splitDockStationLayout, xElement.addElement("split"));
        xElement = xElement.addElement("wizard");
        for (WizardSplitDockStationLayout.Column column : columnArray = ((WizardSplitDockStationLayout)splitDockStationLayout).getColumns()) {
            XElement xElement2 = xElement.addElement("column");
            xElement2.addInt("size", column.getSize());
            int[] nArray = column.getCellKeys();
            int[] nArray2 = column.getCellSizes();
            for (int i = 0; i < nArray.length; ++i) {
                XElement xElement3 = xElement2.addElement("cell");
                xElement3.addInt("key", nArray[i]);
                xElement3.addInt("size", nArray2[i]);
            }
        }
    }

    @Override
    public SplitDockStationLayout read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        SplitDockStationLayout splitDockStationLayout = super.read(dataInputStream, placeholderStrategy);
        Version version = Version.read(dataInputStream);
        if (!version.equals(Version.VERSION_1_1_1)) {
            throw new IOException("trying to read a format from the future: " + version);
        }
        int n = dataInputStream.readInt();
        WizardSplitDockStationLayout.Column[] columnArray = new WizardSplitDockStationLayout.Column[n];
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            for (int j = 0; j < n3; ++j) {
                nArray[j] = dataInputStream.readInt();
                nArray2[j] = dataInputStream.readInt();
            }
            columnArray[i] = new WizardSplitDockStationLayout.Column(n2, nArray, nArray2);
        }
        ((WizardSplitDockStationLayout)splitDockStationLayout).setColumns(columnArray);
        return splitDockStationLayout;
    }

    @Override
    public SplitDockStationLayout read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        SplitDockStationLayout splitDockStationLayout = super.read(xElement.getElement("split"), placeholderStrategy);
        xElement = xElement.getElement("wizard");
        XElement[] xElementArray = xElement.getElements("column");
        WizardSplitDockStationLayout.Column[] columnArray = new WizardSplitDockStationLayout.Column[xElementArray.length];
        for (int i = 0; i < columnArray.length; ++i) {
            XElement xElement2 = xElementArray[i];
            int n = xElement2.getInt("size");
            XElement[] xElementArray2 = xElement2.getElements("cell");
            int[] nArray = new int[xElementArray2.length];
            int[] nArray2 = new int[xElementArray2.length];
            for (int j = 0; j < xElementArray2.length; ++j) {
                nArray[j] = xElementArray2[j].getInt("key");
                nArray2[j] = xElementArray2[j].getInt("size");
            }
            columnArray[i] = new WizardSplitDockStationLayout.Column(n, nArray, nArray2);
        }
        ((WizardSplitDockStationLayout)splitDockStationLayout).setColumns(columnArray);
        return splitDockStationLayout;
    }
}

