window.ticketIsRunning = false;

$(document).ready(function () {
	console.log("[FORM] Load modal.js"); // DEBUG
	// get the modal
	const modal = $("#modal");
	// get the modal for the screenshot
	const modalScreen = $("#modal-screenshot");
	// get the <span> element that closes the modal
	const span = $(".modal-close");
	const spanScreen = $(".modalScreen-close");

	// close the modal when the user clicks on <span> (x) + reload the page
	span.click(function () {
		document.location.reload();
	});
	spanScreen.click(function () {
		modalScreen.hide();
	});
	// close it when the user clicks anywhere outside of the modal
	$(window).click(function (e) {
		if (e.target == modal[0] && !ticketIsRunning) {
			document.location.reload();
		} else if (e.target == modalScreen[0]) {
			modalScreen.hide();
		}
	});

	window.showModal = function () {
		modal.show();
		window.ticketIsRunning = true;
	};

	window.closeModal = function () {
		modal.hide();
		window.ticketIsRunning = false;
	};

	// NB : functions for modal-screen are in file.js
});
