__constant int nbVertices = 4;
__constant float3 polygonPerfect[4] = 
{
(float3)(-1.0f, -1.0f, 0.0f), 
(float3)( 1.0f, -1.0f, 0.0f), 
(float3)( 1.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  1.0f, 0.0f)
};
__constant float3 aretesNormaliseesPerfect[4] = 
{
(float3)( 1.0f,  0.0f, 0.0f), 
(float3)( 0.0f,  1.0f, 0.0f), 
(float3)(-1.0f,  0.0f, 0.0f), 
(float3)( 0.0f, -1.0f, 0.0f)
};
__constant float longueursAretesPerfect[4] = 
{
2.0f, 
2.0f, 
2.0f, 
2.0f
};
__constant float3 O = (float3)(0.0f, 0.0f, 0.0f);
__constant float3 U = (float3)(0.0f, -1.0f, 0.0f);
__constant float3 V = (float3)(1.0f, 0.0f, 0.0f);
__constant float3 N = (float3)(0.0f, 0.0f, 1.0f);
__constant float2 BBmin = (float2)(-1.0f, -1.0f);
__constant float2 BBmax = (float2)( 1.0f,  1.0f);

__constant float height = 1.0f;


__constant float epsilon = 0.0001f;
__constant float tolerance = 0.0001f;


kernel void belongsToVolume(__global const float4* listPoints, __global float* results, const int numPoints) 
{
	// get index into global data array
	int iGID = get_global_id(0);
	// bound check (equivalent to the limit on a 'for' loop for standard/serial C code
	if (iGID >= numPoints)  
	{
		return;
	}
	//float3 lePoint = listPoints[iGID].xyz;
	float3 lePoint = listPoints[iGID].xyz;
	
	float3 areteNormalisee;
	float3 P1;
	float longueurArete;
	
	float uMin = BBmin.x;
	float vMin = BBmin.y;
	float uMax = BBmax.x;
	float vMax = BBmax.y;

	float3 OP = lePoint-O;

	float scalU = dot(OP, U);
	float scalV = dot(OP, V);
	float scalN = dot(OP, N);
	
	results[4*iGID] = lePoint.x;
	results[4*iGID+1] = lePoint.y;
	results[4*iGID+2] = lePoint.z;
	
	if ((scalU<uMin)||(scalU>uMax)||(scalV<vMin)||(scalV>vMax)||(scalN<0)||(scalN>height))
	{
		results[4*iGID+3] = 0;
		return;
    }
    
 	float3 lePointProj = (float3)(O.x + scalU*U.x + scalV*V.x, O.y + scalU*U.y + scalV*V.y, O.z + scalU*U.z + scalV*V.z);
 
	int nbIntersections = 0;
	for (int i=0; i<nbVertices; i++)
	{
		//-----------------------------------------------------------
		//CALCUL POUR UNE ARETE
		//-----------------------------------------------------------
		areteNormalisee = aretesNormaliseesPerfect[i];
		longueurArete = longueursAretesPerfect[i];
		P1 = polygonPerfect[i];
		
		if (longueurArete>epsilon)
		{
			//-----------------------------------------------------------
			//TEST D'INTERSECTION AVEC UN SEGMENT
			//-----------------------------------------------------------
			float scal = dot(U, areteNormalisee);
			if (fabs(fabs(scal)-1)<epsilon)
			{
			}
			else
			{
				//Cas général
				float3 crossProd = cross(U, areteNormalisee);
				float norm = length(crossProd);
				crossProd /= norm;
				float3 w = cross(U, crossProd);
				float3 PP1 = P1 - lePointProj;
				float dist = dot(PP1, crossProd);					
				
				if (fabs(dist)<tolerance)
				{
					float dotWithW = dot(areteNormalisee, w);											
					float lambda = -(PP1.x*w.x+PP1.y*w.y+PP1.z*w.z)/dotWithW;					
					if ((lambda>=0.0)&&(lambda<=longueurArete)) 
					{
						float dotWithU = dot(areteNormalisee, U);
						float mu = (PP1.x*U.x+PP1.y*U.y+PP1.z*U.z) + lambda*dotWithU;					
						if (mu>=0.0)
						{
							nbIntersections = nbIntersections+1;
						}						
					}
				}
			}
		}
	}
	//-----------------------------------------------------------
	//LE POINT APPARTIENT AU POLYGONE SI LE NOMBRE D'INTERSECTIONS EST IMPAIR
	//-----------------------------------------------------------
	//results[iGID] = listPoints[iGID].x;
	
	if (nbIntersections%2 != 0)
	{
		results[4*iGID+3] = 1;
	
		//results[iGID] = 1;
	}
	else
	{
		results[4*iGID+3] = 0;
	
		//results[iGID] = 0;
	}
	
	//results[iGID] = (int)((nbIntersections % 2!=0));

    
    }
}
