/*
 * Decompiled with CFR 0.152.
 */
package cadex.ModelData;

import cadex.CadExMTKJNI;
import cadex.Geom.Point;
import cadex.Geom.Transformation;

public class Box {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public Box(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(Box obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(Box obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_cadex_ModelData_Box(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Box() {
        this(CadExMTKJNI.new_cadex_ModelData_Box__SWIG_0(), true);
    }

    public Box(Point theCorner1, Point theCorner2) {
        this(CadExMTKJNI.new_cadex_ModelData_Box__SWIG_1(Point.getCPtr(theCorner1), theCorner1, Point.getCPtr(theCorner2), theCorner2), true);
    }

    public Point MinCorner() {
        long cPtr = CadExMTKJNI.cadex_ModelData_Box_MinCorner(this.swigCPtr, this);
        return new Point(cPtr, true);
    }

    public Point MaxCorner() {
        long cPtr = CadExMTKJNI.cadex_ModelData_Box_MaxCorner(this.swigCPtr, this);
        return new Point(cPtr, true);
    }

    public Point Corner(long theIdx) {
        long cPtr = CadExMTKJNI.cadex_ModelData_Box_Corner(this.swigCPtr, this, theIdx);
        return new Point(cPtr, true);
    }

    public Point Center() {
        return new Point(CadExMTKJNI.cadex_ModelData_Box_Center(this.swigCPtr, this), true);
    }

    public void Add(Point thePoint) {
        CadExMTKJNI.cadex_ModelData_Box_Add__SWIG_0(this.swigCPtr, this, Point.getCPtr(thePoint), thePoint);
    }

    public void Add(Box theBox) {
        CadExMTKJNI.cadex_ModelData_Box_Add__SWIG_1(this.swigCPtr, this, Box.getCPtr(theBox), theBox);
    }

    public void Clear() {
        CadExMTKJNI.cadex_ModelData_Box_Clear(this.swigCPtr, this);
    }

    public void SetXRange(double theMin, double theMax) {
        CadExMTKJNI.cadex_ModelData_Box_SetXRange(this.swigCPtr, this, theMin, theMax);
    }

    public void SetYRange(double theMin, double theMax) {
        CadExMTKJNI.cadex_ModelData_Box_SetYRange(this.swigCPtr, this, theMin, theMax);
    }

    public void SetZRange(double theMin, double theMax) {
        CadExMTKJNI.cadex_ModelData_Box_SetZRange(this.swigCPtr, this, theMin, theMax);
    }

    public void SetRange(long theIdx, double theMin, double theMax) {
        CadExMTKJNI.cadex_ModelData_Box_SetRange(this.swigCPtr, this, theIdx, theMin, theMax);
    }

    public double XRange() {
        return CadExMTKJNI.cadex_ModelData_Box_XRange(this.swigCPtr, this);
    }

    public double YRange() {
        return CadExMTKJNI.cadex_ModelData_Box_YRange(this.swigCPtr, this);
    }

    public double ZRange() {
        return CadExMTKJNI.cadex_ModelData_Box_ZRange(this.swigCPtr, this);
    }

    public double Range(long theIndex) {
        return CadExMTKJNI.cadex_ModelData_Box_Range(this.swigCPtr, this, theIndex);
    }

    public void Enlarge(double theX, double theY, double theZ) {
        CadExMTKJNI.cadex_ModelData_Box_Enlarge__SWIG_0(this.swigCPtr, this, theX, theY, theZ);
    }

    public void Enlarge(double theSize) {
        CadExMTKJNI.cadex_ModelData_Box_Enlarge__SWIG_1(this.swigCPtr, this, theSize);
    }

    public Box Enlarged(double theX, double theY, double theZ) {
        return new Box(CadExMTKJNI.cadex_ModelData_Box_Enlarged__SWIG_0(this.swigCPtr, this, theX, theY, theZ), true);
    }

    public Box Enlarged(double theSize) {
        return new Box(CadExMTKJNI.cadex_ModelData_Box_Enlarged__SWIG_1(this.swigCPtr, this, theSize), true);
    }

    public boolean IsIn(Point thePoint) {
        return CadExMTKJNI.cadex_ModelData_Box_IsIn(this.swigCPtr, this, Point.getCPtr(thePoint), thePoint);
    }

    public boolean Intersects(Box theOther) {
        return CadExMTKJNI.cadex_ModelData_Box_Intersects(this.swigCPtr, this, Box.getCPtr(theOther), theOther);
    }

    public boolean IsInfinite() {
        return CadExMTKJNI.cadex_ModelData_Box_IsInfinite(this.swigCPtr, this);
    }

    public void Multiply(double theValue) {
        CadExMTKJNI.cadex_ModelData_Box_Multiply(this.swigCPtr, this, theValue);
    }

    public Box Multiplied(double theValue) {
        return new Box(CadExMTKJNI.cadex_ModelData_Box_Multiplied(this.swigCPtr, this, theValue), true);
    }

    public void Transform(Transformation theTransformation) {
        CadExMTKJNI.cadex_ModelData_Box_Transform(this.swigCPtr, this, Transformation.getCPtr(theTransformation), theTransformation);
    }

    public Box Transformed(Transformation theTransformation) {
        return new Box(CadExMTKJNI.cadex_ModelData_Box_Transformed(this.swigCPtr, this, Transformation.getCPtr(theTransformation), theTransformation), true);
    }
}

