/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ListDockableStationPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarDockPerspective
extends ListDockableStationPerspective {
    private ExpandedState state = ExpandedState.SHRUNK;

    public ToolbarDockPerspective() {
        this.setDockables(new PerspectivePlaceholderList<PerspectiveDockable>());
    }

    public ToolbarDockPerspective(ToolbarDockStationLayout toolbarDockStationLayout, Map<Integer, PerspectiveDockable> map) {
        this.read(toolbarDockStationLayout, map);
    }

    public void read(ToolbarDockStationLayout toolbarDockStationLayout, final Map<Integer, PerspectiveDockable> map) {
        PerspectivePlaceholderList<PerspectiveDockable> perspectivePlaceholderList = new PerspectivePlaceholderList<PerspectiveDockable>();
        this.setExpandedState(toolbarDockStationLayout.getState());
        perspectivePlaceholderList.read(toolbarDockStationLayout.getPlaceholders(), new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public PerspectiveDockable convert(ConvertedPlaceholderListItem convertedPlaceholderListItem) {
                if (map == null) {
                    return null;
                }
                int n = convertedPlaceholderListItem.getInt("id");
                PerspectiveDockable perspectiveDockable = (PerspectiveDockable)map.get(n);
                perspectiveDockable.setParent(ToolbarDockPerspective.this);
                return perspectiveDockable;
            }
        });
        this.setDockables(perspectivePlaceholderList);
    }

    public PlaceholderMap getPlaceholders(final Map<PerspectiveDockable, Integer> map) {
        return this.getDockables().toMap(new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            @Override
            public ConvertedPlaceholderListItem convert(int n, PerspectiveDockable perspectiveDockable) {
                Integer n2 = (Integer)map.get(perspectiveDockable);
                if (n2 == null) {
                    return null;
                }
                ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
                convertedPlaceholderListItem.putInt("id", n2);
                convertedPlaceholderListItem.putInt("index", n);
                Path path = perspectiveDockable.getPlaceholder();
                if (path != null) {
                    convertedPlaceholderListItem.putString("placeholder", path.toString());
                    convertedPlaceholderListItem.setPlaceholder(path);
                }
                return convertedPlaceholderListItem;
            }
        });
    }

    @Override
    public String getFactoryID() {
        return "ToolbarDockStationFactory";
    }

    public void setExpandedState(ExpandedState expandedState) {
        if (expandedState == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        this.state = expandedState;
    }

    public ExpandedState getExpandedState() {
        return this.state;
    }

    @Override
    protected DockableProperty getDockableProperty(int n, Path path, PerspectiveDockable perspectiveDockable, PerspectiveDockable perspectiveDockable2) {
        return new ToolbarProperty(n, path);
    }
}

