/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.displayer.DisplayerCombinerTarget;
import bibliothek.gui.dock.dockable.DefaultDockablePerspective;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.location.AsideRequest;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.station.support.CombinerSource;
import bibliothek.gui.dock.station.support.CombinerTarget;
import bibliothek.gui.dock.station.support.Enforcement;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class BasicCombiner
implements Combiner {
    public CombinerTarget prepare(final CombinerSource source, Enforcement force) {
        DisplayerCombinerTarget operation;
        DockableDisplayer displayer = source.getOldDisplayer();
        if (displayer != null && (operation = displayer.prepareCombination(source, force)) != null) {
            return new DisplayerTarget(operation);
        }
        if (force.getForce() < 0.5f) {
            return null;
        }
        return new CombinerTarget(){

            public void paint(Graphics g, Component component, StationPaint paint, Rectangle stationBounds, Rectangle dockableBounds) {
                paint.drawInsertion(g, source.getParent(), stationBounds, dockableBounds);
            }

            public DisplayerCombinerTarget getDisplayerCombination() {
                return null;
            }
        };
    }

    public Dockable combine(CombinerSource source, CombinerTarget target) {
        if (target instanceof DisplayerTarget) {
            return ((DisplayerTarget)target).execute(source);
        }
        DockStation parent = source.getParent();
        PlaceholderMap placeholders = source.getPlaceholders();
        StackDockStation stack = new StackDockStation(parent.getTheme());
        stack.setController(parent.getController());
        if (placeholders != null) {
            stack.setPlaceholders(placeholders);
        }
        stack.drop(source.getOld());
        stack.drop(source.getNew());
        return stack;
    }

    public void aside(AsideRequest request) {
        int index;
        PlaceholderMap placeholders = request.getLayout();
        StackDockPerspective stack = new StackDockPerspective();
        if (placeholders != null && stack.canRead(placeholders)) {
            stack.setPlaceholders(placeholders);
        }
        if (stack.getItemCount() == 0) {
            this.insert(stack, request.getLocation());
        }
        if ((index = this.indexOf(stack, request.getLocation())) == -1) {
            index = stack.getDockableCount();
            if (index == 0) {
                index = 1;
            }
        } else {
            ++index;
        }
        index = Math.min(stack.getItemCount(), index);
        if (request.getPlaceholder() != null) {
            stack.insertPlaceholder(index, request.getPlaceholder(), PlaceholderList.Level.BASE);
        }
        request.answer(new StackDockProperty(index, request.getPlaceholder()), stack.getPlaceholders());
    }

    private void insert(StackDockPerspective stack, DockableProperty location) {
        Path placeholder = location instanceof StackDockProperty ? ((StackDockProperty)location).getPlaceholder() : null;
        if (placeholder == null) {
            stack.add(new DefaultDockablePerspective());
        } else {
            stack.addPlaceholder(placeholder);
        }
    }

    private int indexOf(StackDockPerspective stack, DockableProperty location) {
        if (location instanceof StackDockProperty) {
            StackDockProperty property = (StackDockProperty)location;
            int index = stack.indexOf(property.getPlaceholder());
            if (index != -1) {
                return index;
            }
            return property.getIndex();
        }
        return -1;
    }

    private class DisplayerTarget
    implements CombinerTarget {
        private DisplayerCombinerTarget operation;

        public DisplayerTarget(DisplayerCombinerTarget operation) {
            this.operation = operation;
        }

        public Dockable execute(CombinerSource source) {
            return this.operation.execute(source);
        }

        public void paint(Graphics g, Component component, StationPaint paint, Rectangle stationBounds, Rectangle dockableBounds) {
            this.operation.paint(g, component, paint, stationBounds, dockableBounds);
        }

        public DisplayerCombinerTarget getDisplayerCombination() {
            return this.operation;
        }
    }
}

