// To make Object.entries() support older environments
if (!Object.entries) {
	// from : https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/entries#polyfill
	Object.entries = (obj) => {
		let ownProps = Object.keys(obj),
			i = ownProps.length,
			resArray = new Array(i); // preallocate the Array
		while (i--) resArray[i] = [ownProps[i], obj[ownProps[i]]];

		return resArray;
	};
}

const jsConnector = {
	/**
	 * load "value" in the field which has for id "name"
	 * @param {*} name field id
	 * @param {*} value field value
	 */
	loadPrefilledField: function(name, value) {
	    // Décomposer la clé en deux parties : id et updateType (optionnel)
	    const parts = name.split('.');
	    const id = parts[0];
	    const updateType = parts[1] ? parts[1].toLowerCase() : '';
		
		// Cas particulier pour remplir les options d'un select
	    if (updateType === 'options') {
	        // Supposons que "value" est un JSON représentant un tableau d'options
	        // Vous pouvez adapter selon le format attendu (objet ou chaîne JSON)
	        try {
	            const options = typeof value === "string" ? JSON.parse(value) : value;
	            fillSelectOptions(id, options);
	        } catch (e) {
	            console.error("Erreur lors du parsing des options pour le select " + id, e);
	        }
	        return;
	    }

	    // Sélectionner l'élément par son id
	    const field = $(`#${id}`);
	    if (!field.length) {
	        console.log(`No field with id ${id} found to fill`);
	        return;
	    }

	    // Si on doit mettre à jour le placeholder
	    if (updateType === 'placeholder' && field.is('input')) {
	        field.attr('placeholder', value);
	        console.log(`${id} placeholder updated to: ${value}`);
	        return;
	    }

	    // Par défaut : 
	    // - Pour les éléments de formulaire, mettre à jour la valeur
	    // - Sinon, mettre à jour le texte de l'élément
	    if (field.is('input, textarea, select')) {
	        field.val(value);
	        console.log(`${id} field has been filled with: ${value}`);
	    } else {
	        field.text(value);
	        console.log(`${id} element updated to: ${value}`);
	    }
	},
	
	/**
	 * load "options" in the select field which has for id the given selectId
	 * @param {*} selectId field id
	 * @param {*} options field value
	 * @param {*} defaultValue default field value
	 */
	fillSelectOptionsWithIndex : function(selectId, options, defaultValue) {
		const select = $(`#${selectId}`);
	    if (!select.length) {
	        console.log(`No select found with id ${selectId}`);
	        return;
	    }
	    
	    // Vider le select
	    select.empty();
	    
	    // Ajouter chaque option
	    options.forEach((option, index) => {
	        const opt = $("<option>").val(index + 1).text(option);
	        select.append(opt);
	    });
	    
	    // Sélectionner l'option par défaut si une valeur est fournie
	    if (defaultValue !== undefined) {
	        select.val(defaultValue);
	    }
	    
	    console.log(`Le select ${selectId} a été rempli avec ${options.length} options.`);
	}
};

function getJsConnector() {
	return jsConnector;
}
