/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.util.ArrayList;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.java3d.utils.universe.ConfigView;
import org.jogamp.java3d.utils.universe.ConfigViewPlatformBehavior;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.Matrix4d;

class ConfigViewPlatform
extends ConfigObject {
    private boolean allowPolicyRead = false;
    private boolean allowLocalToVworldRead = false;
    private boolean nominalViewingTransform = false;
    private Transform3D initialViewingTransform = null;
    private ArrayList configViews = new ArrayList();
    private Viewer[] viewers = null;
    ViewingPlatform viewingPlatform = null;
    int viewAttachPolicy = -1;
    ConfigViewPlatformBehavior configBehavior = null;

    ConfigViewPlatform() {
    }

    @Override
    protected void initialize(ConfigCommand command) {
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        int argc = command.argc;
        Object[] argv = command.argv;
        if (argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be a property name");
        }
        String attribute = (String)argv[2];
        Object value = argv[3];
        if (attribute.equals("NominalViewingTransform")) {
            if (!(value instanceof Boolean)) {
                this.syntaxError("NominalViewingTransform must be a boolean");
            }
            this.nominalViewingTransform = (Boolean)value;
        } else if (attribute.equals("InitialViewingTransform")) {
            if (!(value instanceof Matrix4d)) {
                this.syntaxError("InitialViewingTransform must be a Matrix4d");
            }
            this.initialViewingTransform = new Transform3D((Matrix4d)value);
        } else if (attribute.equals("ViewAttachPolicy")) {
            String svalue;
            if (!(value instanceof String)) {
                this.syntaxError("ViewAttachPolicy must be a string");
            }
            if ((svalue = (String)value).equals("NOMINAL_HEAD")) {
                this.viewAttachPolicy = 0;
            } else if (svalue.equals("NOMINAL_SCREEN")) {
                this.viewAttachPolicy = 2;
            } else if (svalue.equals("NOMINAL_FEET")) {
                this.viewAttachPolicy = 1;
            } else {
                this.syntaxError("Illegal value " + svalue + " for ViewAttachPolicy");
            }
        } else if (attribute.equals("ViewPlatformBehavior")) {
            if (!(value instanceof String)) {
                this.syntaxError("ViewPlatformBehavior must be a name");
            }
            this.configBehavior = (ConfigViewPlatformBehavior)this.configContainer.findConfigObject("ViewPlatformBehavior", (String)value);
        } else if (attribute.equals("AllowPolicyRead")) {
            if (!(value instanceof Boolean)) {
                this.syntaxError("value for AllowPolicyRead must be a boolean");
            }
            this.allowPolicyRead = (Boolean)value;
        } else if (attribute.equals("AllowLocalToVworldRead")) {
            if (!(value instanceof Boolean)) {
                this.syntaxError("value for AllowLocalToVworldRead must be a boolean");
            }
            this.allowLocalToVworldRead = (Boolean)value;
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + attribute + "\"");
        }
    }

    void addConfigView(ConfigView cv) {
        this.configViews.add(cv);
    }

    ViewingPlatform createViewingPlatform(int transformCount) {
        if (this.configViews.size() == 0) {
            this.viewers = new Viewer[0];
        } else {
            this.viewers = new Viewer[this.configViews.size()];
            int i = 0;
            while (i < this.viewers.length) {
                this.viewers[i] = ((ConfigView)this.configViews.get((int)i)).j3dViewer;
                ++i;
            }
        }
        this.viewingPlatform = new ViewingPlatform(transformCount);
        ViewPlatform vp = this.viewingPlatform.getViewPlatform();
        if (this.allowPolicyRead) {
            vp.setCapability(12);
        }
        if (this.allowLocalToVworldRead) {
            vp.setCapability(11);
        }
        if (this.viewAttachPolicy == -1) {
            boolean nominalHead = true;
            int i = 0;
            while (i < this.viewers.length) {
                if (this.viewers[i].getView().getWindowEyepointPolicy() != 2) {
                    nominalHead = false;
                    break;
                }
                ++i;
            }
            if (nominalHead) {
                vp.setViewAttachPolicy(0);
            } else {
                vp.setViewAttachPolicy(2);
            }
        } else {
            vp.setViewAttachPolicy(this.viewAttachPolicy);
        }
        int i = 0;
        while (i < this.viewers.length) {
            this.viewers[i].setViewingPlatform(this.viewingPlatform);
            ++i;
        }
        if (this.nominalViewingTransform) {
            this.viewingPlatform.setNominalViewingTransform();
        }
        if (this.initialViewingTransform != null) {
            TransformGroup tg = this.viewingPlatform.getViewPlatformTransform();
            tg.setTransform(this.initialViewingTransform);
        }
        return this.viewingPlatform;
    }

    void processBehavior() {
        if (this.configBehavior != null) {
            this.viewingPlatform.setViewPlatformBehavior(this.configBehavior.viewPlatformBehavior);
        }
    }
}

