/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.Geom.Vector;
import java.util.AbstractList;
import java.util.RandomAccess;

public class VectorList
extends AbstractList<Vector>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public VectorList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(VectorList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(VectorList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_VectorList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorList(Vector[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Vector element : initialElements) {
            this.add(element);
        }
    }

    public VectorList(Iterable<Vector> initialElements) {
        this();
        for (Vector element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Vector get(int index) {
        return this.doGet(index);
    }

    @Override
    public Vector set(int index, Vector e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Vector e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Vector e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Vector remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorList() {
        this(CadExMTKJNI.new_std_VectorList__SWIG_0(), true);
    }

    public VectorList(VectorList other) {
        this(CadExMTKJNI.new_std_VectorList__SWIG_1(VectorList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_VectorList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_VectorList_clear(this.swigCPtr, this);
    }

    public VectorList(int count, Vector value) {
        this(CadExMTKJNI.new_std_VectorList__SWIG_2(count, Vector.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_VectorList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_VectorList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_VectorList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Vector x) {
        CadExMTKJNI.std_VectorList_doAdd__SWIG_0(this.swigCPtr, this, Vector.getCPtr(x), x);
    }

    private void doAdd(int index, Vector x) {
        CadExMTKJNI.std_VectorList_doAdd__SWIG_1(this.swigCPtr, this, index, Vector.getCPtr(x), x);
    }

    private Vector doRemove(int index) {
        return new Vector(CadExMTKJNI.std_VectorList_doRemove(this.swigCPtr, this, index), true);
    }

    private Vector doGet(int index) {
        long cPtr = CadExMTKJNI.std_VectorList_doGet(this.swigCPtr, this, index);
        return new Vector(cPtr, true);
    }

    private Vector doSet(int index, Vector val) {
        return new Vector(CadExMTKJNI.std_VectorList_doSet(this.swigCPtr, this, index, Vector.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_VectorList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

