/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.ModelData.Wire;
import java.util.AbstractList;
import java.util.RandomAccess;

public class WireList
extends AbstractList<Wire>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public WireList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(WireList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(WireList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_WireList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public WireList(Wire[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Wire element : initialElements) {
            this.add(element);
        }
    }

    public WireList(Iterable<Wire> initialElements) {
        this();
        for (Wire element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Wire get(int index) {
        return this.doGet(index);
    }

    @Override
    public Wire set(int index, Wire e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Wire e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Wire e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Wire remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public WireList() {
        this(CadExMTKJNI.new_std_WireList__SWIG_0(), true);
    }

    public WireList(WireList other) {
        this(CadExMTKJNI.new_std_WireList__SWIG_1(WireList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_WireList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_WireList_clear(this.swigCPtr, this);
    }

    public WireList(int count, Wire value) {
        this(CadExMTKJNI.new_std_WireList__SWIG_2(count, Wire.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_WireList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_WireList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_WireList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Wire x) {
        CadExMTKJNI.std_WireList_doAdd__SWIG_0(this.swigCPtr, this, Wire.getCPtr(x), x);
    }

    private void doAdd(int index, Wire x) {
        CadExMTKJNI.std_WireList_doAdd__SWIG_1(this.swigCPtr, this, index, Wire.getCPtr(x), x);
    }

    private Wire doRemove(int index) {
        return new Wire(CadExMTKJNI.std_WireList_doRemove(this.swigCPtr, this, index), true);
    }

    private Wire doGet(int index) {
        return new Wire(CadExMTKJNI.std_WireList_doGet(this.swigCPtr, this, index), false);
    }

    private Wire doSet(int index, Wire val) {
        return new Wire(CadExMTKJNI.std_WireList_doSet(this.swigCPtr, this, index, Wire.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_WireList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

