#version 130

uniform float u_fAmplitude;
uniform float u_hasGpuFlags;//should be boolean
uniform float u_hasNormals;//should be boolean
uniform float u_hasSegmentation;//should be boolean

flat in vec4 v4Color;
flat in vec4 actual_color;
flat in float flag;
flat in int normalPacked;//passed in as float... magic!
flat in float doDisc;

uniform vec4 overrideColor;
uniform float doOverrideColor;
uniform float u_doCircles;

flat in float near;
flat in float far;
flat in float pointSize;
flat in float z;
flat in float circleMax;

out vec4 out_color;

float nearInv = 1 / near;
float farInv = 1 / far;
float dst = far - near;

float zDepthFromDistance(float value){
	return ( (1 / value) - nearInv ) / (farInv - nearInv);
}

void main(void) {

	if(doDisc > 0.5)
		discard; 
	//out_color = vec4(0.0,0.0,1.0,1.0);
	//gl_PointSize = 1.0f;//en fonction de la distance à eye
	if (u_hasGpuFlags > 0.5 && flag != 0.0) {
		out_color = mix(actual_color, v4Color, u_fAmplitude); //v4Color
	}
	else{
		out_color = actual_color;
	}
	float override = step(0.5, doOverrideColor);
	out_color = mix(out_color, overrideColor, override);

	vec2 coord = 2.0 * gl_PointCoord.xy - 1.0;

	float l = dot(coord, coord);
	if (l > circleMax && u_doCircles > 0.5)
		discard;
	//vec3 pos = vec3(coord, sqrt(1.0-l*l));

	// float depthBias = l * 0.5;//clamp( l, 0.0, 1.0);
	// out_color = vec4(abs(coord.xy), length(out_color) * 0.25, 1.0);
	//out_color = vec4(vec2(z/5.0), abs(gl_FragDepth - zDepthFromDistance(z)), 1.0);
	// gl_FragDepth = gl_FragCoord.z + zDepthFromDistance(z + depthBias * 0.005) - zDepthFromDistance(z);
	if (flag > 0.0){
		gl_FragDepth = gl_FragCoord.z*0.9999; //Show a little closer
	} else {
		gl_FragDepth = gl_FragCoord.z;
	}

	//float blue = 1-out_color.b;
	//out_color.b = 1.0 - blue * blue;

	//float red = 1.5-out_color.r;
	//out_color.r = 1.0 - red * red;
}