#ifndef __OPENCL_VERSION__ //This should fail during an actual openCL compile, used only to trick Eclipse into syntax highlighting this file as "C" code.
#define __kernel
#define __global
#define kernel
#define global
#define constant
#define local
#define float2 float
#define int3 int
#define float3 float
#define float4 float
#define uchar4 char
#endif

//Given a normal vector n, generate generic UV axes.
void getGenericPlaneAxis(float* m_data, bool bForceNormalization)
{
	float tinyAngle = 10.*M_PI/180;
	float cosTinyAngle = cos(tinyAngle);
	float sinTinyAngle = sqrt(1.-cosTinyAngle*cosTinyAngle);

	float norm;
			
	//Getting axis N (making sure it is normalized)
	float3 n = (float3)(m_data[6], m_data[7], m_data[8]);
	if (bForceNormalization)
	{
		norm = length(n);
		n.x /= norm;
		n.y /= norm;
		n.z /= norm;
		m_data[6] = n.x; 
		m_data[7] = n.y; 	
		m_data[8] = n.z;
	}
	//-------------------------------------------------------------------
	//Calcul des vecteurs unitaires du plan
	//-------------------------------------------------------------------
	float scaltmp[3] = { fabs(n.x), fabs(n.y), fabs(n.z) };
	float3 axisVapprox = (float3)(0,0,0);

	if (scaltmp[0] > cosTinyAngle)
	{
		//La normale est presque suivant l'axe des X
		//On va privilégier V suivant l'axe des Y positifs
		axisVapprox.y = 1;
	}
	else if (scaltmp[1] > cosTinyAngle)
	{
		//La normale est presque suivant l'axe des Y
		//On va privilégier V suivant l'axe des Z positifs
		axisVapprox.z = 1;
	}
	else if (scaltmp[2] > cosTinyAngle)
	{
		//La normale est presque suivant l'axe des Z
		//On va privilégier V suivant l'axe des Y positifs
		axisVapprox.y = 1;
	}
	else
	{
		int ind = -1;
		float scalmin = infinity;
		for (int i=0; i<3; i++)
		{
			if (scaltmp[i]<scalmin)
			{
				scalmin = scaltmp[i];
				ind = i;
			}
		}
		if (ind==0)			axisVapprox.x = 1;
		else if (ind==1)	axisVapprox.y = 1;
		else				axisVapprox.z = 1;
	}
	
	float3 u = cross(axisVapprox, n);
	norm = length(u);
	u.x /= norm;
	u.y /= norm;
	u.z /= norm;
	
	float3 v = cross(n, u);
	
	m_data[0] = u.x; 
	m_data[1] = u.y; 	
	m_data[2] = u.z;
	m_data[3] = v.x; 
	m_data[4] = v.y; 	
	m_data[5] = v.z;
}
bool setVerticalAxis(float3 n, float* m_data, bool bForceNormalization)
{
	float tinyAngle = 10.*M_PI/180;
	float cosTinyAngle = cos(tinyAngle);
	float sinTinyAngle = sqrt(1.-cosTinyAngle*cosTinyAngle);

	m_data[6] = n.x;
	m_data[7] = n.y;
	m_data[8] = n.z;
	
	float norm;
			
	if (bForceNormalization)
	{
		//Getting axis N (making sure it is normalized)
		float3 n = (float3)(m_data[6], m_data[7], m_data[8]);
		norm = length(n);
		if (norm < mathEpsilon)
			return false;
		m_data[6] /= norm;
		m_data[7] /= norm;
		m_data[8] /= norm;
	}
	// Generate generic plane axes
	getGenericPlaneAxis(m_data, false);
	return true;	
}
void setOrigin(float3 origin, float* m_data)
{
	m_data[9] = origin.x;
	m_data[10] = origin.y;
	m_data[11] = origin.z;
}

float getLocalX(const float3 coord, const float* m_data)
{ 
	return (coord.x-m_data[9])*m_data[0]+(coord.y-m_data[10])*m_data[1]+(coord.z-m_data[11])*m_data[2];
}
float getLocalY(const float3 coord, const float* m_data)
{ 
	return (coord.x-m_data[9])*m_data[3]+(coord.y-m_data[10])*m_data[4]+(coord.z-m_data[11])*m_data[5]; 
}
float getLocalZ(const float3 coord, const float* m_data)
{ 
	return (coord.x-m_data[9])*m_data[6]+(coord.y-m_data[10])*m_data[7]+(coord.z-m_data[11])*m_data[8]; 
}
float getLocalX_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[0]+vec.y*m_data[1]+vec.z*m_data[2];
}
float getLocalY_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[3]+vec.y*m_data[4]+vec.z*m_data[5];
}
float getLocalZ_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[6]+vec.y*m_data[7]+vec.z*m_data[8]; 
}
float getGlobalX(const float3 coord, const float* m_data)
{ 
	return m_data[9] + coord.x*m_data[0] + coord.y*m_data[3] + coord.z*m_data[6]; 
}
float getGlobalY(const float3 coord, const float* m_data)
{ 
	return m_data[10] + coord.x*m_data[1] + coord.y*m_data[4] + coord.z*m_data[7];
}
float getGlobalZ(const float3 coord, const float* m_data)
{ 
	return m_data[11] + coord.x*m_data[2] + coord.y*m_data[5] + coord.z*m_data[8]; 
}
float getGlobalX_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[0] + vec.y*m_data[3] + vec.z*m_data[6]; 
}
float getGlobalY_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[1] + vec.y*m_data[4] + vec.z*m_data[7]; 
}
float getGlobalZ_Vector(const float3 vec, const float* m_data)
{ 
	return vec.x*m_data[2] + vec.y*m_data[5] + vec.z*m_data[8]; 
}

float3 getAxisX(const float* m_data)
{
	return (float3)(m_data[0], m_data[1], m_data[2]);
}
float3 getAxisY(const float* m_data)
{
	return (float3)(m_data[3], m_data[4], m_data[5]);
}
float3 getAxisZ(const float* m_data)
{
	return (float3)(m_data[6], m_data[7], m_data[8]);
}
float3 getOrigin(const float* m_data)
{
	return (float3)(m_data[9], m_data[10], m_data[11]);
}