#version 130
// simple fragment shader
uniform sampler2D panoTex;
uniform sampler2D depthTex;

uniform float zRatio; //1 is z-only, 0, color only
uniform float zMult; //so that we see the zs better
uniform int zType;//0 is depthbuffer, 1 is linear depth and 2 is calculated z
uniform int redRangeMin;
uniform int redRangeMax;
//uniform float panoRadius;

uniform float doDepth;

uniform ivec2 frameSize;
uniform float fov;

uniform float nearClip;
uniform float farClip;



//returns linear values of depth between 0 and 1
float linearDepthFromDistanceMilli(float value, float max){
	return value / max;
}
//returns linear values of depth between 0 and 1
float linearDepthFromZSample(float value){
    float depthSample = 2.0 * value - 1.0;
    float zLinear = 2.0 * nearClip * farClip / (farClip + nearClip - depthSample * (farClip - nearClip));
    return 0.5 + .5 * zLinear;
}
//returns log values of depth between 0 and 1
float zDepthFromDistanceMilli(float value, float near, float far){

	float nearInv = 1 / near;
	float farInv = 1 / far;

	//return ( (1 / value) - nearInv );
	return ( (1 / value) - nearInv ) / (farInv - nearInv);
}
float zDepthFromDistanceMilli_TEST(float value, float near, float far){

    float a = (far+near)/(4*(far-near));
 float b = (far*near)/(2*(far-near));
 return (1+a-b/value);
}

float getTheta(vec2 pixelPosition){
	vec2 	fromCenter = vec2(pixelPosition.x - frameSize.x / 2, pixelPosition.y - frameSize.y / 2);
	float 	e = length(fromCenter);

	//return length(fromCenter) / length(vec2(frameSize));

	return atan( ( e * 2 * tan(fov / 2) ) / frameSize.x );
}

//gives d* from d via an arctangent calculation
float transformDistanceBernard(float d, vec2 pixelPosition){
	float 	THETA = getTheta(pixelPosition);

	return d * cos (THETA); 
}

//gives d* from d via an arctangent calculation
float transformDistanceBoris(float d, vec2 pixelPosition){
	float 	THETA = getTheta(pixelPosition);

	return d * cos (THETA); 
}

void main()
{
    vec2  tc0 = gl_TexCoord[0].xy;
    ivec2 size = textureSize(depthTex, 0);
    vec2  tc1 = gl_TexCoord[1].xy;
    //vec2  tc1 = vec2(tc0); //get texel coordinates

    ivec2 depthCoord = ivec2( floor((tc1) * vec2(size)));// % size;
    //depthCoord.x %= size.x;

	vec4 colorPick = texture2D(panoTex, tc0).rgba; // pick color

	vec4 depthPick = texelFetch(depthTex, depthCoord, 0).rgba; // pick depthBuff as int
	//vec4 depthPick = texture2D(depthTex, tc1, 0).rgba; // pick depthBuff
	
	int red   = int(255*depthPick.r);
	int green = int(255*depthPick.g);
	int blue  = int(255*depthPick.b);

	float depthMilli = int(red/100)*256*256 + green*256 + blue;
	//depthMilli -= 1000 * nearClip / gl_FragCoord.z;
	// Bernard's version
	//depthMilli -= nearClip * 1000.0;
	depthMilli = transformDistanceBernard(depthMilli, gl_FragCoord.xy); // distance oeil point transformée
	//depthMilli -= transformDistanceBernard(nearClip * 1000.0, gl_FragCoord.xy); // moins distance oeil / clip
	
	//Boris' Version
	//depthMilli = linearDepthFromZSample(gl_FragCoord.z) * panoRadius * 1000;
	//depthMilli *= linearDepthFromZSample(gl_FragCoord.z) * panoRadius / farClip; // c'est un ratio, on va rapprocher les valeurs du bord...

	//float near = gl_DepthRange.near; 
	//float far = gl_DepthRange.far;
	float linearDepth = linearDepthFromDistanceMilli(depthMilli, 1000.0 * farClip);
	
	float depth = zDepthFromDistanceMilli(float(depthMilli/1000), 1.0 * nearClip, 1.0 * farClip);
	//float depth = zDepthFromDistanceMilli(float(depthMilli/1000), 1.0 * 0.369805, 1.0 * farClip);
	//depth = transformDistanceBernard(depth, gl_FragCoord.xy);


	vec4 zColor = depthPick;
	if(zType == 1){
		zColor = vec4(vec3(linearDepth * clamp(zMult, 2.0, 100.0)), 1.0);
		//float theta = getTheta(gl_FragCoord.xy);
		//vec2 test = gl_FragCoord.xy / frameSize;
		//float theta = length(test);
		//theta /= 3.14159;
		//zColor = vec4(depthMilli * zMult / (1000 * panoRadius));
	}
	if(zType == 2){
		zColor = vec4(vec3(depth), 1.0);
	}
	//zColor = vec4(gl_FragCoord.xy / frameSize, 0.5, 1.0);

	vec4 finalColor = mix(colorPick, zColor, zRatio);

	//TODO : use steps !
	if(depthMilli > redRangeMin && depthMilli < redRangeMax){
		finalColor = vec4(0.9, 0.2, 0.2, 1.0);
	}
	gl_FragColor = vec4(finalColor.rgb, 1.0);

	if(depthMilli >= 10.0 && doDepth > 0.5)
		gl_FragDepth = depth;//
	else
		gl_FragDepth = 1.0;
}
