/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumn;
import bibliothek.gui.dock.station.toolbar.group.ToolbarColumnModel;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategyFactory;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class DefaultToolbarGroupDividierStrategy
implements ToolbarGroupDividerStrategy {
    public static final ToolbarGroupDividerStrategyFactory FACTORY = new ToolbarGroupDividerStrategyFactory(){

        @Override
        public ToolbarGroupDividerStrategy create(ToolbarGroupDockStation toolbarGroupDockStation) {
            return new DefaultToolbarGroupDividierStrategy(toolbarGroupDockStation);
        }
    };
    private ToolbarGroupDockStation station;

    public DefaultToolbarGroupDividierStrategy(ToolbarGroupDockStation toolbarGroupDockStation) {
        this.station = toolbarGroupDockStation;
    }

    @Override
    public int getColumn(int n) {
        return 1;
    }

    @Override
    public int getLine(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public void paint(Component component, Graphics graphics, ToolbarGridLayoutManager<StationChildHandle> toolbarGridLayoutManager) {
        graphics.setColor(component.getForeground());
        Orientation orientation = this.station.getOrientation();
        ToolbarColumnModel<Dockable, StationChildHandle> toolbarColumnModel = this.station.getColumnModel();
        int n = toolbarColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ToolbarColumn<Dockable, StationChildHandle> toolbarColumn = toolbarColumnModel.getColumn((Dockable)i);
            int n2 = toolbarColumn.getDockableCount();
            for (int j = 0; j < n2; ++j) {
                Rectangle rectangle = toolbarGridLayoutManager.getBounds(i, j);
                if (j == 0) {
                    switch (orientation) {
                        case HORIZONTAL: {
                            graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width, rectangle.height + 1);
                            break;
                        }
                        case VERTICAL: {
                            graphics.drawRect(rectangle.x - 1, rectangle.y, rectangle.width + 1, rectangle.height);
                        }
                    }
                    continue;
                }
                graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
            }
        }
    }
}

