/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.awt.AWTGraphicsConfiguration;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.awt.JAWTWindow;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.newt.Debug;

public class NewtFactoryAWT
extends NewtFactory {
    public static final boolean DEBUG_IMPLEMENTATION = Debug.debug("Window");

    public static JAWTWindow getNativeWindow(Component component, AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        NativeWindow nativeWindow = NativeWindowFactory.getNativeWindow(component, aWTGraphicsConfiguration);
        if (!(nativeWindow instanceof JAWTWindow)) {
            throw new NativeWindowException("Not an AWT NativeWindow: " + nativeWindow);
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("NewtFactoryAWT.getNativeWindow: " + component + " -> " + nativeWindow);
        }
        return (JAWTWindow)nativeWindow;
    }

    public static void destroyNativeWindow(JAWTWindow jAWTWindow) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = jAWTWindow.getGraphicsConfiguration();
        jAWTWindow.destroy();
        abstractGraphicsConfiguration.getScreen().getDevice().close();
    }

    private static GraphicsConfiguration checkComponentValid(Component component) throws IllegalArgumentException {
        if (!component.isDisplayable()) {
            throw new IllegalArgumentException("Given AWT-Component is not displayable: " + component);
        }
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (null == graphicsConfiguration) {
            throw new IllegalArgumentException("Given AWT-Component has no GraphicsConfiguration set: " + component);
        }
        return graphicsConfiguration;
    }

    public static Display createDisplay(Component component, boolean bl) throws IllegalArgumentException {
        long l;
        GraphicsConfiguration graphicsConfiguration = NewtFactoryAWT.checkComponentValid(component);
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        String string = NativeWindowFactory.getNativeWindowType(true);
        String string2 = ".x11" == string ? (0L == (l = X11SunJDKReflection.graphicsDeviceGetDisplay(graphicsDevice)) ? null : X11Lib.XDisplayString(l)) : null;
        return NewtFactory.createDisplay(string2, bl);
    }

    public static Screen createScreen(Component component, boolean bl) throws IllegalArgumentException {
        Display display = NewtFactoryAWT.createDisplay(component, bl);
        return NewtFactory.createScreen(display, AWTGraphicsScreen.findScreenIndex(component.getGraphicsConfiguration().getDevice()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitorDevice getMonitorDevice(Screen screen, Component component) throws IllegalArgumentException {
        GraphicsConfiguration graphicsConfiguration = NewtFactoryAWT.checkComponentValid(component);
        String string = NativeWindowFactory.getNativeWindowType(true);
        MonitorDevice monitorDevice = null;
        screen.addReference();
        try {
            if (".macosx" == string) {
                monitorDevice = screen.getMonitor(JAWTUtil.getMonitorDisplayID(graphicsConfiguration.getDevice()));
            }
            if (null == monitorDevice) {
                Point point = AWTMisc.getLocationOnScreenSafe(null, component, false);
                Rectangle rectangle = new Rectangle(point.getX(), point.getY(), component.getWidth(), component.getHeight());
                monitorDevice = screen.getMainMonitor(rectangle);
            }
        }
        finally {
            screen.removeReference();
        }
        return monitorDevice;
    }
}

