/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.JavaEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.TypeConfig;
import com.jogamp.gluegen.TypeInfo;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.jgram.JavaLexer;
import com.jogamp.gluegen.jgram.JavaParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaConfiguration {
    private int nestedReads;
    private String packageName;
    private String implPackageName;
    private String className;
    private String implClassName;
    protected final Logging.LoggerIf LOG;
    public static String NEWLINE = System.getProperty("line.separator");
    private String javaOutputDir = ".";
    private String outputRootDir = null;
    private String nativeOutputDir = ".";
    private boolean nativeOutputUsesJavaHierarchy;
    private boolean tagNativeBinding;
    private boolean relaxedEqualSemanticsTest;
    private JavaEmitter.EmissionStyle emissionStyle = JavaEmitter.EmissionStyle.AllStatic;
    private final List<String> imports = new ArrayList<String>();
    private String gluegenRuntimePackage = "com.jogamp.gluegen.runtime";
    private String runtimeExceptionType = "RuntimeException";
    private String unsupportedExceptionType = "UnsupportedOperationException";
    private final Map<String, JavaEmitter.MethodAccess> accessControl = new HashMap<String, JavaEmitter.MethodAccess>();
    private final Map<String, TypeInfo> typeInfoMap = new HashMap<String, TypeInfo>();
    private final Set<String> returnsString = new HashSet<String>();
    private final Map<String, JavaType> returnsOpaqueJType = new HashMap<String, JavaType>();
    private final Map<String, String> returnedArrayLengths = new HashMap<String, String>();
    private final Map<String, List<Integer>> argumentsAreString = new HashMap<String, List<Integer>>();
    private final Set<String> extendedIntfSymbolsIgnore = new HashSet<String>();
    private final Set<String> extendedIntfSymbolsOnly = new HashSet<String>();
    private final Set<String> extendedImplSymbolsIgnore = new HashSet<String>();
    private final Set<String> extendedImplSymbolsOnly = new HashSet<String>();
    private final Set<Pattern> ignores = new HashSet<Pattern>();
    private final Map<String, Pattern> ignoreMap = new HashMap<String, Pattern>();
    private final Set<Pattern> ignoreNots = new HashSet<Pattern>();
    private final Set<Pattern> unignores = new HashSet<Pattern>();
    private final Set<Pattern> unimplemented = new HashSet<Pattern>();
    private boolean forceUseNIOOnly4All = false;
    private final Set<String> useNIOOnly = new HashSet<String>();
    private boolean forceUseNIODirectOnly4All = false;
    private final Set<String> useNIODirectOnly = new HashSet<String>();
    private final Set<String> manuallyImplement = new HashSet<String>();
    private final Map<String, String> delegatedImplementation = new HashMap<String, String>();
    private final Set<String> manualStaticInitCall = new HashSet<String>();
    private final Set<String> forceStaticInitCode = new HashSet<String>();
    private final Map<String, List<String>> customJavaCode = new HashMap<String, List<String>>();
    private final Map<String, List<String>> classJavadoc = new HashMap<String, List<String>>();
    private final Map<String, List<String>> methodJavadoc = new HashMap<String, List<String>>();
    private final Map<String, String> structPackages = new HashMap<String, String>();
    private final List<String> customCCode = new ArrayList<String>();
    private final List<String> forcedStructs = new ArrayList<String>();
    private final Map<String, String> structMachineDataInfoIndex = new HashMap<String, String>();
    private final Map<String, String> returnValueCapacities = new HashMap<String, String>();
    private final Map<String, String> returnValueLengths = new HashMap<String, String>();
    private final Map<String, List<String>> temporaryCVariableDeclarations = new HashMap<String, List<String>>();
    private final Map<String, List<String>> temporaryCVariableAssignments = new HashMap<String, List<String>>();
    private final Map<String, List<String>> extendedInterfaces = new HashMap<String, List<String>>();
    private final Map<String, List<String>> implementedInterfaces = new HashMap<String, List<String>>();
    private final Map<String, String> parentClass = new HashMap<String, String>();
    private final Map<String, String> javaTypeRenames = new HashMap<String, String>();
    private final Map<String, String> javaSymbolRenames = new HashMap<String, String>();
    private final Map<String, Set<String>> javaRenamedSymbols = new HashMap<String, Set<String>>();
    private final Map<String, List<String>> javaPrologues = new HashMap<String, List<String>>();
    private final Map<String, List<String>> javaEpilogues = new HashMap<String, List<String>>();
    private static final boolean DEBUG_TYPE_INFO = false;
    private static boolean loggedIgnores = false;
    private static boolean loggedRenames = false;

    public JavaConfiguration() {
        this.LOG = Logging.getLogger(JavaConfiguration.class.getPackage().getName(), JavaConfiguration.class.getSimpleName());
    }

    public final void read(String string) throws IOException {
        this.read(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void read(String string, String string2) throws IOException {
        File file = new File(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Could not read file \"" + file + "\"", fileNotFoundException);
        }
        int n = 0;
        String string3 = null;
        boolean bl = string2 != null && string2.length() > 0;
        try {
            ++this.nestedReads;
            while ((string3 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer;
                ++n;
                if (bl) {
                    string3 = string2 + " " + string3;
                }
                if (string3.trim().startsWith("#") || !(stringTokenizer = new StringTokenizer(string3)).hasMoreTokens()) continue;
                String string4 = stringTokenizer.nextToken(" \t\n\r\f");
                this.dispatch(string4, stringTokenizer, file, string, n);
            }
            bufferedReader.close();
        }
        finally {
            --this.nestedReads;
        }
        if (this.nestedReads == 0) {
            if (this.allStatic() && this.implClassName != null) {
                throw new IllegalStateException("Error in configuration file \"" + string + "\": Cannot use directive \"ImplJavaClass\" in conjunction with \"Style AllStatic\"");
            }
            if (this.className != null || this.emissionStyle() != JavaEmitter.EmissionStyle.ImplOnly) {
                // empty if block
            }
            if (this.packageName == null && this.emissionStyle() != JavaEmitter.EmissionStyle.ImplOnly) {
                throw new RuntimeException("Output package name was not specified in configuration file \"" + string + "\"");
            }
            if (this.allStatic()) {
                this.implClassName = this.className;
                this.implPackageName = this.packageName;
            } else {
                if (this.implClassName == null) {
                    if (this.className == null) {
                        throw new RuntimeException("If ImplJavaClass is not specified, must specify JavaClass");
                    }
                    this.implClassName = this.className + "Impl";
                }
                if (this.implPackageName == null) {
                    if (this.packageName == null) {
                        throw new RuntimeException("If ImplPackageName is not specified, must specify PackageName");
                    }
                    this.implPackageName = this.packageName + ".impl";
                }
            }
        }
    }

    public void setOutputRootDir(String string) {
        this.outputRootDir = string;
    }

    public String packageName() {
        return this.packageName;
    }

    public String implPackageName() {
        return this.implPackageName;
    }

    public String className() {
        return this.className;
    }

    public String implClassName() {
        return this.implClassName;
    }

    public boolean structsOnly() {
        return this.className == null && this.implClassName == null;
    }

    public String javaOutputDir() {
        return null != this.outputRootDir ? this.outputRootDir + "/" + this.javaOutputDir : this.javaOutputDir;
    }

    public String nativeOutputDir() {
        return null != this.outputRootDir ? this.outputRootDir + "/" + this.nativeOutputDir : this.nativeOutputDir;
    }

    public boolean nativeOutputUsesJavaHierarchy() {
        return this.nativeOutputUsesJavaHierarchy;
    }

    public boolean tagNativeBinding() {
        return this.tagNativeBinding;
    }

    public boolean relaxedEqualSemanticsTest() {
        return this.relaxedEqualSemanticsTest;
    }

    public JavaEmitter.EmissionStyle emissionStyle() {
        return this.emissionStyle;
    }

    public JavaEmitter.MethodAccess accessControl(String string) {
        JavaEmitter.MethodAccess methodAccess = this.accessControl.get(string);
        if (methodAccess != null) {
            return methodAccess;
        }
        return JavaEmitter.MethodAccess.PUBLIC;
    }

    public String gluegenRuntimePackage() {
        return this.gluegenRuntimePackage;
    }

    public String runtimeExceptionType() {
        return this.runtimeExceptionType;
    }

    public String unsupportedExceptionType() {
        return this.unsupportedExceptionType;
    }

    public List<String> imports() {
        return this.imports;
    }

    public TypeInfo canonicalNameOpaque(String string) {
        return this.typeInfoMap.get(string);
    }

    public TypeInfo typeInfo(Type type) {
        int n = type.pointerDepth();
        for (int i = 0; i <= n; ++i) {
            TypeInfo typeInfo;
            String string = type.getName();
            if (string != null && (typeInfo = this.closestTypeInfo(string, i + type.pointerDepth())) != null) {
                TypeInfo typeInfo2 = this.promoteTypeInfo(typeInfo, i);
                return typeInfo2;
            }
            if (type.isCompound() && (string = type.asCompound().getStructName()) != null && (typeInfo = this.closestTypeInfo(string, i + type.pointerDepth())) != null) {
                TypeInfo typeInfo3 = this.promoteTypeInfo(typeInfo, i);
                return typeInfo3;
            }
            if (!type.isPointer()) continue;
            type = type.asPointer().getTargetType();
        }
        return null;
    }

    private TypeInfo closestTypeInfo(String string, int n) {
        TypeInfo typeInfo = null;
        for (TypeInfo typeInfo2 = this.typeInfoMap.get(string); typeInfo2 != null; typeInfo2 = typeInfo2.next()) {
            if (typeInfo2.pointerDepth() > n || typeInfo != null && typeInfo2.pointerDepth() <= typeInfo.pointerDepth()) continue;
            typeInfo = typeInfo2;
        }
        return typeInfo;
    }

    private TypeInfo promoteTypeInfo(TypeInfo typeInfo, int n) {
        int n2 = n - typeInfo.pointerDepth();
        if (n2 == 0) {
            return typeInfo;
        }
        if (n2 < 0) {
            throw new RuntimeException("TypeInfo for " + typeInfo.name() + " and pointerDepth " + typeInfo.pointerDepth() + " should not have matched for depth " + n);
        }
        Class<?> clazz = typeInfo.javaType().getJavaClass();
        int n3 = typeInfo.pointerDepth();
        if (n2 == 1) {
            JavaType javaType = null;
            if (clazz == Boolean.TYPE) {
                javaType = JavaType.createForCCharPointer();
            } else if (clazz == Byte.TYPE) {
                javaType = JavaType.createForCCharPointer();
            } else if (clazz == Short.TYPE) {
                javaType = JavaType.createForCShortPointer();
            } else if (clazz == Integer.TYPE) {
                javaType = JavaType.createForCInt32Pointer();
            } else if (clazz == Long.TYPE) {
                javaType = JavaType.createForCInt64Pointer();
            } else if (clazz == Float.TYPE) {
                javaType = JavaType.createForCFloatPointer();
            } else if (clazz == Double.TYPE) {
                javaType = JavaType.createForCDoublePointer();
            }
            if (javaType != null) {
                return new TypeInfo(typeInfo.name(), n3 + n, javaType);
            }
        }
        while (n2 > 0) {
            clazz = Array.newInstance(clazz, 0).getClass();
            --n2;
        }
        return new TypeInfo(typeInfo.name(), n, JavaType.createForClass(clazz));
    }

    public boolean returnsString(String string) {
        return this.returnsString.contains(string);
    }

    public boolean returnsString(AliasedSymbol aliasedSymbol) {
        return this.returnsString.contains(aliasedSymbol.getName()) || JavaConfiguration.oneInSet(this.returnsString, aliasedSymbol.getAliasedNames());
    }

    public String returnedArrayLength(String string) {
        return this.returnedArrayLengths.get(string);
    }

    public List<Integer> stringArguments(String string) {
        return this.argumentsAreString.get(string);
    }

    public boolean isForceUsingNIOOnly4All() {
        return this.forceUseNIOOnly4All;
    }

    public void addUseNIOOnly(String string) {
        this.useNIOOnly.add(string);
    }

    public boolean useNIOOnly(String string) {
        return this.useNIODirectOnly(string) || this.forceUseNIOOnly4All || this.useNIOOnly.contains(string);
    }

    public void addUseNIODirectOnly(String string) {
        this.useNIODirectOnly.add(string);
    }

    public boolean useNIODirectOnly(String string) {
        return this.forceUseNIODirectOnly4All || this.useNIODirectOnly.contains(string);
    }

    public boolean manualStaticInitCall(String string) {
        return this.manualStaticInitCall.contains(string);
    }

    public boolean forceStaticInitCode(String string) {
        return this.forceStaticInitCode.contains(string);
    }

    public List<String> customJavaCodeForClass(String string) {
        List<String> list = this.customJavaCode.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.customJavaCode.put(string, list);
        }
        return list;
    }

    public List<String> javadocForMethod(String string) {
        List<String> list = this.methodJavadoc.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.methodJavadoc.put(string, list);
        }
        return list;
    }

    public List<String> javadocForClass(String string) {
        List<String> list = this.classJavadoc.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.classJavadoc.put(string, list);
        }
        return list;
    }

    public String packageForStruct(String string) {
        String string2 = this.structPackages.get(string);
        if (string2 == null) {
            string2 = this.packageName;
        }
        return string2;
    }

    public List<String> customCCode() {
        return this.customCCode;
    }

    public List<String> forcedStructs() {
        return this.forcedStructs;
    }

    public String returnStructMachineDataInfoIndex(String string) {
        return this.structMachineDataInfoIndex.get(string);
    }

    public String returnValueCapacity(String string) {
        return this.returnValueCapacities.get(string);
    }

    public String returnValueLength(String string) {
        return this.returnValueLengths.get(string);
    }

    public List<String> temporaryCVariableDeclarations(String string) {
        return this.temporaryCVariableDeclarations.get(string);
    }

    public List<String> temporaryCVariableAssignments(String string) {
        return this.temporaryCVariableAssignments.get(string);
    }

    public List<String> extendedInterfaces(String string) {
        List<String> list = this.extendedInterfaces.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.extendedInterfaces.put(string, list);
        }
        return list;
    }

    public List<String> implementedInterfaces(String string) {
        List<String> list = this.implementedInterfaces.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.implementedInterfaces.put(string, list);
        }
        return list;
    }

    public String extendedParentClass(String string) {
        return this.parentClass.get(string);
    }

    public void logIgnoresOnce() {
        if (!loggedIgnores) {
            loggedIgnores = true;
            this.logIgnores();
        }
    }

    public void logIgnores() {
        this.LOG.log(Level.INFO, "Extended Intf: {0}", (Object)this.extendedIntfSymbolsIgnore.size());
        for (String object : this.extendedIntfSymbolsIgnore) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)object);
        }
        this.LOG.log(Level.INFO, "Extended Impl: {0}", (Object)this.extendedImplSymbolsIgnore.size());
        for (String string : this.extendedImplSymbolsIgnore) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)string);
        }
        this.LOG.log(Level.INFO, "Ignores (All): {0}", (Object)this.ignores.size());
        for (Pattern pattern : this.ignores) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)pattern);
        }
    }

    public void logRenamesOnce() {
        if (!loggedRenames) {
            loggedRenames = true;
            this.logRenames();
        }
    }

    public void logRenames() {
        this.LOG.log(Level.INFO, "Symbol Renames: {0}", (Object)this.javaSymbolRenames.size());
        for (String string : this.javaSymbolRenames.keySet()) {
            this.LOG.log(Level.INFO, "\t{0} -> {1}", string, this.javaSymbolRenames.get(string));
        }
        this.LOG.log(Level.INFO, "Symbol Aliasing (through renaming): {0}", (Object)this.javaSymbolRenames.size());
        for (String string : this.javaSymbolRenames.values()) {
            Set<String> set = this.javaRenamedSymbols.get(string);
            if (null == set) continue;
            this.LOG.log(Level.INFO, "\t{0} <- {1}", string, set);
        }
    }

    public static <K, V> V oneInMap(Map<K, V> map, Set<K> set) {
        if (null != map && map.size() > 0 && null != set && set.size() > 0) {
            for (K k : set) {
                V v = map.get(k);
                if (null == v) continue;
                return v;
            }
        }
        return null;
    }

    public static <K> boolean oneInSet(Set<K> set, Set<K> set2) {
        if (null != set && set.size() > 0 && null != set2 && set2.size() > 0) {
            for (K k : set2) {
                if (!set.contains(k)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean onePatternMatch(Pattern pattern, Set<String> set) {
        if (null != pattern && null != set && set.size() > 0) {
            for (String string : set) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected static ASTLocusTag getASTLocusTag(AliasedSymbol aliasedSymbol) {
        if (aliasedSymbol instanceof ASTLocusTag.ASTLocusTagProvider) {
            return ((ASTLocusTag.ASTLocusTagProvider)((Object)aliasedSymbol)).getASTLocusTag();
        }
        return null;
    }

    public static String canonicalStructFieldSymbol(String string, String string2) {
        return string + "." + string2;
    }

    public boolean manuallyImplement(String string) {
        if (this.manuallyImplement.contains(string)) {
            this.LOG.log(Level.INFO, "ManuallyImplement: \"{0}\"", (Object)string);
            return true;
        }
        return false;
    }

    public boolean manuallyImplement(AliasedSymbol aliasedSymbol) {
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        if (this.manuallyImplement.contains(string) || JavaConfiguration.oneInSet(this.manuallyImplement, set)) {
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "ManuallyImplement: {0}", (Object)aliasedSymbol);
            return true;
        }
        return false;
    }

    public String getDelegatedImplementation(String string) {
        String string2 = this.delegatedImplementation.get(string);
        if (null == string2) {
            return null;
        }
        this.LOG.log(Level.INFO, "DelegatedImplementation: {0} -> {1}", string, string2);
        return string2;
    }

    public String getDelegatedImplementation(AliasedSymbol aliasedSymbol) {
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        String string2 = this.delegatedImplementation.get(string);
        if (null == string2 && null == (string2 = JavaConfiguration.oneInMap(this.delegatedImplementation, set))) {
            return null;
        }
        this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "DelegatedImplementation: {0} -> {1}", aliasedSymbol, string2);
        return string2;
    }

    public JavaType getOpaqueReturnType(String string) {
        JavaType javaType = this.returnsOpaqueJType.get(string);
        if (null == javaType) {
            return null;
        }
        this.LOG.log(Level.INFO, "ReturnsOpaque: {0} -> {1}", string, javaType);
        return javaType;
    }

    public JavaType getOpaqueReturnType(AliasedSymbol aliasedSymbol) {
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        JavaType javaType = this.returnsOpaqueJType.get(string);
        if (null == javaType && null == (javaType = JavaConfiguration.oneInMap(this.returnsOpaqueJType, set))) {
            return null;
        }
        this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "ReturnsOpaque: {0} -> {1}", aliasedSymbol, javaType);
        return javaType;
    }

    public final boolean shouldIgnoreInInterface(String string) {
        return this.shouldIgnoreInInterface(new AliasedSymbol.NoneAliasedSymbol(string));
    }

    public boolean shouldIgnoreInInterface(AliasedSymbol aliasedSymbol) {
        return this.shouldIgnoreInInterface_Int(aliasedSymbol);
    }

    protected final boolean shouldIgnoreInInterface_Int(AliasedSymbol aliasedSymbol) {
        if (GlueGen.debug()) {
            this.logIgnoresOnce();
        }
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        if (this.extendedIntfSymbolsIgnore.contains(string) || JavaConfiguration.oneInSet(this.extendedIntfSymbolsIgnore, set)) {
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Intf ignore (one): {0}", (Object)aliasedSymbol);
            return true;
        }
        if (!(this.extendedIntfSymbolsOnly.isEmpty() || this.extendedIntfSymbolsOnly.contains(string) || JavaConfiguration.oneInSet(this.extendedIntfSymbolsOnly, set))) {
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Intf !extended (all): {0}", (Object)aliasedSymbol);
            return true;
        }
        return this.shouldIgnoreInImpl_Int(aliasedSymbol);
    }

    public boolean shouldIgnoreInImpl(AliasedSymbol aliasedSymbol) {
        return this.shouldIgnoreInImpl_Int(aliasedSymbol);
    }

    protected final boolean shouldIgnoreInImpl_Int(AliasedSymbol aliasedSymbol) {
        Matcher matcher;
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        if (this.extendedImplSymbolsIgnore.contains(string) || JavaConfiguration.oneInSet(this.extendedImplSymbolsIgnore, set)) {
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Impl ignore (one): {0}", (Object)aliasedSymbol);
            return true;
        }
        if (!(this.extendedImplSymbolsOnly.isEmpty() || this.extendedImplSymbolsOnly.contains(string) || JavaConfiguration.oneInSet(this.extendedImplSymbolsOnly, set))) {
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Impl !extended (all): {0}", (Object)aliasedSymbol);
            return true;
        }
        for (Pattern pattern : this.ignores) {
            matcher = pattern.matcher(string);
            if (!matcher.matches() && !JavaConfiguration.onePatternMatch(pattern, set)) continue;
            this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Impl RegEx: {0}", (Object)aliasedSymbol);
            return true;
        }
        if (this.ignoreNots.size() > 0) {
            for (Pattern pattern : this.ignoreNots) {
                matcher = pattern.matcher(string);
                if (matcher.matches() || JavaConfiguration.onePatternMatch(pattern, set)) continue;
                if (this.unignores.isEmpty()) {
                    this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Impl unignores==0: {0} -> {1}", aliasedSymbol, string);
                    return true;
                }
                boolean bl = false;
                for (Pattern pattern2 : this.unignores) {
                    Matcher matcher2 = pattern2.matcher(string);
                    if (!matcher2.matches() && !JavaConfiguration.onePatternMatch(pattern2, set)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.LOG.log(Level.INFO, JavaConfiguration.getASTLocusTag(aliasedSymbol), "Ignore Impl !unignore: {0} -> {1}", aliasedSymbol, string);
                return true;
            }
        }
        return false;
    }

    public boolean isUnimplemented(AliasedSymbol aliasedSymbol) {
        for (Pattern pattern : this.unimplemented) {
            Matcher matcher = pattern.matcher(aliasedSymbol.getName());
            if (!matcher.matches() && !JavaConfiguration.onePatternMatch(pattern, aliasedSymbol.getAliasedNames())) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAliasedDocNames(AliasedSymbol aliasedSymbol) {
        return aliasedSymbol.getAliasedNames();
    }

    public String renameJavaType(String string) {
        String string2 = this.javaTypeRenames.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public String getJavaSymbolRename(String string) {
        if (this.LOG.isLoggable(Level.INFO)) {
            this.logRenamesOnce();
        }
        return this.javaSymbolRenames.get(string);
    }

    public Set<String> getRenamedJavaSymbols(String string) {
        return this.javaRenamedSymbols.get(string);
    }

    public void addJavaSymbolRename(String string, String string2) {
        this.LOG.log(Level.INFO, "\tRename {0} -> {1}", string, string2);
        String string3 = this.javaSymbolRenames.put(string, string2);
        if (null != string3 && !string3.equals(string2)) {
            throw new RuntimeException("Rename-Override Attampt: " + string + " -> " + string2 + ", but " + string + " -> " + string3 + " already exist. Run in 'debug' mode to analyze!");
        }
        Set<String> set = this.javaRenamedSymbols.get(string2);
        if (null == set) {
            set = new HashSet<String>();
            this.javaRenamedSymbols.put(string2, set);
        }
        set.add(string);
    }

    public void addDelegateImplementation(String string, String string2) {
        this.LOG.log(Level.INFO, "\tDelegateImplementation {0} -> {1}", string, string2);
        String string3 = this.delegatedImplementation.put(string, string2);
        if (null != string3 && !string3.equals(string2)) {
            throw new RuntimeException("Rename-Override Attampt: " + string + " -> " + string2 + ", but " + string + " -> " + string3 + " already exist. Run in 'debug' mode to analyze!");
        }
    }

    public boolean allStatic() {
        return this.emissionStyle == JavaEmitter.EmissionStyle.AllStatic;
    }

    public boolean emitInterface() {
        return this.emissionStyle() == JavaEmitter.EmissionStyle.InterfaceAndImpl || this.emissionStyle() == JavaEmitter.EmissionStyle.InterfaceOnly;
    }

    public boolean emitImpl() {
        return this.emissionStyle() == JavaEmitter.EmissionStyle.AllStatic || this.emissionStyle() == JavaEmitter.EmissionStyle.InterfaceAndImpl || this.emissionStyle() == JavaEmitter.EmissionStyle.ImplOnly;
    }

    public List<String> javaPrologueForMethod(MethodBinding methodBinding, boolean bl, boolean bl2) {
        List<String> list = this.javaPrologues.get(methodBinding.getName());
        if (list == null) {
            list = this.javaPrologues.get(methodBinding.getName() + methodBinding.getDescriptor(bl, bl2));
        }
        return list;
    }

    public List<String> javaEpilogueForMethod(MethodBinding methodBinding, boolean bl, boolean bl2) {
        List<String> list = this.javaEpilogues.get(methodBinding.getName());
        if (list == null) {
            list = this.javaEpilogues.get(methodBinding.getName() + methodBinding.getDescriptor(bl, bl2));
        }
        return list;
    }

    protected void dispatch(String string, StringTokenizer stringTokenizer, File file, String string2, int n) throws IOException {
        if (string.equalsIgnoreCase("Package")) {
            this.packageName = this.readString("package", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("GlueGenRuntimePackage")) {
            this.gluegenRuntimePackage = this.readString("GlueGenRuntimePackage", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ImplPackage")) {
            this.implPackageName = this.readString("ImplPackage", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("JavaClass")) {
            this.className = this.readString("JavaClass", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ImplJavaClass")) {
            this.implClassName = this.readString("ImplJavaClass", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("JavaOutputDir")) {
            this.javaOutputDir = this.readString("JavaOutputDir", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("NativeOutputDir")) {
            this.nativeOutputDir = this.readString("NativeOutputDir", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("HierarchicalNativeOutput")) {
            String string3 = this.readString("HierarchicalNativeOutput", stringTokenizer, string2, n);
            this.nativeOutputUsesJavaHierarchy = Boolean.valueOf(string3);
        } else if (string.equalsIgnoreCase("TagNativeBinding")) {
            this.tagNativeBinding = this.readBoolean("TagNativeBinding", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("RelaxedEqualSemanticsTest")) {
            this.relaxedEqualSemanticsTest = this.readBoolean("RelaxedEqualSemanticsTest", stringTokenizer, string2, n);
            TypeConfig.setRelaxedEqualSemanticsTest(this.relaxedEqualSemanticsTest);
        } else if (string.equalsIgnoreCase("Style")) {
            try {
                this.emissionStyle = JavaEmitter.EmissionStyle.valueOf(this.readString("Style", stringTokenizer, string2, n));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.LOG.log(Level.WARNING, "Error parsing \"style\" command at line {0} in file \"{1}\"", n, string2);
            }
        } else if (string.equalsIgnoreCase("AccessControl")) {
            this.readAccessControl(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("Import")) {
            this.imports.add(this.readString("Import", stringTokenizer, string2, n));
        } else if (string.equalsIgnoreCase("Opaque")) {
            this.readOpaque(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ReturnsString")) {
            this.readReturnsString(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ReturnsOpaque")) {
            this.readReturnsOpaque(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ReturnedArrayLength")) {
            this.readReturnedArrayLength(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ArgumentIsString")) {
            this.readArgumentIsString(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ExtendedInterfaceSymbolsIgnore")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, true, false, false);
        } else if (string.equalsIgnoreCase("ExtendedInterfaceSymbolsOnly")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, true, false, true);
        } else if (string.equalsIgnoreCase("ExtendedImplementationSymbolsIgnore")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, false, true, false);
        } else if (string.equalsIgnoreCase("ExtendedImplementationSymbolsOnly")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, false, true, true);
        } else if (string.equalsIgnoreCase("ExtendedIntfAndImplSymbolsIgnore")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, true, true, false);
        } else if (string.equalsIgnoreCase("ExtendedIntfAndImplSymbolsOnly")) {
            this.readExtendedIntfImplSymbols(stringTokenizer, string2, n, true, true, true);
        } else if (string.equalsIgnoreCase("Ignore")) {
            this.readIgnore(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("Unignore")) {
            this.readUnignore(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("IgnoreNot")) {
            this.readIgnoreNot(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("Unimplemented")) {
            this.readUnimplemented(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("IgnoreField")) {
            this.readIgnoreField(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ManuallyImplement")) {
            this.readManuallyImplement(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ManualStaticInitCall")) {
            this.readManualStaticInitCall(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ForceStaticInitCode")) {
            this.readForceStaticInitCode(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("CustomJavaCode")) {
            this.readCustomJavaCode(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("CustomCCode")) {
            this.readCustomCCode(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("MethodJavadoc")) {
            this.readMethodJavadoc(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ClassJavadoc")) {
            this.readClassJavadoc(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("NIOOnly")) {
            String string4 = this.readString("NIOOnly", stringTokenizer, string2, n);
            if (string4.equals("__ALL__")) {
                this.forceUseNIOOnly4All = true;
            } else {
                this.addUseNIOOnly(string4);
            }
        } else if (string.equalsIgnoreCase("NIODirectOnly")) {
            String string5 = this.readString("NIODirectOnly", stringTokenizer, string2, n);
            if (string5.equals("__ALL__")) {
                this.forceUseNIODirectOnly4All = true;
            } else {
                this.addUseNIODirectOnly(string5);
            }
        } else if (string.equalsIgnoreCase("EmitStruct")) {
            this.forcedStructs.add(this.readString("EmitStruct", stringTokenizer, string2, n));
        } else if (string.equalsIgnoreCase("StructPackage")) {
            this.readStructPackage(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("TemporaryCVariableDeclaration")) {
            this.readTemporaryCVariableDeclaration(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("TemporaryCVariableAssignment")) {
            this.readTemporaryCVariableAssignment(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("StructMachineDataInfoIndex")) {
            this.readStructMachineDataInfoIndex(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ReturnValueCapacity")) {
            this.readReturnValueCapacity(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ReturnValueLength")) {
            this.readReturnValueLength(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("Include")) {
            this.doInclude(stringTokenizer, file, string2, n);
        } else if (string.equalsIgnoreCase("IncludeAs")) {
            this.doIncludeAs(stringTokenizer, file, string2, n);
        } else if (string.equalsIgnoreCase("Extends")) {
            this.readExtend(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("Implements")) {
            this.readImplements(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("ParentClass")) {
            this.readParentClass(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("RenameJavaType")) {
            this.readRenameJavaType(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("RenameJavaSymbol")) {
            this.readRenameJavaSymbol(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("DelegateImplementation")) {
            this.readDelegateImplementation(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("RuntimeExceptionType")) {
            this.runtimeExceptionType = this.readString("RuntimeExceptionType", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("UnsupportedExceptionType")) {
            this.unsupportedExceptionType = this.readString("UnsupportedExceptionType", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("JavaPrologue")) {
            this.readJavaPrologueOrEpilogue(stringTokenizer, string2, n, true);
        } else if (string.equalsIgnoreCase("JavaEpilogue")) {
            this.readJavaPrologueOrEpilogue(stringTokenizer, string2, n, false);
        } else if (string.equalsIgnoreCase("RangeCheck")) {
            this.readRangeCheck(stringTokenizer, string2, n, false);
        } else if (string.equalsIgnoreCase("RangeCheckBytes")) {
            this.readRangeCheck(stringTokenizer, string2, n, true);
        } else {
            throw new RuntimeException("Unknown command \"" + string + "\" in command file " + string2 + " at line number " + n);
        }
    }

    protected String readString(String string, StringTokenizer stringTokenizer, String string2, int n) {
        try {
            return stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"" + string + "\" command at line " + n + " in file \"" + string2 + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected Boolean readBoolean(String string, StringTokenizer stringTokenizer, String string2, int n) {
        try {
            return Boolean.valueOf(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"" + string + "\" command at line " + n + " in file \"" + string2 + "\": missing expected boolean value", noSuchElementException);
        }
    }

    protected Class<?> stringToPrimitiveType(String string) throws ClassNotFoundException {
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        throw new RuntimeException("Only primitive types are supported here");
    }

    protected void readAccessControl(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            JavaEmitter.MethodAccess methodAccess = JavaEmitter.MethodAccess.valueOf(string3.toUpperCase());
            this.accessControl.put(string2, methodAccess);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing \"AccessControl\" command at line " + n + " in file \"" + string + "\"", exception);
        }
    }

    protected void readOpaque(StringTokenizer stringTokenizer, String string, int n) {
        try {
            JavaType javaType = JavaType.createForOpaqueClass(this.stringToPrimitiveType(stringTokenizer.nextToken()));
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (string2 == null) {
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                string2 = string2 + " " + stringTokenizer.nextToken();
            }
            if (string2 == null) {
                throw new RuntimeException("No C type for \"Opaque\" command at line " + n + " in file \"" + string + "\"");
            }
            TypeInfo typeInfo = JavaConfiguration.parseTypeInfo(string2, javaType);
            this.addTypeInfo(typeInfo);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing \"Opaque\" command at line " + n + " in file \"" + string + "\"", exception);
        }
    }

    protected void readReturnsOpaque(StringTokenizer stringTokenizer, String string, int n) {
        try {
            JavaType javaType = JavaType.createForOpaqueClass(this.stringToPrimitiveType(stringTokenizer.nextToken()));
            String string2 = stringTokenizer.nextToken();
            this.returnsOpaqueJType.put(string2, javaType);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing \"ReturnsOpaque\" command at line " + n + " in file \"" + string + "\"", exception);
        }
    }

    protected void readReturnsString(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.returnsString.add(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ReturnsString\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readReturnedArrayLength(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            this.returnedArrayLengths.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ReturnedArrayLength\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readExtendedIntfImplSymbols(StringTokenizer stringTokenizer, String string, int n, boolean bl, boolean bl2, boolean bl3) {
        BufferedReader bufferedReader;
        File file;
        try {
            file = new File(stringTokenizer.nextToken());
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        JavaLexer javaLexer = new JavaLexer(bufferedReader);
        javaLexer.setFilename(file.getName());
        JavaParser javaParser = new JavaParser(javaLexer);
        javaParser.setFilename(file.getName());
        try {
            javaParser.compilationUnit();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        Set<String> set = javaParser.getParsedEnumNames();
        Set<String> set2 = javaParser.getParsedFunctionNames();
        if (bl) {
            if (bl3) {
                this.extendedIntfSymbolsOnly.addAll(set);
                this.extendedIntfSymbolsOnly.addAll(set2);
            } else {
                this.extendedIntfSymbolsIgnore.addAll(set);
                this.extendedIntfSymbolsIgnore.addAll(set2);
            }
        }
        if (bl2) {
            if (bl3) {
                this.extendedImplSymbolsOnly.addAll(set);
                this.extendedImplSymbolsOnly.addAll(set2);
            } else {
                this.extendedImplSymbolsIgnore.addAll(set);
                this.extendedImplSymbolsIgnore.addAll(set2);
            }
        }
    }

    protected void readIgnore(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            Pattern pattern = Pattern.compile(string2);
            this.ignores.add(pattern);
            this.ignoreMap.put(string2, pattern);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Ignore\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readUnignore(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            Pattern pattern = this.ignoreMap.get(string2);
            this.ignoreMap.remove(string2);
            this.ignores.remove(pattern);
            if (pattern == null) {
                pattern = Pattern.compile(string2);
            }
            this.unignores.add(pattern);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Unignore\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readIgnoreNot(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.ignoreNots.add(Pattern.compile(string2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"IgnoreNot\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readUnimplemented(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.unimplemented.add(Pattern.compile(string2));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Unimplemented\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readIgnoreField(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.ignores.add(Pattern.compile(string2 + "\\." + string3));
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"IgnoreField\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readManuallyImplement(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.manuallyImplement.add(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ManuallyImplement\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readManualStaticInitCall(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.manualStaticInitCall.add(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ManualStaticInitCall\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readForceStaticInitCode(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.forceStaticInitCode.add(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ForceStaticInitCode\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readCustomJavaCode(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            try {
                String string3 = stringTokenizer.nextToken("\n\r\f");
                this.addCustomJavaCode(string2, string3);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addCustomJavaCode(string2, "");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"CustomJavaCode\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void addCustomJavaCode(String string, String string2) {
        List<String> list = this.customJavaCodeForClass(string);
        list.add(string2);
    }

    protected void readCustomCCode(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken("\n\r\f");
            this.customCCode.add(string2);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.customCCode.add("");
        }
    }

    protected void readMethodJavadoc(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            this.addMethodJavadoc(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"MethodJavadoc\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void addMethodJavadoc(String string, String string2) {
        List<String> list = this.javadocForMethod(string);
        list.add(string2);
    }

    protected void readClassJavadoc(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            this.addClassJavadoc(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ClassJavadoc\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void addClassJavadoc(String string, String string2) {
        List<String> list = this.javadocForClass(string);
        list.add(string2);
    }

    protected void readArgumentIsString(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(2);
            while (stringTokenizer.hasMoreTokens()) {
                Integer n2 = Integer.valueOf(stringTokenizer.nextToken());
                arrayList.add(n2);
            }
            if (arrayList.size() <= 0) {
                throw new RuntimeException("ERROR: Error parsing \"ArgumentIsString\" command at line " + n + " in file \"" + string + "\": directive requires specification of at least 1 index");
            }
            this.argumentsAreString.put(string2, arrayList);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ArgumentIsString\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readStructPackage(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.structPackages.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"StructPackage\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readStructMachineDataInfoIndex(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            this.structMachineDataInfoIndex.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"StructMachineDataInfoIndex\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readReturnValueCapacity(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            this.returnValueCapacities.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ReturnValueCapacity\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readReturnValueLength(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            this.returnValueLengths.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ReturnValueLength\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readTemporaryCVariableDeclaration(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            List<String> list = this.temporaryCVariableDeclarations.get(string2);
            if (list == null) {
                list = new ArrayList<String>();
                this.temporaryCVariableDeclarations.put(string2, list);
            }
            list.add(string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"TemporaryCVariableDeclaration\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readTemporaryCVariableAssignment(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            List<String> list = this.temporaryCVariableAssignments.get(string2);
            if (list == null) {
                list = new ArrayList<String>();
                this.temporaryCVariableAssignments.put(string2, list);
            }
            list.add(string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"TemporaryCVariableAssignment\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void doInclude(StringTokenizer stringTokenizer, File file, String string, int n) throws IOException {
        try {
            String string2 = stringTokenizer.nextToken();
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file.getParentFile(), string2);
            }
            this.read(file2.getAbsolutePath());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Include\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void doIncludeAs(StringTokenizer stringTokenizer, File file, String string, int n) throws IOException {
        try {
            StringBuilder stringBuilder = new StringBuilder(128);
            while (stringTokenizer.countTokens() > 1) {
                stringBuilder.append(stringTokenizer.nextToken());
                stringBuilder.append(" ");
            }
            String string2 = stringTokenizer.nextToken();
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file.getParentFile(), string2);
            }
            this.read(file2.getAbsolutePath(), stringBuilder.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"IncludeAs\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void readExtend(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            List<String> list = this.extendedInterfaces(string2);
            list.add(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Extends\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected void readImplements(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            List<String> list = this.implementedInterfaces(string2);
            list.add(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"Implements\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected void readParentClass(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            this.parentClass.put(string2, stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"ParentClass\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected void readRenameJavaType(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.javaTypeRenames.put(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"RenameJavaType\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected void readRenameJavaSymbol(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.addJavaSymbolRename(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"RenameJavaSymbol\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    public void readDelegateImplementation(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            this.addDelegateImplementation(string2, string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"DelegateImplementation\" command at line " + n + " in file \"" + string + "\": missing expected parameter", noSuchElementException);
        }
    }

    protected void readJavaPrologueOrEpilogue(StringTokenizer stringTokenizer, String string, int n, boolean bl) {
        try {
            int n2;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            if (JavaConfiguration.startsWithDescriptor(string3) && (n2 = string3.indexOf(32)) > 0) {
                String string4 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1, string3.length());
                string2 = string2 + string4;
            }
            this.addJavaPrologueOrEpilogue(string2, string3, bl);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"" + (bl ? "JavaPrologue" : "JavaEpilogue") + "\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    protected void addJavaPrologueOrEpilogue(String string, String string2, boolean bl) {
        Map<String, List<String>> map = bl ? this.javaPrologues : this.javaEpilogues;
        List<String> list = map.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(string, list);
        }
        list.add(string2);
    }

    protected void readRangeCheck(StringTokenizer stringTokenizer, String string, int n, boolean bl) {
        try {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            String string3 = stringTokenizer.nextToken("\n\r\f");
            string3 = string3.trim();
            this.addJavaPrologueOrEpilogue(string2, "Buffers.rangeCheck" + (bl ? "Bytes" : "") + "({" + n2 + "}, " + string3 + ");", true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Error parsing \"RangeCheck" + (bl ? "Bytes" : "") + "\" command at line " + n + " in file \"" + string + "\"", exception);
        }
    }

    protected static TypeInfo parseTypeInfo(String string, JavaType javaType) {
        int n;
        String string2 = null;
        int n2 = 0;
        for (n = 0; n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '*'; ++n) {
        }
        string2 = string.substring(0, n);
        while (n < string.length()) {
            if (string.charAt(n) == '*') {
                ++n2;
            }
            ++n;
        }
        return new TypeInfo(string2, n2, javaType);
    }

    public TypeInfo addTypeInfo(String string, Type type) {
        TypeInfo typeInfo = this.typeInfo(type);
        if (null != typeInfo) {
            TypeInfo typeInfo2 = new TypeInfo(string, typeInfo.pointerDepth(), typeInfo.javaType());
            this.addTypeInfo(typeInfo2);
            return typeInfo2;
        }
        return null;
    }

    protected void addTypeInfo(TypeInfo typeInfo) {
        TypeInfo typeInfo2 = this.typeInfoMap.get(typeInfo.name());
        if (typeInfo2 == null) {
            this.typeInfoMap.put(typeInfo.name(), typeInfo);
            return;
        }
        while (typeInfo2.next() != null) {
            typeInfo2 = typeInfo2.next();
        }
        typeInfo2.setNext(typeInfo);
    }

    private static int nextIndexAfterType(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c) || c == '/') {
                ++n;
                continue;
            }
            if (c == ';') {
                return n + 1;
            }
            return -1;
        }
        return -1;
    }

    private static int nextIndexAfterDescriptor(String string, int n) {
        char c = string.charAt(n);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return 1 + n;
            }
            case 'L': {
                return JavaConfiguration.nextIndexAfterType(string, n + 1);
            }
            case ')': {
                return n;
            }
        }
        return -1;
    }

    protected static boolean startsWithDescriptor(String string) {
        int n;
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 >= n3) {
            return false;
        }
        if (string.charAt(n2++) != '(') {
            return false;
        }
        while (n2 < n3) {
            n = JavaConfiguration.nextIndexAfterDescriptor(string, n2);
            if (n < 0) {
                return false;
            }
            if (n == n2) break;
            n2 = n;
        }
        return (n = JavaConfiguration.nextIndexAfterDescriptor(string, n2 + 1)) >= 0;
    }
}

