/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeVisitor;

public class BitType
extends IntType
implements Cloneable {
    private final IntType underlyingType;
    private final int sizeInBits;
    private final int offset;

    public BitType(IntType intType, int n, int n2, int n3, ASTLocusTag aSTLocusTag) {
        super(intType.getName(), intType.getSize(), intType.isUnsigned(), n3, aSTLocusTag);
        this.underlyingType = intType;
        this.sizeInBits = n;
        this.offset = n2;
    }

    private BitType(BitType bitType, int n, ASTLocusTag aSTLocusTag) {
        super(bitType, n, aSTLocusTag);
        this.underlyingType = bitType.underlyingType;
        this.sizeInBits = bitType.sizeInBits;
        this.offset = bitType.offset;
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        return new BitType(this, n, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        int n = super.hashCodeImpl();
        n = (n << 5) - n + this.underlyingType.hashCode();
        n = (n << 5) - n + this.sizeInBits;
        return (n << 5) - n + this.offset;
    }

    @Override
    protected boolean equalsImpl(Type type) {
        BitType bitType = (BitType)type;
        return super.equalsImpl(type) && this.underlyingType.equals(bitType.underlyingType) && this.sizeInBits == bitType.sizeInBits && this.offset == bitType.offset;
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        int n = super.hashCodeSemanticsImpl();
        n = (n << 5) - n + this.underlyingType.hashCodeSemantics();
        n = (n << 5) - n + this.sizeInBits;
        return (n << 5) - n + this.offset;
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        BitType bitType = (BitType)type;
        return super.equalSemanticsImpl(type) && this.underlyingType.equalSemantics(bitType.underlyingType) && this.sizeInBits == bitType.sizeInBits && this.offset == bitType.offset;
    }

    @Override
    public BitType asBit() {
        return this;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.underlyingType.visit(typeVisitor);
    }
}

