/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.cgram.types.TypeComparator;

public abstract class SizeThunk
implements Cloneable,
TypeComparator.SemanticEqualityOp {
    static boolean relaxedEqSem = false;
    private final boolean fixedNativeSize;
    static final int magic_int08 = 16;
    static final int magic_int16 = 18;
    static final int magic_int32 = 20;
    static final int magic_intxx = 22;
    static final int magic_long64 = 32;
    static final int magic_longxx = 34;
    static final int magic_float32 = 48;
    static final int magic_float64 = 50;
    static final int magic_aptr64 = 64;
    static final int magic_ops = 65536;
    public static final SizeThunk INT8 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int8SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int8AlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 1;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return relaxedEqSem ? 20 : 16;
        }
    };
    public static final SizeThunk INT16 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int16SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int16AlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 2;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return relaxedEqSem ? 20 : 18;
        }
    };
    public static final SizeThunk INT32 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int32SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int32AlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 3;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return 20;
        }
    };
    public static final SizeThunk INTxx = new SizeThunk(false){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.intSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.intAlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 4;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return relaxedEqSem ? 20 : 22;
        }
    };
    public static final SizeThunk LONG = new SizeThunk(false){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.longSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.longAlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 5;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return relaxedEqSem ? 32 : 34;
        }
    };
    public static final SizeThunk INT64 = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int64SizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.int64AlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 6;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return 32;
        }
    };
    public static final SizeThunk FLOAT = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.floatSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.floatAlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 7;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return 48;
        }
    };
    public static final SizeThunk DOUBLE = new SizeThunk(true){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.doubleSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.doubleAlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 8;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return 50;
        }
    };
    public static final SizeThunk POINTER = new SizeThunk(false){

        @Override
        public long computeSize(MachineDataInfo machineDataInfo) {
            return machineDataInfo.pointerSizeInBytes();
        }

        @Override
        public long computeAlignment(MachineDataInfo machineDataInfo) {
            return machineDataInfo.pointerAlignmentInBytes();
        }

        @Override
        protected int hashCodeImpl() {
            return 9;
        }

        @Override
        protected int hashCodeSemanticsImpl() {
            return 64;
        }
    };

    public static void setRelaxedEqualSemanticsTest(boolean bl) {
        relaxedEqSem = bl;
    }

    private SizeThunk(boolean bl) {
        this.fixedNativeSize = bl;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean hasFixedNativeSize() {
        return this.fixedNativeSize;
    }

    public abstract long computeSize(MachineDataInfo var1);

    public abstract long computeAlignment(MachineDataInfo var1);

    public final int hashCode() {
        return 1492582513 + this.hashCodeImpl();
    }

    abstract int hashCodeImpl();

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SizeThunk)) {
            return false;
        }
        SizeThunk sizeThunk = (SizeThunk)object;
        return this.hashCodeImpl() == sizeThunk.hashCodeImpl();
    }

    @Override
    public final int hashCodeSemantics() {
        return 972488321 + this.hashCodeSemanticsImpl();
    }

    abstract int hashCodeSemanticsImpl();

    @Override
    public final boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
        if (semanticEqualityOp == this) {
            return true;
        }
        if (!(semanticEqualityOp instanceof SizeThunk)) {
            return false;
        }
        SizeThunk sizeThunk = (SizeThunk)semanticEqualityOp;
        return this.hashCodeSemanticsImpl() == sizeThunk.hashCodeSemanticsImpl();
    }

    public static SizeThunk add(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDataInfo machineDataInfo) {
                return sizeThunk.computeSize(machineDataInfo) + sizeThunk2.computeSize(machineDataInfo);
            }

            @Override
            public long computeAlignment(MachineDataInfo machineDataInfo) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDataInfo);
                return l2 > (l = sizeThunk2.computeAlignment(machineDataInfo)) ? l2 : l;
            }

            @Override
            protected int hashCodeImpl() {
                int n = 41;
                n = (n << 5) - n + (null != sizeThunk ? sizeThunk.hashCode() : 0);
                return (n << 5) - n + (null != sizeThunk2 ? sizeThunk2.hashCode() : 0);
            }

            @Override
            protected int hashCodeSemanticsImpl() {
                return 65537;
            }
        };
    }

    public static SizeThunk mul(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDataInfo machineDataInfo) {
                return sizeThunk.computeSize(machineDataInfo) * sizeThunk2.computeSize(machineDataInfo);
            }

            @Override
            public long computeAlignment(MachineDataInfo machineDataInfo) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDataInfo);
                return l2 > (l = sizeThunk2.computeAlignment(machineDataInfo)) ? l2 : l;
            }

            @Override
            protected int hashCodeImpl() {
                int n = 42;
                n = (n << 5) - n + (null != sizeThunk ? sizeThunk.hashCode() : 0);
                return (n << 5) - n + (null != sizeThunk2 ? sizeThunk2.hashCode() : 0);
            }

            @Override
            protected int hashCodeSemanticsImpl() {
                return 65538;
            }
        };
    }

    public static SizeThunk align(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDataInfo machineDataInfo) {
                long l = sizeThunk.computeSize(machineDataInfo);
                long l2 = sizeThunk2.computeAlignment(machineDataInfo);
                long l3 = l2 - (l & l2 - 1L) & l2 - 1L;
                return l + l3;
            }

            @Override
            public long computeAlignment(MachineDataInfo machineDataInfo) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDataInfo);
                return l2 > (l = sizeThunk2.computeAlignment(machineDataInfo)) ? l2 : l;
            }

            @Override
            protected int hashCodeImpl() {
                int n = 43;
                n = (n << 5) - n + (null != sizeThunk ? sizeThunk.hashCode() : 0);
                return (n << 5) - n + (null != sizeThunk2 ? sizeThunk2.hashCode() : 0);
            }

            @Override
            protected int hashCodeSemanticsImpl() {
                return 65539;
            }
        };
    }

    public static SizeThunk max(final SizeThunk sizeThunk, final SizeThunk sizeThunk2) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDataInfo machineDataInfo) {
                return Math.max(sizeThunk.computeSize(machineDataInfo), sizeThunk2.computeSize(machineDataInfo));
            }

            @Override
            public long computeAlignment(MachineDataInfo machineDataInfo) {
                long l;
                long l2 = sizeThunk.computeAlignment(machineDataInfo);
                return l2 > (l = sizeThunk2.computeAlignment(machineDataInfo)) ? l2 : l;
            }

            @Override
            protected int hashCodeImpl() {
                int n = 44;
                n = (n << 5) - n + (null != sizeThunk ? sizeThunk.hashCode() : 0);
                return (n << 5) - n + (null != sizeThunk2 ? sizeThunk2.hashCode() : 0);
            }

            @Override
            protected int hashCodeSemanticsImpl() {
                return 65540;
            }
        };
    }

    public static SizeThunk constant(final int n) {
        return new SizeThunk(false){

            @Override
            public long computeSize(MachineDataInfo machineDataInfo) {
                return n;
            }

            @Override
            public long computeAlignment(MachineDataInfo machineDataInfo) {
                return 1L;
            }

            @Override
            protected int hashCodeImpl() {
                return 1395 + n;
            }

            @Override
            protected int hashCodeSemanticsImpl() {
                return 65541;
            }
        };
    }
}

