/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Macro {
    private final Source source;
    private final String name;
    private List<String> args;
    private boolean variadic;
    private boolean hasPaste;
    private List<Token> tokens;

    public Macro(Source source, String string) {
        this.source = source;
        this.name = string;
        this.args = null;
        this.variadic = false;
        this.hasPaste = false;
        this.tokens = new ArrayList<Token>();
    }

    public Macro(Macro macro) {
        this(macro, macro.tokens, true);
    }

    public Macro(Macro macro, List<Token> list) {
        this(macro, list, false);
    }

    private Macro(Macro macro, List<Token> arrayList, boolean bl) {
        this.source = macro.source;
        this.name = macro.name;
        this.args = null != macro.args ? new ArrayList<String>(macro.args) : null;
        this.variadic = macro.variadic;
        this.hasPaste = macro.hasPaste;
        this.tokens = null != arrayList ? (bl ? new ArrayList(arrayList) : arrayList) : new ArrayList<Token>();
    }

    public Macro(String string) {
        this(null, string);
    }

    public Source getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    void setArgs(List<String> list) {
        this.args = list;
    }

    public boolean isFunctionLike() {
        return this.args != null;
    }

    public int getArgs() {
        return this.args.size();
    }

    public void setVariadic(boolean bl) {
        this.variadic = bl;
    }

    public boolean isVariadic() {
        return this.variadic;
    }

    public boolean hasPaste() {
        return this.hasPaste;
    }

    public void addToken(Token token) {
        this.tokens.add(token);
    }

    public void addPaste(Token token) {
        this.tokens.add(this.tokens.size() - 1, token);
        this.hasPaste = true;
    }

    List<Token> getTokens() {
        return this.tokens;
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Token token : this.tokens) {
            if (token.getType() == 297) {
                assert (!bl) : "Two sequential pastes.";
                bl = true;
                continue;
            }
            stringBuilder.append(token.getText());
            if (!bl) continue;
            stringBuilder.append(" ## ");
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.name);
        if (this.args != null) {
            stringBuilder.append('(');
            Iterator<String> iterator = this.args.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
                if (iterator.hasNext()) {
                    stringBuilder.append(", ");
                    continue;
                }
                if (!this.isVariadic()) continue;
                stringBuilder.append("...");
            }
            stringBuilder.append(')');
        }
        if (!this.tokens.isEmpty()) {
            stringBuilder.append(" => ").append(this.getText());
        }
        return stringBuilder.toString();
    }
}

