/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.Argument;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.Macro;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.SourceIterator;
import com.jogamp.gluegen.jcpp.StringLexerSource;
import com.jogamp.gluegen.jcpp.Token;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

class MacroTokenSource
extends Source {
    private final Macro macro;
    private final Iterator<Token> tokens;
    private final List<Argument> args;
    private Iterator<Token> arg;

    MacroTokenSource(@Nonnull Macro macro, @Nonnull List<Argument> list) {
        this.macro = macro;
        this.tokens = macro.getTokens().iterator();
        this.args = list;
        this.arg = null;
    }

    @Override
    boolean isExpanding(@Nonnull Macro macro) {
        if (this.macro == macro) {
            return true;
        }
        return super.isExpanding(macro);
    }

    static void escape(@Nonnull StringBuilder stringBuilder, @Nonnull CharSequence charSequence) {
        if (stringBuilder == null) {
            throw new NullPointerException("Buffer was null.");
        }
        if (charSequence == null) {
            throw new NullPointerException("CharSequence was null.");
        }
        block6: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
    }

    private void concat(@Nonnull StringBuilder stringBuilder, @Nonnull Argument argument) {
        for (Token token : argument) {
            stringBuilder.append(token.getText());
        }
    }

    @Nonnull
    private Token stringify(@Nonnull Token token, @Nonnull Argument argument) {
        StringBuilder stringBuilder = new StringBuilder();
        this.concat(stringBuilder, argument);
        StringBuilder stringBuilder2 = new StringBuilder("\"");
        MacroTokenSource.escape(stringBuilder2, stringBuilder);
        stringBuilder2.append("\"");
        return new Token(292, token.getLine(), token.getColumn(), stringBuilder2.toString(), stringBuilder.toString());
    }

    private void paste(@Nonnull Token token) throws IOException, LexerException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 2;
        block5: for (int i = 0; i < n; ++i) {
            if (!this.tokens.hasNext()) {
                this.error(token.getLine(), token.getColumn(), "Paste at end of expansion");
                stringBuilder.append(' ').append(token.getText());
                break;
            }
            Token token2 = this.tokens.next();
            switch (token2.getType()) {
                case 297: {
                    n += 2;
                    token = token2;
                    continue block5;
                }
                case 296: {
                    int n2 = (Integer)token2.getValue();
                    this.concat(stringBuilder, this.args.get(n2));
                    continue block5;
                }
                case 260: 
                case 261: {
                    continue block5;
                }
                default: {
                    stringBuilder.append(token2.getText());
                }
            }
        }
        StringLexerSource stringLexerSource = new StringLexerSource(stringBuilder.toString());
        this.arg = new SourceIterator(stringLexerSource);
    }

    @Override
    public Token token() throws IOException, LexerException {
        Token token;
        block5: while (true) {
            if (this.arg != null) {
                if (this.arg.hasNext()) {
                    token = this.arg.next();
                    assert (token.getType() != 297) : "Unexpected paste token";
                    return token;
                }
                this.arg = null;
            }
            if (!this.tokens.hasNext()) {
                return new Token(265, -1, -1, "");
            }
            token = this.tokens.next();
            switch (token.getType()) {
                case 298: {
                    int n = (Integer)token.getValue();
                    return this.stringify(token, this.args.get(n));
                }
                case 296: {
                    int n = (Integer)token.getValue();
                    this.arg = this.args.get(n).expansion();
                    continue block5;
                }
                case 297: {
                    this.paste(token);
                    continue block5;
                }
            }
            break;
        }
        return token;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("expansion of ").append(this.macro.getName());
        Source source = this.getParent();
        if (source != null) {
            stringBuilder.append(" in ").append(String.valueOf(source));
        }
        return stringBuilder.toString();
    }
}

