/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.pcpp;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;

public class ConcatenatingReader
extends FilterReader {
    private char[] curBuf;
    private int curPos;
    private final BufferedReader reader;
    private static String newline = System.getProperty("line.separator");

    public ConcatenatingReader(BufferedReader bufferedReader) {
        super(bufferedReader);
        this.reader = bufferedReader;
    }

    @Override
    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        if (n < 0) {
            return -1;
        }
        return cArray[0];
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean ready() throws IOException {
        return this.curBuf != null || this.reader.ready();
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.curBuf == null) {
            this.nextLine();
        }
        if (this.curBuf == null) {
            return -1;
        }
        int n3 = 0;
        while (n2 > 0 && this.curBuf != null && this.curPos < this.curBuf.length) {
            cArray[n] = this.curBuf[this.curPos];
            ++this.curPos;
            ++n;
            --n2;
            ++n3;
            if (this.curPos != this.curBuf.length) continue;
            this.nextLine();
        }
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l > 0L) {
            int n = (int)l;
            char[] cArray = new char[n];
            int n2 = this.read(cArray, 0, n);
            l -= (long)n2;
            l2 += (long)n2;
            if (n2 >= n) continue;
            break;
        }
        return l2;
    }

    private void nextLine() throws IOException {
        String string = this.reader.readLine();
        if (string == null) {
            this.curBuf = null;
            return;
        }
        int n = string.length();
        boolean bl = true;
        if (n > 0 && string.charAt(string.length() - 1) == '\\') {
            --n;
            bl = false;
        }
        char[] cArray = new char[n + (bl ? newline.length() : 0)];
        string.getChars(0, n, cArray, 0);
        if (bl) {
            newline.getChars(0, newline.length(), cArray, n);
        }
        this.curBuf = cArray;
        this.curPos = 0;
    }
}

