/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.pcpp;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.GenericCPP;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.pcpp.ConcatenatingReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class PCPP
implements GenericCPP {
    private final Logging.LoggerIf LOG;
    private final Map<String, String> defineMap = new HashMap<String, String>(128);
    private final Map<String, Macro> macroMap = new HashMap<String, Macro>(128);
    private final Set<String> nonConstantDefines = new HashSet<String>(128);
    private final List<String> includePaths;
    private ParseState state;
    private final boolean enableDebugPrint;
    private final boolean enableCopyOutput2Stderr;
    private OutputStream out;
    private PrintWriter writer;
    private final List<Boolean> enabledBits = new ArrayList<Boolean>();
    private static int debugPrintIndentLevel = 0;

    public PCPP(List<String> list, boolean bl, boolean bl2) {
        this.LOG = Logging.getLogger(PCPP.class.getPackage().getName(), PCPP.class.getSimpleName());
        this.includePaths = list;
        this.setOut(System.out);
        this.enableDebugPrint = bl;
        this.enableCopyOutput2Stderr = bl2;
    }

    @Override
    public void run(Reader reader, String string) throws GlueGenException {
        StreamTokenizer streamTokenizer = null;
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        streamTokenizer = new StreamTokenizer(new ConcatenatingReader(bufferedReader));
        this.initTokenizer(streamTokenizer);
        ParseState parseState = new ParseState(streamTokenizer, string);
        ParseState parseState2 = this.state;
        this.state = parseState;
        this.lineDirective();
        try {
            this.parse();
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder("Preprocessor failed");
            this.LOG.log(Level.SEVERE, stringBuilder.toString(), (Object)exception);
            if (exception instanceof GlueGenException) {
                throw (GlueGenException)exception;
            }
            throw new GlueGenException("Preprocessor failed", new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), exception);
        }
        this.state = parseState2;
        if (this.state != null) {
            this.lineDirective();
        }
    }

    @Override
    public List<ConstantDefinition> getConstantDefinitions() throws GlueGenException {
        return new ArrayList<ConstantDefinition>();
    }

    private void initTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(45, 46);
        streamTokenizer.wordChars(128, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
    }

    @Override
    public String findFile(String string) {
        String string2 = File.separator;
        for (String string3 : this.includePaths) {
            String string4 = string3 + string2 + string;
            File file = new File(string4);
            if (!file.exists()) continue;
            return string4;
        }
        return null;
    }

    @Override
    public OutputStream out() {
        return this.out;
    }

    @Override
    public void setOut(OutputStream outputStream) {
        this.out = outputStream;
        this.writer = new PrintWriter(outputStream);
    }

    private int nextToken() throws IOException {
        return this.nextToken(false);
    }

    private int nextToken(boolean bl) throws IOException {
        int n = this.lineNumber();
        if (this.state.curToken() == 10) {
            this.state.setStartOfLine(true);
        } else if (!this.state.startOfFile()) {
            this.state.setStartOfLine(false);
        }
        this.state.setStartOfFile(false);
        int n2 = this.state.nextToken();
        if (!bl && n2 == 10) {
            do {
                n2 = this.state.nextToken();
                this.state.setStartOfLine(true);
                this.println();
            } while (n2 == 10);
        }
        if (this.lineNumber() > n + 1) {
            this.lineDirective();
        }
        return n2;
    }

    private void nextRequiredToken(int n) throws IOException {
        int n2 = this.nextToken();
        if (n2 != n) {
            String string = "Expected token '" + n + "' but got ";
            switch (n2) {
                case -1: {
                    string = string + "<EOF>";
                    break;
                }
                case 10: {
                    string = string + "<EOL>";
                    break;
                }
                default: {
                    string = string + "'" + this.curTokenAsString() + "'";
                }
            }
            string = string + " at file " + this.filename() + ", line " + this.lineNumber();
            throw new IOException(string);
        }
    }

    private String curTokenAsString() {
        int n = this.state.curToken();
        if (n == -3) {
            return this.state.curWord();
        }
        if (n == 10) {
            throw new RuntimeException("Should not be converting EOL characters to strings at file " + this.filename() + ", line " + this.lineNumber());
        }
        char c = (char)n;
        if (c == '\"' || c == '\'') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(c);
            stringBuilder.append(this.state.curWord());
            stringBuilder.append(c);
            return stringBuilder.toString();
        }
        return new String(new char[]{c});
    }

    private String nextWordOrString() throws IOException {
        this.nextToken();
        return this.curTokenAsString();
    }

    private String nextWord() throws IOException {
        int n = this.nextToken();
        if (n != -3) {
            throw new RuntimeException("Expected word at file " + this.filename() + ", line " + this.lineNumber());
        }
        return this.state.curWord();
    }

    private boolean startOfLine() {
        return this.state.startOfLine();
    }

    private String filename() {
        return null != this.state ? this.state.filename() : null;
    }

    private int lineNumber() {
        return null != this.state ? this.state.lineNumber() : -1;
    }

    private void parse() throws IOException {
        int n = 0;
        while ((n = this.nextToken()) != -1) {
            Macro macro;
            String string;
            String string2;
            if (this.startOfLine() && n == 35) {
                this.preprocessorDirective();
                continue;
            }
            if (n == -3) {
                this.print(" ");
            }
            if ((string2 = this.defineMap.get(string = this.curTokenAsString())) == null) {
                string2 = string;
            }
            if ((macro = this.macroMap.get(string2)) != null) {
                String string3;
                string2 = "";
                ArrayList<String> arrayList = new ArrayList<String>();
                while (this.nextToken() != 10 && !")".equals(string3 = this.curTokenAsString())) {
                    if (",".equals(string3) || "(".equals(string3)) continue;
                    arrayList.add(string3);
                }
                for (int i = 0; i < macro.values.size(); ++i) {
                    String string4 = (String)macro.values.get(i);
                    for (int j = 0; j < macro.params.size(); ++j) {
                        String string5 = (String)macro.params.get(j);
                        if (!string5.equals(string4)) continue;
                        string4 = (String)arrayList.get(j);
                        break;
                    }
                    if (ConstantDefinition.isIdentifier(string4)) {
                        string2 = string2 + " ";
                    }
                    string2 = string2 + string4;
                }
            }
            this.print(string2);
        }
        this.flush();
    }

    private void preprocessorDirective() throws IOException {
        String string = this.nextWord();
        boolean bl = true;
        if (string.equals("warning")) {
            this.handleWarning();
            bl = false;
        } else if (string.equals("error")) {
            this.handleError();
            bl = false;
        } else if (string.equals("define")) {
            this.handleDefine();
            bl = false;
        } else if (string.equals("undef")) {
            this.handleUndefine();
            bl = false;
        } else if (string.equals("if") || string.equals("elif")) {
            this.handleIf(string.equals("if"));
            bl = false;
        } else if (string.equals("ifdef") || string.equals("ifndef")) {
            this.handleIfdef(string.equals("ifdef"));
            bl = false;
        } else if (string.equals("else")) {
            this.handleElse();
            bl = false;
        } else if (string.equals("endif")) {
            this.handleEndif();
            bl = false;
        } else if (string.equals("include")) {
            this.handleInclude();
            bl = false;
        } else {
            int n = -1;
            try {
                n = Integer.parseInt(string);
                String string2 = this.nextWordOrString();
                this.print("# " + n + " " + string2);
                this.println();
                bl = false;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (bl) {
            this.print("# ");
            this.printToken();
        }
    }

    private void handleUndefine() throws IOException {
        String string = this.nextWord();
        this.debugPrint(true, "UNDEF " + string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (this.nextToken(true) != 10) {
            arrayList.add(this.curTokenAsString());
        }
        if (this.enabled()) {
            String string2 = this.defineMap.remove(string);
            if (string2 == null) {
                this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, string), "ignoring redundant \"#undef {0}\" - was not previously defined", (Object)string);
            }
            this.nonConstantDefines.remove(string);
        } else {
            this.LOG.log(Level.INFO, new ASTLocusTag(this.filename(), this.lineNumber(), -1, string), "DISABLED UNDEFINE: ''{0}''", (Object)string);
        }
    }

    private void handleWarning() throws IOException {
        String string = this.nextWordOrString();
        if (this.enabled()) {
            this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), string);
        }
    }

    private void handleError() throws IOException, GlueGenException {
        String string = this.nextWordOrString();
        if (this.enabled()) {
            throw new GlueGenException(string, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null));
        }
    }

    private void handleDefine() throws IOException {
        this.state.tok.wordChars(40, 40);
        String string = this.nextWord();
        boolean bl = string.contains("(");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            int n = string.indexOf(40);
            String string2 = string.substring(n + 1);
            string = string.substring(0, n);
            arrayList.add("(");
            arrayList.add(string2);
        }
        this.state.tok.ordinaryChar(40);
        while (this.nextToken(true) != 10) {
            arrayList.add(this.curTokenAsString());
        }
        this.addDefine(string, bl, arrayList);
    }

    @Override
    public void addDefine(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.addDefine(string, false, arrayList);
    }

    /*
     * WARNING - void declaration
     */
    private void addDefine(String string, boolean bl, List<String> list) {
        this.debugPrint(true, "DEFINE " + string);
        if (this.enabled()) {
            boolean bl2 = true;
            int n = list.size();
            if (n == 0) {
                String object4 = this.defineMap.put(string, "");
                if (object4 != null && !object4.equals("")) {
                    this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), "\"{0}\" redefined from \"{1}\" to \"\"", string, object4);
                }
                bl2 = false;
            } else if (n == 1) {
                String string2 = list.get(0);
                if (ConstantDefinition.isNumber(string2)) {
                    String i = this.defineMap.put(string, string2);
                    if (i != null && !i.equals(string2)) {
                        this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), "\"{0}\" redefined from \"{1}\" to \"{2}\"", string, i, string2);
                    }
                    this.debugPrint(true, "DEFINE " + string + " [" + i + " ] -> " + string2 + " CONST");
                } else {
                    String string3 = this.resolveDefine(string2, true);
                    this.debugPrint(true, "DEFINE " + string + " -> " + string2 + " -> <" + string3 + "> SYMB");
                    if (string3 != null) {
                        boolean bl3 = string3.contains("(");
                        if (bl3) {
                            bl2 = false;
                        } else {
                            list.set(0, string3);
                        }
                    } else {
                        this.defineMap.put(string, string2);
                        this.nonConstantDefines.add(string);
                        bl2 = false;
                    }
                }
            } else if (bl) {
                Macro macro;
                Macro macro2;
                void var7_11;
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl4 = true;
                while (var7_11 < list.size()) {
                    String string4 = list.get((int)var7_11);
                    if (")".equals(string4)) {
                        if (var7_11 != list.size() - 1) {
                            list = list.subList((int)(var7_11 + true), list.size());
                            break;
                        }
                        list = Collections.emptyList();
                        break;
                    }
                    if (!",".equals(string4)) {
                        arrayList.add(string4);
                    }
                    ++var7_11;
                }
                if ((macro2 = this.macroMap.put(string, macro = new Macro(arrayList, list))) != null) {
                    this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), "\"{0}\" redefined from \"{1}\" to \"{2}\"", string, macro2, macro);
                }
                bl2 = false;
            } else {
                boolean bl5 = false;
                for (String string5 : list) {
                    if (!ConstantDefinition.isIdentifier(string5)) continue;
                    bl5 = true;
                    break;
                }
                if (bl5) {
                    void var8_28;
                    bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl6 = false;
                    while (var8_28 < n) {
                        if (var8_28 != false) {
                            stringBuilder.append(" ");
                        }
                        stringBuilder.append(this.resolveDefine(list.get((int)var8_28), false));
                        ++var8_28;
                    }
                    if (this.defineMap.get(string) != null) {
                        throw new RuntimeException("Cannot redefine symbol \"" + string + " from \"" + this.defineMap.get(string) + "\" to non-constant  definition \"" + stringBuilder.toString() + "\" at file \"" + this.filename() + ", line " + this.lineNumber());
                    }
                    this.defineMap.put(string, stringBuilder.toString());
                    this.nonConstantDefines.add(string);
                } else {
                    String string62;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string62 : list) {
                        stringBuilder.append(string62);
                    }
                    String string7 = stringBuilder.toString();
                    string62 = this.defineMap.put(string, string7);
                    if (string62 != null && !string62.equals(string7)) {
                        this.LOG.log(Level.WARNING, new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), "\"{0}\" redefined from \"{1}\" to \"{2}\"", string, string62, string7);
                    }
                    this.debugPrint(true, "DEFINE " + string + " [" + string62 + " ] -> " + string7 + " CONST");
                }
            }
            if (bl2) {
                this.print("# define ");
                this.print(string);
                this.print(" ");
                for (String string8 : list) {
                    this.print(string8);
                }
                this.println();
            }
        }
    }

    private String resolveDefine(String string, boolean bl) {
        String string2 = this.defineMap.get(string);
        if (string2 == null) {
            if (bl) {
                return null;
            }
            return string;
        }
        String string3 = null;
        do {
            if ((string3 = this.defineMap.get(string2)) == null) continue;
            string2 = string3;
        } while (string3 != null);
        return string2;
    }

    private void handleIfdef(boolean bl) throws IOException {
        String string = this.nextWord();
        boolean bl2 = this.enabled();
        boolean bl3 = this.defineMap.get(string) != null;
        this.debugPrint(false, (bl ? "IFDEF " : "IFNDEF ") + string + ", enabledOutside " + bl2 + ", isDefined " + bl3 + ", file \"" + this.filename() + " line " + this.lineNumber());
        boolean bl4 = this.enabled() && bl3 == bl;
        this.pushEnableBit(bl4);
        this.pushEnableBit(bl4);
    }

    private void handleElse() throws IOException {
        this.popEnableBit();
        boolean bl = this.enabled();
        this.popEnableBit();
        boolean bl2 = this.enabled();
        this.debugPrint(false, "ELSE, enabledOutside " + bl2 + ", file \"" + this.filename() + " line " + this.lineNumber());
        this.pushEnableBit(bl2 && !bl);
        this.pushEnableBit(bl2 && !bl);
    }

    private void handleEndif() {
        this.popEnableBit();
        this.popEnableBit();
        boolean bl = this.enabled();
        this.debugPrint(false, "ENDIF, enabledOutside " + bl);
    }

    private void handleIf(boolean bl) throws IOException {
        boolean bl2 = false;
        if (!bl) {
            this.popEnableBit();
            bl2 = this.enabled();
            this.popEnableBit();
        }
        boolean bl3 = this.enabled();
        boolean bl4 = this.handleIfRecursive(true);
        this.debugPrint(false, (bl ? "IF" : "ELIF") + ", enabledOutside " + bl3 + ", eval " + bl4 + ", file \"" + this.filename() + " line " + this.lineNumber());
        if (bl) {
            boolean bl5 = bl3 && bl4;
            this.pushEnableBit(bl5);
            this.pushEnableBit(bl5);
        } else {
            boolean bl6 = bl3 && !bl2 && bl4;
            this.pushEnableBit(bl2 || bl6);
            this.pushEnableBit(bl6);
        }
    }

    private boolean handleIfRecursive(boolean bl) throws IOException {
        int n;
        boolean bl2 = true;
        int n2 = 0;
        do {
            n = this.nextToken(true);
            switch (n) {
                case 40: {
                    ++n2;
                    bl2 = bl2 && this.handleIfRecursive(true);
                    break;
                }
                case 41: {
                    --n2;
                    break;
                }
                case 33: {
                    boolean bl3 = this.handleIfRecursive(false);
                    bl2 = !bl3;
                    break;
                }
                case 38: {
                    this.nextRequiredToken(38);
                    boolean bl4 = this.handleIfRecursive(true);
                    bl2 = bl2 && bl4;
                    break;
                }
                case 124: {
                    this.nextRequiredToken(124);
                    boolean bl5 = this.handleIfRecursive(true);
                    bl2 = bl2 || bl5;
                    break;
                }
                case 62: {
                    boolean bl6 = this.handleIfRecursive(true);
                    bl2 = false;
                    break;
                }
                case 60: {
                    boolean bl7 = this.handleIfRecursive(true);
                    bl2 = false;
                    break;
                }
                case 42: {
                    boolean bl8 = this.handleIfRecursive(false);
                    bl2 = false;
                    break;
                }
                case 43: {
                    boolean bl9 = this.handleIfRecursive(false);
                    bl2 = false;
                    break;
                }
                case 45: {
                    boolean bl10 = this.handleIfRecursive(false);
                    bl2 = false;
                    break;
                }
                case 61: {
                    boolean bl11 = this.handleIfRecursive(true);
                    bl2 = false;
                    break;
                }
                case -3: {
                    String string;
                    String string2 = this.curTokenAsString();
                    if (string2.equals("defined")) {
                        this.nextRequiredToken(40);
                        string = this.nextWord();
                        boolean bl12 = this.defineMap.get(string) != null;
                        bl2 = bl2 && bl12;
                        this.nextRequiredToken(41);
                        break;
                    }
                    string = this.defineMap.get(string2);
                    if (string != null) {
                        return !this.nonConstantDefines.contains(string2);
                    }
                    try {
                        return Double.parseDouble(string2) != 0.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            return Long.parseLong(string2) != 0L;
                        }
                        catch (NumberFormatException numberFormatException2) {
                            return Boolean.valueOf(string2);
                        }
                    }
                }
                case 10: {
                    this.state.pushBackToken();
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unexpected end of file while parsing #if statement at file " + this.filename() + ", line " + this.lineNumber());
                }
                default: {
                    throw new RuntimeException("Unexpected token (" + this.curTokenAsString() + ") while parsing #if statement at file " + this.filename() + ", line " + this.lineNumber());
                }
            }
        } while (bl && n2 >= 0 && n != 10);
        return bl2;
    }

    private void handleInclude() throws IOException {
        CharSequence charSequence;
        int n = this.nextToken();
        String string = null;
        if (n == 34) {
            string = this.state.curWord();
        } else if (n == 60) {
            charSequence = new StringBuilder();
            while ((n = this.nextToken()) != 62 && n != -1) {
                charSequence.append(this.curTokenAsString());
            }
            if (n == -1) {
                this.LOG.warning(new ASTLocusTag(this.filename(), this.lineNumber(), -1, null), "unexpected EOF while processing #include directive");
            }
            string = charSequence.toString();
        }
        this.debugPrint(true, "INCLUDE [" + string + "]");
        if (this.enabled()) {
            charSequence = this.findFile(string);
            if (charSequence == null) {
                throw new RuntimeException("Can't find #include file \"" + string + "\" at file " + this.filename() + ", line " + this.lineNumber());
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader((String)charSequence));
            this.run(bufferedReader, (String)charSequence);
        }
    }

    private void debugPrint(boolean bl, String string) {
        if (!this.enableDebugPrint) {
            return;
        }
        if (!bl || bl && this.enabled()) {
            int n = debugPrintIndentLevel;
            while (--n > 0) {
                System.err.print("  ");
            }
            System.err.println("STATE: " + string + "  (line " + this.lineNumber() + " file " + this.filename() + ")");
            System.err.flush();
        }
    }

    private void pushEnableBit(boolean bl) {
        this.enabledBits.add(bl);
        ++debugPrintIndentLevel;
        this.debugPrint(false, "PUSH_ENABLED, NOW: " + this.enabled());
    }

    private void popEnableBit() {
        if (this.enabledBits.isEmpty()) {
            throw new RuntimeException("mismatched #ifdef/endif pairs at file " + this.filename() + ", line " + this.lineNumber());
        }
        this.enabledBits.remove(this.enabledBits.size() - 1);
        --debugPrintIndentLevel;
        this.debugPrint(false, "POP_ENABLED, NOW: " + this.enabled());
    }

    private boolean enabled() {
        return this.enabledBits.isEmpty() || this.enabledBits.get(this.enabledBits.size() - 1) != false;
    }

    private void print(String string) {
        if (this.enabled()) {
            this.writer.print(string);
            if (this.enableCopyOutput2Stderr) {
                System.err.print(string);
                System.err.flush();
                return;
            }
        }
    }

    private void print(char c) {
        if (this.enabled()) {
            this.writer.print(c);
            if (this.enableCopyOutput2Stderr) {
                System.err.print(c);
                System.err.flush();
                return;
            }
        }
    }

    private void println() {
        if (this.enabled()) {
            this.writer.println();
            if (this.enableCopyOutput2Stderr) {
                System.err.println();
                System.err.flush();
                return;
            }
        }
    }

    private void printToken() {
        this.print(this.curTokenAsString());
    }

    private void flush() {
        if (this.enabled()) {
            this.writer.flush();
            if (this.enableCopyOutput2Stderr) {
                System.err.flush();
                return;
            }
        }
    }

    private void lineDirective() {
        this.print("# " + this.lineNumber() + " \"" + this.filename() + "\"");
        this.println();
    }

    private static void usage() {
        System.err.println("Usage: java PCPP [filename | -]");
        System.err.println("Minimal pseudo-C-preprocessor.");
        System.err.println("Output goes to standard output. Standard input can be used as input");
        System.err.println("by passing '-' as the argument.");
        System.err.println("  --debug enables debug mode");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        Reader reader = null;
        String string = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            PCPP.usage();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (i < stringArray.length - 1) {
                string2 = stringArray[i];
                if (string2.startsWith("-I")) {
                    String[] stringArray2 = string2.substring(2).split(System.getProperty("path.separator"));
                    for (int j = 0; j < stringArray2.length; ++j) {
                        arrayList.add(stringArray2[j]);
                    }
                    continue;
                }
                if (string2.equals("--debug")) {
                    bl = true;
                    continue;
                }
                PCPP.usage();
                continue;
            }
            string2 = stringArray[i];
            if (string2.equals("-")) {
                reader = new InputStreamReader(System.in);
                string = "standard input";
                continue;
            }
            if (string2.startsWith("-")) {
                PCPP.usage();
            }
            string = string2;
            reader = new BufferedReader(new FileReader(string));
        }
        new PCPP(arrayList, bl, bl).run(reader, string);
    }

    private static class Macro {
        private final List<String> values;
        private final List<String> params;

        Macro(List<String> list, List<String> list2) {
            this.values = list2;
            this.params = list;
        }

        public String toString() {
            return "params: " + this.params + " values: " + this.values;
        }
    }

    static class ParseState {
        private final StreamTokenizer tok;
        private final String filename;
        private boolean startOfLine;
        private boolean startOfFile;

        ParseState(StreamTokenizer streamTokenizer, String string) {
            this.tok = streamTokenizer;
            this.filename = string;
            this.startOfLine = true;
            this.startOfFile = true;
        }

        void pushBackToken() throws IOException {
            this.tok.pushBack();
        }

        int curToken() {
            return this.tok.ttype;
        }

        int nextToken() throws IOException {
            return this.tok.nextToken();
        }

        String curWord() {
            return this.tok.sval;
        }

        String filename() {
            return this.filename;
        }

        int lineNumber() {
            return this.tok.lineno();
        }

        boolean startOfLine() {
            return this.startOfLine;
        }

        void setStartOfLine(boolean bl) {
            this.startOfLine = bl;
        }

        boolean startOfFile() {
            return this.startOfFile;
        }

        void setStartOfFile(boolean bl) {
            this.startOfFile = bl;
        }
    }
}

