/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

public class CLException
extends RuntimeException {
    private static final long serialVersionUID = 6573520735486076436L;
    public final int errorcode;
    public final String error;

    public CLException(String message) {
        super(message);
        this.errorcode = 0;
        this.error = "none";
    }

    private CLException(int errorcode, String errorStr, String message) {
        super(message + " [error: " + errorStr + "]");
        this.error = errorStr;
        this.errorcode = errorcode;
    }

    public static void checkForError(int status, String message) {
        if (status != 0) {
            CLException ex = CLException.newException(status, message);
            ex.fillInStackTrace();
            throw ex;
        }
    }

    public static CLException newException(int status, String message) {
        CLException specificEx = CLException.createSpecificException(status, message);
        if (specificEx != null) {
            specificEx.fillInStackTrace();
            return specificEx;
        }
        return new CLException(status, "unknown", "unknown cause: code " + status);
    }

    public String getCLErrorString() {
        return this.error;
    }

    public static String resolveErrorCode(int error) {
        switch (error) {
            case -1: {
                return "CL_DEVICE_NOT_FOUND";
            }
            case -2: {
                return "CL_DEVICE_NOT_AVAILABLE";
            }
            case -3: {
                return "CL_COMPILER_NOT_AVAILABLE";
            }
            case -4: {
                return "CL_MEM_OBJECT_ALLOCATION_FAILURE";
            }
            case -5: {
                return "CL_OUT_OF_RESOURCES";
            }
            case -6: {
                return "CL_OUT_OF_HOST_MEMORY";
            }
            case -7: {
                return "CL_PROFILING_INFO_NOT_AVAILABLE";
            }
            case -8: {
                return "CL_MEM_COPY_OVERLAP";
            }
            case -9: {
                return "CL_IMAGE_FORMAT_MISMATCH";
            }
            case -10: {
                return "CL_IMAGE_FORMAT_NOT_SUPPORTED";
            }
            case -11: {
                return "CL_BUILD_PROGRAM_FAILURE";
            }
            case -12: {
                return "CL_MAP_FAILURE";
            }
            case -30: {
                return "CL_INVALID_VALUE";
            }
            case -31: {
                return "CL_INVALID_DEVICE_TYPE";
            }
            case -32: {
                return "CL_INVALID_PLATFORM";
            }
            case -33: {
                return "CL_INVALID_DEVICE";
            }
            case -34: {
                return "CL_INVALID_CONTEXT";
            }
            case -35: {
                return "CL_INVALID_QUEUE_PROPERTIES";
            }
            case -36: {
                return "CL_INVALID_COMMAND_QUEUE";
            }
            case -37: {
                return "CL_INVALID_HOST_PTR";
            }
            case -38: {
                return "CL_INVALID_MEM_OBJECT";
            }
            case -39: {
                return "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR";
            }
            case -40: {
                return "CL_INVALID_IMAGE_SIZE";
            }
            case -41: {
                return "CL_INVALID_SAMPLER";
            }
            case -42: {
                return "CL_INVALID_BINARY";
            }
            case -43: {
                return "CL_INVALID_BUILD_OPTIONS";
            }
            case -44: {
                return "CL_INVALID_PROGRAM";
            }
            case -45: {
                return "CL_INVALID_PROGRAM_EXECUTABLE";
            }
            case -46: {
                return "CL_INVALID_KERNEL_NAME";
            }
            case -47: {
                return "CL_INVALID_KERNEL_DEFINITION";
            }
            case -48: {
                return "CL_INVALID_KERNEL";
            }
            case -49: {
                return "CL_INVALID_ARG_INDEX";
            }
            case -50: {
                return "CL_INVALID_ARG_VALUE";
            }
            case -51: {
                return "CL_INVALID_ARG_SIZE";
            }
            case -52: {
                return "CL_INVALID_KERNEL_ARGS";
            }
            case -53: {
                return "CL_INVALID_WORK_DIMENSION";
            }
            case -54: {
                return "CL_INVALID_WORK_GROUP_SIZE";
            }
            case -55: {
                return "CL_INVALID_WORK_ITEM_SIZE";
            }
            case -56: {
                return "CL_INVALID_GLOBAL_OFFSET";
            }
            case -57: {
                return "CL_INVALID_EVENT_WAIT_LIST";
            }
            case -58: {
                return "CL_INVALID_EVENT";
            }
            case -59: {
                return "CL_INVALID_OPERATION";
            }
            case -61: {
                return "CL_INVALID_BUFFER_SIZE";
            }
            case -62: {
                return "CL_INVALID_MIP_LEVEL";
            }
            case -63: {
                return "CL_INVALID_GLOBAL_WORK_SIZE";
            }
            case -64: {
                return "CL_INVALID_PROPERTY";
            }
            case -1001: {
                return "CL_PLATFORM_NOT_FOUND_KHR";
            }
            case -13: {
                return "CL_MISALIGNED_SUB_BUFFER_OFFSET";
            }
            case -14: {
                return "CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST";
            }
            case -60: {
                return "CL_INVALID_GL_OBJECT";
            }
            case -1000: {
                return "CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR";
            }
        }
        return null;
    }

    private static CLException createSpecificException(int error, String message) {
        switch (error) {
            case -1: {
                return new CLDeviceNotFoundException(message);
            }
            case -2: {
                return new CLDeviceNotAvailableException(message);
            }
            case -3: {
                return new CLCompilerNotAvailableException(message);
            }
            case -4: {
                return new CLMemObjectAllocationFailureException(message);
            }
            case -5: {
                return new CLOutOfResourcesException(message);
            }
            case -6: {
                return new CLOutOfHostMemoryException(message);
            }
            case -7: {
                return new CLProfilingInfoNotAvailableException(message);
            }
            case -8: {
                return new CLMemCopyOverlapException(message);
            }
            case -9: {
                return new CLImageFormatMismatchException(message);
            }
            case -10: {
                return new CLImageFormatNotSupportedException(message);
            }
            case -11: {
                return new CLBuildProgramFailureException(message);
            }
            case -12: {
                return new CLMapFailureException(message);
            }
            case -30: {
                return new CLInvalidValueException(message);
            }
            case -31: {
                return new CLInvalidDeviceTypeException(message);
            }
            case -32: {
                return new CLInvalidPlatformException(message);
            }
            case -33: {
                return new CLInvalidDeviceException(message);
            }
            case -34: {
                return new CLInvalidContextException(message);
            }
            case -35: {
                return new CLInvalidQueuePropertiesException(message);
            }
            case -36: {
                return new CLInvalidCommandQueueException(message);
            }
            case -37: {
                return new CLInvalidHostPtrException(message);
            }
            case -38: {
                return new CLInvalidMemObjectException(message);
            }
            case -39: {
                return new CLInvalidImageFormatDescriptorException(message);
            }
            case -40: {
                return new CLInvalidImageSizeException(message);
            }
            case -41: {
                return new CLInvalidSamplerException(message);
            }
            case -42: {
                return new CLInvalidBinaryException(message);
            }
            case -43: {
                return new CLInvalidBuildOptionsException(message);
            }
            case -44: {
                return new CLInvalidProgramException(message);
            }
            case -45: {
                return new CLInvalidProgramExecutableException(message);
            }
            case -46: {
                return new CLInvalidKernelNameException(message);
            }
            case -47: {
                return new CLInvalidKernelDefinitionException(message);
            }
            case -48: {
                return new CLInvalidKernelException(message);
            }
            case -49: {
                return new CLInvalidArgIndexException(message);
            }
            case -50: {
                return new CLInvalidArgValueException(message);
            }
            case -51: {
                return new CLInvalidArgSizeException(message);
            }
            case -52: {
                return new CLInvalidKernelArgsException(message);
            }
            case -53: {
                return new CLInvalidWorkDimensionException(message);
            }
            case -54: {
                return new CLInvalidWorkGroupSizeException(message);
            }
            case -55: {
                return new CLInvalidWorkItemSizeException(message);
            }
            case -56: {
                return new CLInvalidGlobalOffsetException(message);
            }
            case -57: {
                return new CLInvalidEventWaitListException(message);
            }
            case -58: {
                return new CLInvalidEventException(message);
            }
            case -59: {
                return new CLInvalidOperationException(message);
            }
            case -61: {
                return new CLInvalidBufferSizeException(message);
            }
            case -62: {
                return new CLInvalidMipLevelException(message);
            }
            case -63: {
                return new CLInvalidGlobalWorkSizeException(message);
            }
            case -64: {
                return new CLInvalidPropertyException(message);
            }
            case -1001: {
                return new CLPlatformNotFoundKhrException(message);
            }
            case -13: {
                return new CLMisalignedSubBufferOffsetException(message);
            }
            case -14: {
                return new CLExecStatusErrorForEventsInWaitListException(message);
            }
            case -60: {
                return new CLInvalidGLObjectException(message);
            }
            case -1000: {
                return new CLInvalidGLSharegroupReferenceKhrException(message);
            }
        }
        return null;
    }

    public static final class CLExecStatusErrorForEventsInWaitListException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076422L;

        public CLExecStatusErrorForEventsInWaitListException(String message) {
            super(-14, "CL_EXEC_STATUS_ERROR_FOR_EVENTS_IN_WAIT_LIST", message);
        }
    }

    public static final class CLMisalignedSubBufferOffsetException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076423L;

        public CLMisalignedSubBufferOffsetException(String message) {
            super(-13, "CL_MISALIGNED_SUB_BUFFER_OFFSET", message);
        }
    }

    public static final class CLPlatformNotFoundKhrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486075435L;

        public CLPlatformNotFoundKhrException(String message) {
            super(-1001, "CL_PLATFORM_NOT_FOUND_KHR", message);
        }
    }

    public static final class CLInvalidGLSharegroupReferenceKhrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486075436L;

        public CLInvalidGLSharegroupReferenceKhrException(String message) {
            super(-1000, "CL_INVALID_GL_SHAREGROUP_REFERENCE_KHR", message);
        }
    }

    public static final class CLInvalidPropertyException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076372L;

        public CLInvalidPropertyException(String message) {
            super(-64, "CL_INVALID_PROPERTY", message);
        }
    }

    public static final class CLInvalidGlobalWorkSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076373L;

        public CLInvalidGlobalWorkSizeException(String message) {
            super(-63, "CL_INVALID_GLOBAL_WORK_SIZE", message);
        }
    }

    public static final class CLInvalidMipLevelException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076374L;

        public CLInvalidMipLevelException(String message) {
            super(-62, "CL_INVALID_MIP_LEVEL", message);
        }
    }

    public static final class CLInvalidBufferSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076375L;

        public CLInvalidBufferSizeException(String message) {
            super(-61, "CL_INVALID_BUFFER_SIZE", message);
        }
    }

    public static final class CLInvalidGLObjectException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076376L;

        public CLInvalidGLObjectException(String message) {
            super(-60, "CL_INVALID_GL_OBJECT", message);
        }
    }

    public static final class CLInvalidOperationException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076377L;

        public CLInvalidOperationException(String message) {
            super(-59, "CL_INVALID_OPERATION", message);
        }
    }

    public static final class CLInvalidEventException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076378L;

        public CLInvalidEventException(String message) {
            super(-58, "CL_INVALID_EVENT", message);
        }
    }

    public static final class CLInvalidEventWaitListException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076379L;

        public CLInvalidEventWaitListException(String message) {
            super(-57, "CL_INVALID_EVENT_WAIT_LIST", message);
        }
    }

    public static final class CLInvalidGlobalOffsetException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076380L;

        public CLInvalidGlobalOffsetException(String message) {
            super(-56, "CL_INVALID_GLOBAL_OFFSET", message);
        }
    }

    public static final class CLInvalidWorkItemSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076381L;

        public CLInvalidWorkItemSizeException(String message) {
            super(-55, "CL_INVALID_WORK_ITEM_SIZE", message);
        }
    }

    public static final class CLInvalidWorkGroupSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076382L;

        public CLInvalidWorkGroupSizeException(String message) {
            super(-54, "CL_INVALID_WORK_GROUP_SIZE", message);
        }
    }

    public static final class CLInvalidWorkDimensionException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076383L;

        public CLInvalidWorkDimensionException(String message) {
            super(-53, "CL_INVALID_WORK_DIMENSION", message);
        }
    }

    public static final class CLInvalidKernelArgsException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076384L;

        public CLInvalidKernelArgsException(String message) {
            super(-52, "CL_INVALID_KERNEL_ARGS", message);
        }
    }

    public static final class CLInvalidArgSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076385L;

        public CLInvalidArgSizeException(String message) {
            super(-51, "CL_INVALID_ARG_SIZE", message);
        }
    }

    public static final class CLInvalidArgValueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076386L;

        public CLInvalidArgValueException(String message) {
            super(-50, "CL_INVALID_ARG_VALUE", message);
        }
    }

    public static final class CLInvalidArgIndexException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076387L;

        public CLInvalidArgIndexException(String message) {
            super(-49, "CL_INVALID_ARG_INDEX", message);
        }
    }

    public static final class CLInvalidKernelException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076388L;

        public CLInvalidKernelException(String message) {
            super(-48, "CL_INVALID_KERNEL", message);
        }
    }

    public static final class CLInvalidKernelDefinitionException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076389L;

        public CLInvalidKernelDefinitionException(String message) {
            super(-47, "CL_INVALID_KERNEL_DEFINITION", message);
        }
    }

    public static final class CLInvalidKernelNameException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076390L;

        public CLInvalidKernelNameException(String message) {
            super(-46, "CL_INVALID_KERNEL_NAME", message);
        }
    }

    public static final class CLInvalidProgramExecutableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076391L;

        public CLInvalidProgramExecutableException(String message) {
            super(-45, "CL_INVALID_PROGRAM_EXECUTABLE", message);
        }
    }

    public static final class CLInvalidProgramException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076392L;

        public CLInvalidProgramException(String message) {
            super(-44, "CL_INVALID_PROGRAM", message);
        }
    }

    public static final class CLInvalidBuildOptionsException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076393L;

        public CLInvalidBuildOptionsException(String message) {
            super(-43, "CL_INVALID_BUILD_OPTIONS", message);
        }
    }

    public static final class CLInvalidBinaryException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076394L;

        public CLInvalidBinaryException(String message) {
            super(-42, "CL_INVALID_BINARY", message);
        }
    }

    public static final class CLInvalidSamplerException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076395L;

        public CLInvalidSamplerException(String message) {
            super(-41, "CL_INVALID_SAMPLER", message);
        }
    }

    public static final class CLInvalidImageSizeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076396L;

        public CLInvalidImageSizeException(String message) {
            super(-40, "CL_INVALID_IMAGE_SIZE", message);
        }
    }

    public static final class CLInvalidImageFormatDescriptorException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076397L;

        public CLInvalidImageFormatDescriptorException(String message) {
            super(-39, "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR", message);
        }
    }

    public static final class CLInvalidMemObjectException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076398L;

        public CLInvalidMemObjectException(String message) {
            super(-38, "CL_INVALID_MEM_OBJECT", message);
        }
    }

    public static final class CLInvalidHostPtrException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076399L;

        public CLInvalidHostPtrException(String message) {
            super(-37, "CL_INVALID_HOST_PTR", message);
        }
    }

    public static final class CLInvalidCommandQueueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076400L;

        public CLInvalidCommandQueueException(String message) {
            super(-36, "CL_INVALID_COMMAND_QUEUE", message);
        }
    }

    public static final class CLInvalidQueuePropertiesException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076401L;

        public CLInvalidQueuePropertiesException(String message) {
            super(-35, "CL_INVALID_QUEUE_PROPERTIES", message);
        }
    }

    public static final class CLInvalidContextException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076402L;

        public CLInvalidContextException(String message) {
            super(-34, "CL_INVALID_CONTEXT", message);
        }
    }

    public static final class CLInvalidDeviceException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076403L;

        public CLInvalidDeviceException(String message) {
            super(-33, "CL_INVALID_DEVICE", message);
        }
    }

    public static final class CLInvalidPlatformException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076404L;

        public CLInvalidPlatformException(String message) {
            super(-32, "CL_INVALID_PLATFORM", message);
        }
    }

    public static final class CLInvalidDeviceTypeException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076405L;

        public CLInvalidDeviceTypeException(String message) {
            super(-31, "CL_INVALID_DEVICE_TYPE", message);
        }
    }

    public static final class CLInvalidValueException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076406L;

        public CLInvalidValueException(String message) {
            super(-30, "CL_INVALID_VALUE", message);
        }
    }

    public static final class CLMapFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076424L;

        public CLMapFailureException(String message) {
            super(-12, "CL_MAP_FAILURE", message);
        }
    }

    public static final class CLBuildProgramFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076425L;

        public CLBuildProgramFailureException(String message) {
            super(-11, "CL_BUILD_PROGRAM_FAILURE", message);
        }
    }

    public static final class CLImageFormatNotSupportedException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076426L;

        public CLImageFormatNotSupportedException(String message) {
            super(-10, "CL_IMAGE_FORMAT_NOT_SUPPORTED", message);
        }
    }

    public static final class CLImageFormatMismatchException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076427L;

        public CLImageFormatMismatchException(String message) {
            super(-9, "CL_IMAGE_FORMAT_MISMATCH", message);
        }
    }

    public static final class CLMemCopyOverlapException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076428L;

        public CLMemCopyOverlapException(String message) {
            super(-8, "CL_MEM_COPY_OVERLAP", message);
        }
    }

    public static final class CLProfilingInfoNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076429L;

        public CLProfilingInfoNotAvailableException(String message) {
            super(-7, "CL_PROFILING_INFO_NOT_AVAILABLE", message);
        }
    }

    public static final class CLOutOfHostMemoryException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076430L;

        public CLOutOfHostMemoryException(String message) {
            super(-6, "CL_OUT_OF_HOST_MEMORY", message);
        }
    }

    public static final class CLOutOfResourcesException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076431L;

        public CLOutOfResourcesException(String message) {
            super(-5, "CL_OUT_OF_RESOURCES", message);
        }
    }

    public static final class CLMemObjectAllocationFailureException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076432L;

        public CLMemObjectAllocationFailureException(String message) {
            super(-4, "CL_MEM_OBJECT_ALLOCATION_FAILURE", message);
        }
    }

    public static final class CLCompilerNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076433L;

        public CLCompilerNotAvailableException(String message) {
            super(-3, "CL_COMPILER_NOT_AVAILABLE", message);
        }
    }

    public static final class CLDeviceNotAvailableException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076434L;

        public CLDeviceNotAvailableException(String message) {
            super(-2, "CL_DEVICE_NOT_AVAILABLE", message);
        }
    }

    public static final class CLDeviceNotFoundException
    extends CLException {
        private static final long serialVersionUID = 6573520735486076435L;

        public CLDeviceNotFoundException(String message) {
            super(-1, "CL_DEVICE_NOT_FOUND", message);
        }
    }
}

