/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLMemObjectListener;
import com.jogamp.opencl.CLObjectResource;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLMemObjectDestructorCallback;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.EnumSet;

public abstract class CLMemory<B extends Buffer>
extends CLObjectResource {
    B buffer;
    protected final int FLAGS;
    protected long size;
    protected int elementSize;
    protected int clCapacity;
    private final CL binding;

    protected <Buffer> CLMemory(CLContext context, long size, long id, int flags) {
        this(context, null, size, id, flags);
    }

    protected CLMemory(CLContext context, B directBuffer, long size, long id, int flags) {
        super(context, id);
        this.buffer = directBuffer;
        this.FLAGS = flags;
        this.size = size;
        this.binding = context.getPlatform().getCLBinding();
        this.initElementSize();
        this.initCLCapacity();
    }

    private void initElementSize() {
        this.elementSize = this.buffer == null ? 1 : Buffers.sizeOfBufferElem(this.buffer);
    }

    protected final void initCLCapacity() {
        this.clCapacity = (int)(this.size / (long)this.elementSize);
    }

    protected static boolean isHostPointerFlag(int flags) {
        return (flags & 0x20) != 0 || (flags & 8) != 0;
    }

    protected static long getSizeImpl(CLContext context, long id) {
        PointerBuffer pb = PointerBuffer.allocateDirect((int)1);
        CL binding = context.getPlatform().getCLBinding();
        int ret = binding.clGetMemObjectInfo(id, 4354, pb.elementSize(), pb.getBuffer(), null);
        CLException.checkForError(ret, "can not obtain buffer info");
        return pb.get();
    }

    protected static CL getCL(CLContext context) {
        return context.getCL();
    }

    public void registerDestructorCallback(final CLMemObjectListener listener) {
        this.binding.clSetMemObjectDestructorCallback(this.ID, new CLMemObjectDestructorCallback(){

            @Override
            public void memoryDeallocated(long memObjID) {
                listener.memoryDeallocated(CLMemory.this);
            }
        });
    }

    public abstract <T extends Buffer> CLMemory<T> cloneWith(T var1);

    public CLMemory<B> use(B buffer) {
        if (this.buffer != null && buffer != null && this.buffer.getClass() != buffer.getClass()) {
            throw new IllegalArgumentException("expected a Buffer of class " + this.buffer.getClass() + " but got " + buffer.getClass());
        }
        this.buffer = buffer;
        this.initElementSize();
        this.initCLCapacity();
        return this;
    }

    public B getBuffer() {
        return this.buffer;
    }

    public int getNIOCapacity() {
        if (this.buffer == null) {
            return 0;
        }
        return ((Buffer)this.buffer).capacity();
    }

    public int getNIOSize() {
        if (this.buffer == null) {
            return 0;
        }
        return this.getElementSize() * ((Buffer)this.buffer).capacity();
    }

    public long getCLSize() {
        return this.size;
    }

    public int getCLCapacity() {
        return this.clCapacity;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public EnumSet<Mem> getConfig() {
        return Mem.valuesOf(this.FLAGS);
    }

    public int getMapCount() {
        IntBuffer value = Buffers.newDirectIntBuffer((int)1);
        int ret = this.binding.clGetMemObjectInfo(this.ID, 4356, 4L, value, null);
        CLException.checkForError(ret, "can not obtain buffer map count.");
        return value.get();
    }

    public boolean isReadOnly() {
        return (Mem.READ_ONLY.CONFIG & this.FLAGS) != 0;
    }

    public boolean isWriteOnly() {
        return (Mem.WRITE_ONLY.CONFIG & this.FLAGS) != 0;
    }

    public boolean isReadWrite() {
        return (Mem.READ_WRITE.CONFIG & this.FLAGS) != 0;
    }

    @Override
    public void release() {
        super.release();
        int ret = this.binding.clReleaseMemObject(this.ID);
        this.context.onMemoryReleased(this);
        if (ret != 0) {
            throw CLException.newException(ret, "can not release " + this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLMemory other = (CLMemory)obj;
        if (this.ID != other.ID) {
            return false;
        }
        return this.context == other.context || this.context != null && this.context.equals(other.context);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(this.ID ^ this.ID >>> 32);
        hash = 83 * hash + (this.context != null ? this.context.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [id: " + this.ID + " buffer: " + this.buffer + "]";
    }

    public static enum GLObjectType {
        GL_OBJECT_BUFFER(8192),
        GL_OBJECT_TEXTURE2D(8193),
        GL_OBJECT_TEXTURE3D(8194),
        GL_OBJECT_RENDERBUFFER(8195);

        public final int TYPE;

        private GLObjectType(int type) {
            this.TYPE = type;
        }

        public static GLObjectType valueOf(int type) {
            if (type == 8192) {
                return GL_OBJECT_BUFFER;
            }
            if (type == 8193) {
                return GL_OBJECT_TEXTURE2D;
            }
            if (type == 8194) {
                return GL_OBJECT_TEXTURE3D;
            }
            if (type == 8195) {
                return GL_OBJECT_RENDERBUFFER;
            }
            return null;
        }
    }

    public static enum Map {
        READ_WRITE(3),
        WRITE(2),
        READ(1);

        public final int FLAGS;

        private Map(int flags) {
            this.FLAGS = flags;
        }

        public Map valueOf(int flag) {
            if (flag == Map.WRITE.FLAGS) {
                return WRITE;
            }
            if (flag == Map.READ.FLAGS) {
                return READ;
            }
            if (flag == Map.READ_WRITE.FLAGS) {
                return READ_WRITE;
            }
            return null;
        }
    }

    public static enum Mem {
        READ_WRITE(1),
        WRITE_ONLY(2),
        READ_ONLY(4),
        USE_BUFFER(8),
        ALLOCATE_BUFFER(16),
        COPY_BUFFER(32);

        public final int CONFIG;

        private Mem(int config) {
            this.CONFIG = config;
        }

        public static Mem valueOf(int bufferFlag) {
            switch (bufferFlag) {
                case 1: {
                    return READ_WRITE;
                }
                case 4: {
                    return READ_ONLY;
                }
                case 2: {
                    return WRITE_ONLY;
                }
                case 8: {
                    return USE_BUFFER;
                }
                case 16: {
                    return ALLOCATE_BUFFER;
                }
                case 32: {
                    return COPY_BUFFER;
                }
            }
            return null;
        }

        public static EnumSet<Mem> valuesOf(int bitfield) {
            Mem[] values;
            ArrayList<Mem> matching = new ArrayList<Mem>();
            for (Mem value : values = Mem.values()) {
                if ((value.CONFIG & bitfield) == 0) continue;
                matching.add(value);
            }
            if (matching.isEmpty()) {
                return EnumSet.noneOf(Mem.class);
            }
            return EnumSet.copyOf(matching);
        }

        public static int flagsToInt(Mem[] flags) {
            int clFlags = 0;
            if (flags != null) {
                for (int i = 0; i < flags.length; ++i) {
                    clFlags |= flags[i].CONFIG;
                }
            }
            if (clFlags == 0) {
                clFlags = 1;
            }
            return clFlags;
        }
    }
}

