/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLProperty;
import com.jogamp.opencl.CLVersion;
import com.jogamp.opencl.impl.CLTLAccessorFactory;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLImpl11;
import com.jogamp.opencl.llb.impl.CLImpl12;
import com.jogamp.opencl.llb.impl.CLImpl20;
import com.jogamp.opencl.spi.CLAccessorFactory;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.spi.CLPlatformInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import com.jogamp.opencl.util.Filter;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class CLPlatform {
    public final long ID;
    public final CLVersion version;
    protected static CL cl;
    private static CLAccessorFactory defaultFactory;
    private final CLAccessorFactory factory;
    private Set<String> extensions;
    protected final CLPlatformInfoAccessor info;

    private CLPlatform(long id) {
        this(id, null);
    }

    protected CLPlatform(long id, CLAccessorFactory factory) {
        CLPlatform.initialize();
        this.ID = id;
        this.factory = factory == null ? defaultFactory : factory;
        this.info = this.factory.createPlatformInfoAccessor(cl, id);
        this.version = new CLVersion(this.getInfoString(2305));
    }

    public static boolean isAvailable() {
        return CLImpl11.isAvailable();
    }

    public static void initialize() throws JogampRuntimeException {
        CLPlatform.initialize(null);
    }

    static synchronized void initialize(CLAccessorFactory factory) throws JogampRuntimeException {
        if (cl != null) {
            return;
        }
        if (defaultFactory == null) {
            defaultFactory = factory == null ? new CLTLAccessorFactory() : factory;
        }
        if (!CLImpl11.isAvailable()) {
            throw new JogampRuntimeException("JOCL is not available");
        }
        cl = new CLImpl11();
    }

    public static CLPlatform getDefault() {
        CLPlatform.initialize();
        return CLPlatform.latest(CLPlatform.listCLPlatforms());
    }

    public static CLPlatform getDefault(Filter<CLPlatform> ... filter) {
        CLPlatform[] platforms = CLPlatform.listCLPlatforms(filter);
        if (platforms.length > 0) {
            return CLPlatform.latest(platforms);
        }
        return null;
    }

    private static CLPlatform latest(CLPlatform[] platforms) {
        CLPlatform best = platforms[0];
        for (CLPlatform platform : platforms) {
            if (platform.version.compareTo(best.version) <= 0) continue;
            best = platform;
        }
        return best;
    }

    public static CLPlatform[] listCLPlatforms() {
        return CLPlatform.listCLPlatforms(null);
    }

    public static CLPlatform[] listCLPlatforms(Filter<CLPlatform> ... filter) {
        CLPlatform.initialize();
        IntBuffer ib = Buffers.newDirectIntBuffer((int)1);
        int ret = cl.clGetPlatformIDs(0, null, ib);
        CLException.checkForError(ret, "can not enumerate platforms");
        PointerBuffer platformId = PointerBuffer.allocateDirect((int)ib.get(0));
        ret = cl.clGetPlatformIDs(platformId.capacity(), platformId, null);
        CLException.checkForError(ret, "can not enumerate platforms");
        ArrayList platforms = new ArrayList();
        for (int i = 0; i < platformId.capacity(); ++i) {
            CLPlatform platform = new CLPlatform(platformId.get(i));
            CLPlatform.addIfAccepted(platform, platforms, filter);
        }
        return platforms.toArray(new CLPlatform[platforms.size()]);
    }

    public static CL getLowLevelCLInterface() {
        CLPlatform.initialize();
        return cl;
    }

    public static CL getLowLevelCLInterfaceForDevice(long device) {
        CLPlatform.initialize();
        CLInfoAccessor deviceInfo = defaultFactory.createDeviceInfoAccessor(cl, device);
        CLVersion version = new CLVersion(deviceInfo.getString(4143));
        if (version.isEqual(CLVersion.CL_1_2)) {
            return new CLImpl12();
        }
        if (version.isEqual(CLVersion.CL_2_0)) {
            return new CLImpl20();
        }
        return cl;
    }

    public static void unloadCompiler() {
        CLPlatform.initialize();
        int ret = cl.clUnloadCompiler();
        CLException.checkForError(ret, "error while sending unload compiler hint");
    }

    public CLDevice[] listCLDevices() {
        try {
            return this.listCLDevices(CLDevice.Type.ALL);
        }
        catch (CLException.CLInvalidDeviceTypeException ignore) {
            return this.listCLDevices(CLDevice.Type.GPU);
        }
    }

    public CLDevice[] listCLDevices(CLDevice.Type ... types) {
        CLPlatform.initialize();
        ArrayList<CLDevice> list = new ArrayList<CLDevice>();
        for (int t = 0; t < types.length; ++t) {
            CLDevice.Type type = types[t];
            long[] deviceIDs = this.info.getDeviceIDs(type.TYPE);
            for (int n = 0; n < deviceIDs.length; ++n) {
                list.add(this.createDevice(deviceIDs[n]));
            }
        }
        return list.toArray(new CLDevice[list.size()]);
    }

    public CLDevice[] listCLDevices(Filter<CLDevice> ... filters) {
        CLPlatform.initialize();
        ArrayList list = new ArrayList();
        long[] deviceIDs = this.info.getDeviceIDs(0xFFFFFFFFL);
        for (int n = 0; n < deviceIDs.length; ++n) {
            CLDevice device = this.createDevice(deviceIDs[n]);
            CLPlatform.addIfAccepted(device, list, filters);
        }
        return list.toArray(new CLDevice[list.size()]);
    }

    protected CLDevice createDevice(long id) {
        return new CLDevice(this, id);
    }

    private static <I> void addIfAccepted(I item, List<I> list, Filter<I>[] filters) {
        if (filters == null) {
            list.add(item);
        } else {
            boolean accepted = true;
            for (Filter<I> filter : filters) {
                if (filter.accept(item)) continue;
                accepted = false;
                break;
            }
            if (accepted) {
                list.add(item);
            }
        }
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices) {
        return CLPlatform.findMaxFlopsDevice(devices, null);
    }

    static CLDevice findMaxFlopsDevice(CLDevice[] devices, CLDevice.Type type) {
        CLPlatform.initialize();
        CLDevice maxFLOPSDevice = null;
        int maxflops = -1;
        for (int i = 0; i < devices.length; ++i) {
            int maxClockFrequency;
            int maxComputeUnits;
            int flops;
            CLDevice device = devices[i];
            if (type != null && !type.equals((Object)device.getType()) || (flops = (maxComputeUnits = device.getMaxComputeUnits()) * (maxClockFrequency = device.getMaxClockFrequency())) <= maxflops) continue;
            maxflops = flops;
            maxFLOPSDevice = device;
        }
        return maxFLOPSDevice;
    }

    public CLDevice getMaxFlopsDevice() {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices());
    }

    public CLDevice getMaxFlopsDevice(CLDevice.Type ... types) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(types));
    }

    public CLDevice getMaxFlopsDevice(Filter<CLDevice> ... filter) {
        return CLPlatform.findMaxFlopsDevice(this.listCLDevices(filter));
    }

    @CLProperty(value="CL_PLATFORM_NAME")
    public String getName() {
        return this.getInfoString(2306);
    }

    @CLProperty(value="CL_PLATFORM_VERSION")
    public CLVersion getVersion() {
        return this.version;
    }

    public String getSpecVersion() {
        return this.version.getSpecVersion();
    }

    public boolean isAtLeast(CLVersion other) {
        return this.version.isAtLeast(other);
    }

    public boolean isAtLeast(int major, int minor) {
        return this.version.isAtLeast(major, minor);
    }

    @CLProperty(value="CL_PLATFORM_PROFILE")
    public String getProfile() {
        return this.getInfoString(2304);
    }

    @CLProperty(value="CL_PLATFORM_VENDOR")
    public String getVendor() {
        return this.getInfoString(2307);
    }

    public boolean isVendorAMD() {
        return this.getVendor().contains("Advanced Micro Devices");
    }

    public boolean isVendorIntel() {
        return this.getVendor().contains("Intel");
    }

    @CLProperty(value="CL_PLATFORM_ICD_SUFFIX_KHR")
    public String getICDSuffix() {
        return this.getInfoString(2336);
    }

    public boolean isExtensionAvailable(String extension) {
        return this.getExtensions().contains(extension);
    }

    @CLProperty(value="CL_PLATFORM_EXTENSIONS")
    public synchronized Set<String> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<String>();
            String ext = this.getInfoString(2308);
            Scanner scanner = new Scanner(ext);
            while (scanner.hasNext()) {
                this.extensions.add(scanner.next());
            }
            scanner.close();
            this.extensions = Collections.unmodifiableSet(this.extensions);
        }
        return this.extensions;
    }

    public Map<String, String> getProperties() {
        return CLUtil.obtainPlatformProperties(this);
    }

    public final String getInfoString(int key) {
        return this.info.getString(key);
    }

    final CLAccessorFactory getAccessorFactory() {
        return this.factory;
    }

    public final CLPlatformInfoAccessor getCLAccessor() {
        return this.info;
    }

    protected CL getCLBinding() {
        return cl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [name: " + this.getName() + ", vendor: " + this.getVendor() + ", profile: " + this.getProfile() + ", version: " + this.getVersion() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CLPlatform other = (CLPlatform)obj;
        return this.ID == other.ID;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + (int)(this.ID ^ this.ID >>> 32);
        return hash;
    }
}

