/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.opencl.CLContext;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLImage;
import com.jogamp.opencl.CLImage2d;
import com.jogamp.opencl.CLImageFormat;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLObject;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.llb.impl.CLImageFormatImpl;
import com.jogamp.opengl.GLContext;
import java.nio.Buffer;

public class CLGLImage2d<B extends Buffer>
extends CLImage2d<B>
implements CLGLObject {
    public final int GLID;

    protected CLGLImage2d(CLContext context, B directBuffer, CLImageFormat format, CLImage.CLImageInfoAccessor accessor, int width, int height, long id, int glid, int flags) {
        super(context, directBuffer, format, accessor, width, height, id, flags);
        this.GLID = glid;
    }

    static <B extends Buffer> CLGLImage2d<B> createFromGLRenderbuffer(CLContext context, B directBuffer, int flags, int renderbuffer) {
        CLGLBuffer.checkBuffer(directBuffer, flags);
        CL cl = CLGLImage2d.getCL(context);
        int[] result = new int[1];
        long id = cl.clCreateFromGLRenderbuffer(context.ID, flags, renderbuffer, result, 0);
        CLException.checkForError(result[0], "can not create CLGLImage2d from renderbuffer #" + renderbuffer + ".");
        return CLGLImage2d.createImage(context, id, directBuffer, renderbuffer, flags);
    }

    static <B extends Buffer> CLGLImage2d<B> createImage(CLContext context, long id, B directBuffer, int glObject, int flags) {
        CLImage.CLImageInfoAccessor accessor = new CLImage.CLImageInfoAccessor(CLGLImage2d.getCL(context), id);
        CLImageFormat format = CLGLImage2d.createUninitializedImageFormat();
        accessor.getInfo(4368, CLImageFormatImpl.size(), format.getFormatImpl().getBuffer(), null);
        int width = (int)accessor.getLong(4372);
        int height = (int)accessor.getLong(4373);
        return new CLGLImage2d<B>(context, directBuffer, format, accessor, width, height, id, glObject, flags);
    }

    @Override
    public CLMemory.GLObjectType getGLObjectType() {
        return CLMemory.GLObjectType.GL_OBJECT_RENDERBUFFER;
    }

    @Override
    public int getGLObjectID() {
        return this.GLID;
    }

    @Override
    public CLGLContext getContext() {
        return (CLGLContext)super.getContext();
    }

    @Override
    public GLContext getGLContext() {
        return this.getContext().getGLContext();
    }
}

