/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.impl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.Bitstream;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.spi.CLInfoAccessor;
import com.jogamp.opencl.util.CLUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class CLTLInfoAccessor
implements CLInfoAccessor {
    private static final int BB_SIZE = 512;
    protected static final ThreadLocal<ByteBuffer> localBB = new ThreadLocal<ByteBuffer>(){

        @Override
        protected ByteBuffer initialValue() {
            return Buffers.newDirectByteBuffer((int)512);
        }
    };
    protected static final ThreadLocal<PointerBuffer> localNSB = new ThreadLocal<PointerBuffer>(){

        @Override
        protected PointerBuffer initialValue() {
            return PointerBuffer.allocateDirect((int)1);
        }
    };

    @Override
    public final long getUInt32Long(int key) {
        ByteBuffer buffer = this.getBB(4).putInt(0, 0);
        int ret = this.getInfo(key, 4L, buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        return Bitstream.toUInt32Long((int)buffer.getInt(0));
    }

    @Override
    public final long getLong(int key) {
        ByteBuffer buffer = this.getBB(8).putLong(0, 0L);
        int ret = this.getInfo(key, 8L, buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        return buffer.getLong(0);
    }

    @Override
    public final String getString(int key) {
        PointerBuffer sizeBuffer = this.getNSB();
        int ret = this.getInfo(key, 0L, null, sizeBuffer);
        CLException.checkForError(ret, "error while asking for info string");
        int clSize = (int)sizeBuffer.get(0);
        ByteBuffer buffer = this.getBB(clSize);
        ret = this.getInfo(key, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "error while asking for info string");
        byte[] array = new byte[clSize];
        buffer.get(array).rewind();
        return CLUtil.clString2JavaString(array, clSize);
    }

    @Override
    public final int[] getInts(int key, int n) {
        ByteBuffer buffer = this.getBB(n * (Platform.is32Bit() ? 4 : 8));
        int ret = this.getInfo(key, buffer.capacity(), buffer, null);
        CLException.checkForError(ret, "error while asking for info value");
        int[] array = new int[n];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Platform.is32Bit() ? buffer.getInt() : (int)buffer.getLong();
        }
        buffer.rewind();
        return array;
    }

    protected ByteBuffer getBB(int minCapacity) {
        if (minCapacity > 512) {
            return Buffers.newDirectByteBuffer((int)minCapacity);
        }
        return localBB.get();
    }

    protected PointerBuffer getNSB() {
        return localNSB.get();
    }

    protected abstract int getInfo(int var1, long var2, Buffer var4, PointerBuffer var5);
}

