/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.util.color.AbstractDockColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class LinePainter
implements TabPanePainter {
    private AbstractDockColor color = new AbstractDockColor("stack.border", DockColor.KIND_DOCK_COLOR, Color.BLACK){

        protected void changed(Color oldColor, Color newColor) {
            LinePainter.this.pane.repaint();
        }
    };
    private EclipseTabPane pane;

    public LinePainter(EclipseTabPane pane) {
        this.pane = pane;
    }

    public void setController(DockController controller) {
        ColorManager colors = controller == null ? null : controller.getColors();
        this.color.setManager(colors);
    }

    public void paintBackground(Graphics g) {
    }

    public void paintForeground(Graphics g) {
        Dockable selection = this.pane.getSelectedDockable();
        if (selection == null) {
            return;
        }
        EclipseTab tab = (EclipseTab)this.pane.getTab(selection);
        if (tab == null || !tab.isPaneVisible()) {
            return;
        }
        Rectangle bounds = tab.getBounds();
        Rectangle available = this.pane.getAvailableArea();
        g.setColor((Color)this.color.value());
        switch (this.pane.getDockTabPlacement()) {
            case TOP_OF_DOCKABLE: {
                this.paintHorizontal(g, available, bounds, bounds.y + bounds.height - 1);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                this.paintHorizontal(g, available, bounds, bounds.y);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                this.paintVertical(g, available, bounds, bounds.x + bounds.width - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.paintVertical(g, available, bounds, bounds.x);
            }
        }
    }

    private void paintHorizontal(Graphics g, Rectangle available, Rectangle bounds, int y) {
        if (available.x < bounds.x - 1) {
            g.drawLine(available.x, y, bounds.x - 1, y);
        }
        if (available.x + available.width > bounds.x + bounds.width) {
            g.drawLine(available.x + available.width, y, bounds.x + bounds.width, y);
        }
    }

    private void paintVertical(Graphics g, Rectangle available, Rectangle bounds, int x) {
        if (available.y < bounds.y - 1) {
            g.drawLine(x, available.y, x, bounds.y - 1);
        }
        if (available.y + available.height > bounds.y + bounds.height) {
            g.drawLine(x, available.y + available.height, x, bounds.y + bounds.height);
        }
    }
}

