/*
 * Decompiled with CFR 0.152.
 */
package cadex.Collections;

import cadex.CadExMTKJNI;
import cadex.ModelData.Instance;
import java.util.AbstractList;
import java.util.RandomAccess;

public class InstanceList
extends AbstractList<Instance>
implements RandomAccess {
    private transient long swigCPtr;
    public transient boolean swigCMemOwn;

    public InstanceList(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(InstanceList obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(InstanceList obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    public void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_std_InstanceList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public InstanceList(Instance[] initialElements) {
        this();
        this.reserve(initialElements.length);
        for (Instance element : initialElements) {
            this.add(element);
        }
    }

    public InstanceList(Iterable<Instance> initialElements) {
        this();
        for (Instance element : initialElements) {
            this.add(element);
        }
    }

    @Override
    public Instance get(int index) {
        return this.doGet(index);
    }

    @Override
    public Instance set(int index, Instance e) {
        return this.doSet(index, e);
    }

    @Override
    public boolean add(Instance e) {
        ++this.modCount;
        this.doAdd(e);
        return true;
    }

    @Override
    public void add(int index, Instance e) {
        ++this.modCount;
        this.doAdd(index, e);
    }

    @Override
    public Instance remove(int index) {
        ++this.modCount;
        return this.doRemove(index);
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        this.doRemoveRange(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public InstanceList() {
        this(CadExMTKJNI.new_std_InstanceList__SWIG_0(), true);
    }

    public InstanceList(InstanceList other) {
        this(CadExMTKJNI.new_std_InstanceList__SWIG_1(InstanceList.getCPtr(other), other), true);
    }

    @Override
    public boolean isEmpty() {
        return CadExMTKJNI.std_InstanceList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        CadExMTKJNI.std_InstanceList_clear(this.swigCPtr, this);
    }

    public InstanceList(int count, Instance value) {
        this(CadExMTKJNI.new_std_InstanceList__SWIG_2(count, Instance.getCPtr(value), value), true);
    }

    private int doCapacity() {
        return CadExMTKJNI.std_InstanceList_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        CadExMTKJNI.std_InstanceList_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return CadExMTKJNI.std_InstanceList_doSize(this.swigCPtr, this);
    }

    private void doAdd(Instance x) {
        CadExMTKJNI.std_InstanceList_doAdd__SWIG_0(this.swigCPtr, this, Instance.getCPtr(x), x);
    }

    private void doAdd(int index, Instance x) {
        CadExMTKJNI.std_InstanceList_doAdd__SWIG_1(this.swigCPtr, this, index, Instance.getCPtr(x), x);
    }

    private Instance doRemove(int index) {
        return new Instance(CadExMTKJNI.std_InstanceList_doRemove(this.swigCPtr, this, index), true);
    }

    private Instance doGet(int index) {
        return new Instance(CadExMTKJNI.std_InstanceList_doGet(this.swigCPtr, this, index), false);
    }

    private Instance doSet(int index, Instance val) {
        return new Instance(CadExMTKJNI.std_InstanceList_doSet(this.swigCPtr, this, index, Instance.getCPtr(val), val), true);
    }

    private void doRemoveRange(int fromIndex, int toIndex) {
        CadExMTKJNI.std_InstanceList_doRemoveRange(this.swigCPtr, this, fromIndex, toIndex);
    }
}

