/*
 * Decompiled with CFR 0.152.
 */
package cadex.Drawing;

import cadex.BaseObject;
import cadex.CadExMTKJNI;
import cadex.Drawing.Element;
import cadex.Drawing.ElementVisitor;
import cadex.Drawing.Ratio;
import cadex.Geom.Axis2d;
import cadex.Uuid;
import java.nio.ByteBuffer;
import java.util.UUID;

public class View
extends BaseObject {
    private transient long swigCPtr;

    public View(long cPtr, boolean cMemoryOwn) {
        super(CadExMTKJNI.cadex_Drawing_View_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public static long getCPtr(View obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public static long swigRelease(View obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    @Override
    public void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CadExMTKJNI.delete_cadex_Drawing_View(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public View() {
        this(CadExMTKJNI.new_cadex_Drawing_View__SWIG_0(), true);
    }

    public View(Axis2d thePosition) {
        this(CadExMTKJNI.new_cadex_Drawing_View__SWIG_1(Axis2d.getCPtr(thePosition), thePosition), true);
    }

    public void SetUuid(UUID theUuid) {
        Uuid temptheUuid = new Uuid(theUuid.getMostSignificantBits(), theUuid.getLeastSignificantBits());
        CadExMTKJNI.cadex_Drawing_View_SetUuid(this.swigCPtr, this, Uuid.getCPtr(temptheUuid), temptheUuid);
    }

    public UUID Uuid() {
        Uuid ret = new Uuid(CadExMTKJNI.cadex_Drawing_View_Uuid(this.swigCPtr, this), true);
        if (!ret.IsNull()) {
            byte[] aBytes = new byte[16];
            for (int i = 0; i < 16; ++i) {
                aBytes[i] = (byte)ret.Value(i);
            }
            ByteBuffer bb = ByteBuffer.wrap(aBytes);
            long mostSigBits = bb.getLong();
            long leastSigBits = bb.getLong();
            return new UUID(mostSigBits, leastSigBits);
        }
        return new UUID(0L, 0L);
    }

    public Axis2d Position() {
        return new Axis2d(CadExMTKJNI.cadex_Drawing_View_Position(this.swigCPtr, this), true);
    }

    public void SetPosition(Axis2d thePosition) {
        CadExMTKJNI.cadex_Drawing_View_SetPosition(this.swigCPtr, this, Axis2d.getCPtr(thePosition), thePosition);
    }

    public Ratio Scale() {
        return new Ratio(CadExMTKJNI.cadex_Drawing_View_Scale(this.swigCPtr, this), true);
    }

    public void SetScale(Ratio theScale) {
        CadExMTKJNI.cadex_Drawing_View_SetScale(this.swigCPtr, this, Ratio.getCPtr(theScale), theScale);
    }

    public long NumberOfElements() {
        return CadExMTKJNI.cadex_Drawing_View_NumberOfElements(this.swigCPtr, this);
    }

    public void Add(Element theElement) {
        CadExMTKJNI.cadex_Drawing_View_Add(this.swigCPtr, this, Element.getCPtr(theElement), theElement);
    }

    public void Accept(ElementVisitor theVisitor) {
        CadExMTKJNI.cadex_Drawing_View_Accept(this.swigCPtr, this, ElementVisitor.getCPtr(theVisitor), theVisitor);
    }

    public static boolean CompareType(BaseObject theObject) {
        return CadExMTKJNI.cadex_Drawing_View_CompareType(BaseObject.getCPtr(theObject), theObject);
    }

    public static View Cast(BaseObject theBase) {
        return new View(CadExMTKJNI.cadex_Drawing_View_Cast(BaseObject.getCPtr(theBase), theBase), true);
    }

    public static class ElementIterator
    extends BaseObject {
        private transient long swigCPtr;

        public ElementIterator(long cPtr, boolean cMemoryOwn) {
            super(CadExMTKJNI.cadex_Drawing_View_ElementIterator_SWIGUpcast(cPtr), cMemoryOwn);
            this.swigCPtr = cPtr;
        }

        public static long getCPtr(ElementIterator obj) {
            return obj == null ? 0L : obj.swigCPtr;
        }

        public static long swigRelease(ElementIterator obj) {
            long ptr = 0L;
            if (obj != null) {
                if (!obj.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                ptr = obj.swigCPtr;
                obj.swigCMemOwn = false;
                obj.delete();
            }
            return ptr;
        }

        @Override
        public void finalize() {
            this.delete();
        }

        @Override
        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    CadExMTKJNI.delete_cadex_Drawing_View_ElementIterator(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
            super.delete();
        }

        public ElementIterator(View theView) {
            this(CadExMTKJNI.new_cadex_Drawing_View_ElementIterator(View.getCPtr(theView), theView), true);
        }

        public boolean HasNext() {
            return CadExMTKJNI.cadex_Drawing_View_ElementIterator_HasNext(this.swigCPtr, this);
        }

        public Element Next() {
            return new Element(CadExMTKJNI.cadex_Drawing_View_ElementIterator_Next(this.swigCPtr, this), false);
        }
    }
}

